/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.server.karaf.ui.runtime;

import com.fusesource.rider.server.karaf.core.internal.KarafUtils;
import com.fusesource.rider.server.karaf.core.internal.runtime.IKarafRuntime;
import com.fusesource.rider.server.karaf.core.internal.server.IServerConfiguration;
import com.fusesource.rider.server.karaf.core.internal.server.IServerConfigurationWorkingCopy;
import com.fusesource.rider.server.karaf.ui.runtime.KarafServerPorpertiesComposite;
import com.fusesource.rider.server.karaf.ui.runtime.KarafWizardDataModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public abstract class AbstractKarafServerWizardFragment
extends WizardFragment {
    private KarafServerPorpertiesComposite composite = null;
    protected KarafWizardDataModel model = null;

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.getWizardModel();
        this.composite = new KarafServerPorpertiesComposite(parent, handle, this.model);
        this.composite.createContents();
        return this.composite;
    }

    public boolean hasComposite() {
        return true;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        super.performFinish(monitor);
        this.composite.performFinish();
        this.updateServer();
    }

    private IRuntime getRuntimeWorkingCopy() {
        return (IRuntime)this.getTaskModel().getObject("runtime");
    }

    private IServerWorkingCopy getServerWorkingCopy() {
        return (IServerWorkingCopy)this.getTaskModel().getObject("server");
    }

    private void getWizardModel() {
        Object objModel = this.getTaskModel().getObject("karaf-model");
        this.model = objModel instanceof KarafWizardDataModel ? (KarafWizardDataModel)objModel : new KarafWizardDataModel();
        this.populateModel();
    }

    private void populateModel() {
        IServerWorkingCopy workingCopy = this.getServerWorkingCopy();
        if (this.model != null && workingCopy != null) {
            IKarafRuntime karafRuntime;
            IServerConfiguration karafServerWorkingCopy = (IServerConfiguration)workingCopy.loadAdapter(IServerConfiguration.class, (IProgressMonitor)new NullProgressMonitor());
            if (karafServerWorkingCopy != null) {
                this.model.setUserName(karafServerWorkingCopy.getUserName());
                this.model.setPassword(karafServerWorkingCopy.getPassword());
            }
            boolean readFromConfFile = false;
            IRuntime runtime = this.getRuntimeWorkingCopy();
            if (runtime != null && (karafRuntime = (IKarafRuntime)runtime.loadAdapter(IKarafRuntime.class, null)) != null) {
                File confFile;
                if ("".equals(this.model.getKarafInstallDir()) || this.model.getKarafInstallDir() == null) {
                    this.model.setKarafInstallDir(karafRuntime.getKarafInstallDir());
                    this.model.setKarafPropertiesFileLocation(karafRuntime.getKarafPropertiesFileLocation());
                    this.model.setKarafVersion(this.determineVersion(karafRuntime));
                }
                if ((confFile = new File(this.model.getKarafPropertiesFileLocation())) != null && confFile.exists()) {
                    try {
                        this.readFromPropertiesFile(confFile);
                        readFromConfFile = true;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (!readFromConfFile && karafServerWorkingCopy != null) {
                this.model.setHostName(karafServerWorkingCopy.getHostName());
                this.model.setPortNumber(karafServerWorkingCopy.getPortNumber());
            }
        }
    }

    private void updateServer() {
        IServerConfigurationWorkingCopy karafServerWorkingCopy;
        IServerWorkingCopy workingCopy = this.getServerWorkingCopy();
        if (workingCopy != null && (karafServerWorkingCopy = (IServerConfigurationWorkingCopy)workingCopy.loadAdapter(IServerConfigurationWorkingCopy.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
            karafServerWorkingCopy.setHostName(this.model.getHostName());
            karafServerWorkingCopy.setPortNumber(this.model.getPortNumber());
            karafServerWorkingCopy.setUserName(this.model.getUserName());
            karafServerWorkingCopy.setPassword(this.model.getPassword());
            workingCopy.setName(new File(this.model.getKarafInstallDir()).getName());
            try {
                workingCopy.save(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected abstract void readFromPropertiesFile(File var1) throws FileNotFoundException, IOException, NumberFormatException;

    protected String determineVersion(IKarafRuntime runtime) {
        File folder;
        String version = null;
        if (runtime != null && runtime.getKarafInstallDir() != null && (folder = new File(runtime.getKarafInstallDir())).exists() && folder.isDirectory()) {
            version = KarafUtils.getVersion((File)folder);
        }
        return version;
    }

    public boolean isComplete() {
        return this.composite.isValid();
    }
}

