/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.server.karaf.ui.runtime.fuseesb7x;

import com.fusesource.rider.server.karaf.core.internal.FuseESBUtils;
import com.fusesource.rider.server.karaf.ui.Messages;
import com.fusesource.rider.server.karaf.ui.runtime.KarafWizardDataModel;
import com.fusesource.rider.server.karaf.ui.runtime.v2x.KarafRuntimeComposite2x;
import java.io.File;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class FuseESBRuntimeComposite7x
extends KarafRuntimeComposite2x {
    protected static final String CONF_FOLDER = "etc";
    protected static final String CONF_FILE_NAME = "org.apache.karaf.shell.cfg";
    public static final String CONF_FILE = String.format("%s%s%s", "etc", SEPARATOR, "org.apache.karaf.shell.cfg");
    protected static final String LIB_FOLDER = "lib";
    protected static final String LIB_BIN_FOLDER = String.format("%s%s%s", "lib", SEPARATOR, "bin");
    protected static final String LIB_KARAF_JAR = String.format("%s%s%s", "lib", SEPARATOR, "karaf.jar");
    protected static final String LIB_KARAF_JAAS_JAR = String.format("%s%s%s", "lib", SEPARATOR, "karaf-jaas-boot.jar");
    protected static final String LIB_KARAF_CLIENT_JAR = String.format("%s%s%s", LIB_BIN_FOLDER, SEPARATOR, "karaf-client.jar");
    private static final String LIB_ESB_VERSION_JAR = String.format("%s%s%s", "lib", SEPARATOR, "esb-version.jar");

    public FuseESBRuntimeComposite7x(Composite parent, IWizardHandle wizardHandle, KarafWizardDataModel model) {
        super(parent, wizardHandle, model);
        wizardHandle.setTitle(Messages.FuseESBRuntimeComposite_wizard_tite);
        wizardHandle.setDescription(Messages.FuseESBRuntimeComposite_wizard_desc);
    }

    @Override
    protected boolean doClassPathEntiresExist(String karafInstallDir) {
        File libESBVersionJar = new File(String.format("%s%s%s", karafInstallDir, SEPARATOR, LIB_ESB_VERSION_JAR));
        return super.doClassPathEntiresExist(karafInstallDir) && libESBVersionJar.exists();
    }

    @Override
    public boolean validate() {
        this.valid = false;
        String dirLocation = this.txtKarafDir.getText().trim();
        if (dirLocation != null && !"".equals(dirLocation)) {
            File file = new File(dirLocation);
            if (!file.exists()) {
                this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_no_dir, 3);
            } else if (!file.isDirectory()) {
                this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_not_a_dir, 3);
            } else {
                File binFuseESB = new File(String.valueOf(dirLocation) + SEPARATOR + Messages.FuseESBRuntimeComposite_bin_fuseesb);
                File binFuseESBBat = new File(String.valueOf(dirLocation) + SEPARATOR + Messages.FuseESBRuntimeComposite_bin_fuseesb_bat);
                File confFile = new File(this.getKarafPropFileLocation(dirLocation));
                if ((binFuseESB.exists() || binFuseESBBat.exists()) && confFile.exists() && this.doClassPathEntiresExist(dirLocation)) {
                    this.valid = true;
                    this.wizardHandle.setMessage("", 0);
                } else {
                    this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_invalid_dir, 3);
                }
            }
        } else {
            this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_wizard_help_msg, 0);
        }
        return this.valid;
    }

    @Override
    public void handleEvent(Event event) {
        boolean valid = false;
        if (event.type == 15) {
            this.handleFocusEvent(event);
        } else if (event.widget == this.txtKarafDir && (valid = this.validate())) {
            String installDir = this.txtKarafDir.getText();
            this.model.setKarafInstallDir(installDir);
            this.model.setKarafPropertiesFileLocation(this.getKarafPropFileLocation(installDir));
            this.model.setKarafVersion(FuseESBUtils.getVersion((File)new File(installDir)));
        }
        this.wizardHandle.update();
    }
}

