/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.NewResourceFileDialog;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;

public class PropertiesFileFormProvider
extends AbstractFormHandleProvider {
    private static final int[] COLUMN_WIDTHS = new int[]{300};
    private static final String[] COLUMNS = new String[]{Messages.getString((String)"PropertiesFileFormProvider.Column.Name")};
    private static final String TITLE = Messages.getString((String)"ReportPageGenerator.List.Resources.PropertiesFile");
    private static final String EMPTY_STRING = "";
    private ModuleHandle inputElement;

    public String[] getColumnNames() {
        return COLUMNS;
    }

    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    public String getDisplayName() {
        return TITLE;
    }

    public CellEditor[] getEditors(Table table) {
        return null;
    }

    public boolean doMoveItem(int oldPos, int newPos) throws Exception {
        List resources = this.inputElement.getIncludeResources();
        String resource = (String)resources.get(oldPos);
        resources.remove(oldPos);
        resources.add(newPos, resource);
        this.inputElement.setIncludeResources(resources);
        return true;
    }

    public boolean doDeleteItem(int pos) throws Exception {
        if (this.getElements(this.inputElement).length <= 0) {
            return false;
        }
        List resources = this.inputElement.getIncludeResources();
        if (resources != null && resources.size() > pos) {
            resources.remove(pos);
            this.inputElement.setIncludeResources(resources);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doAddItem(int pos) throws Exception {
        NewResourceFileDialog dialog = new NewResourceFileDialog();
        if (dialog.open() != 0) {
            return false;
        }
        Object[] selection = dialog.getResult();
        int length = selection.length;
        int i = 0;
        while (i < length) {
            ArrayList<String> resources;
            String path = dialog.getPath();
            if (path.lastIndexOf(".") > 0) {
                path = path.substring(0, path.lastIndexOf("."));
            }
            if (this.inputElement.getIncludeResources() != null) {
                resources = this.inputElement.getIncludeResources();
                if (resources.contains(path)) return false;
                resources.add(path);
                this.inputElement.setIncludeResources(resources);
            } else {
                resources = new ArrayList<String>();
                resources.add(path);
                this.inputElement.setIncludeResources(resources);
            }
            ++i;
        }
        return true;
    }

    public boolean doEditItem(int pos) {
        return false;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof String && columnIndex == 0) {
            return (String)element;
        }
        return EMPTY_STRING;
    }

    public Image getImage(Object element, int columnIndex) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList list = new ArrayList();
        if (inputElement instanceof List) {
            inputElement = ((List)inputElement).get(0);
        }
        if (inputElement instanceof ModuleHandle) {
            this.inputElement = (ModuleHandle)inputElement;
            list = (ArrayList)((ModuleHandle)inputElement).getIncludeResources();
            if (list == null || list.size() == 0) {
                return new String[0];
            }
        }
        return list.toArray();
    }

    public boolean canModify(Object element, String property) {
        return false;
    }

    public Object getValue(Object element, String property) {
        return null;
    }

    public boolean modify(Object data, String property, Object value) throws Exception {
        return false;
    }

    public boolean needRefreshed(NotificationEvent event) {
        if (!(event instanceof PropertyEvent)) {
            return false;
        }
        PropertyEvent propertyEvent = (PropertyEvent)event;
        return propertyEvent.getPropertyName().equals("includeResource");
    }
}

