/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.ITextDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ImageBuilder;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class ReferenceDescriptorProvider
extends AbstractDescriptorProvider
implements ITextDescriptorProvider {
    private String property;
    private boolean isEnableButton;
    private Object input;

    public boolean isEditable() {
        return false;
    }

    public String getDisplayName() {
        return Messages.getString((String)"ReferencePage.Label.Source");
    }

    public boolean isEnableButton() {
        return this.isEnableButton;
    }

    public Object load() {
        String source = ((ImageHandle)DEUtil.getInputFirstElement((Object)this.input)).getSource();
        this.property = source.equals("embed") ? "imageName" : (source.equals("expr") ? "valueExpr" : "uri");
        return this.getStringValue();
    }

    public void handleSelectEvent() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        ImageBuilder dialog = new ImageBuilder(UIUtil.getDefaultShell(), ImageBuilder.DLG_TITLE_EDIT);
        dialog.setInput(DEUtil.getInputFirstElement((Object)this.input));
        stack.startTrans(Messages.getString((String)"ImageEditPart.trans.editImage"));
        if (dialog.open() == 0) {
            stack.commit();
        } else {
            stack.rollback();
        }
    }

    public void setInput(Object input) {
        this.input = input;
    }

    private String getStringValue() {
        String value = null;
        if (this.input instanceof GroupElementHandle) {
            value = ((GroupElementHandle)this.input).getStringProperty(this.property);
        } else if (this.input instanceof List) {
            value = DEUtil.getGroupElementHandle((List)((List)this.input)).getStringProperty(this.property);
        }
        this.isEnableButton = value != null;
        return value == null ? "" : value;
    }

    public void save(Object value) throws SemanticException {
    }
}

