/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.TabbedPropertyTitle;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFormHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormPropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FormSection
extends Section {
    boolean isTabbed = false;
    private boolean showLabel = false;
    protected FormPropertyDescriptor form;
    protected TabbedPropertyTitle title;
    private FormPropertyDescriptor customForm;
    int displayLabelStyle = 512;
    IDescriptorProvider provider;
    private int height = -1;
    private int width = -1;
    boolean fillForm = false;
    private int style = -1;
    boolean withDialog = false;

    public FormSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    public FormSection(String labelText, Composite parent, boolean isFormStyle, boolean isTabbed) {
        super(labelText, parent, isFormStyle);
        this.isTabbed = isTabbed;
    }

    public void showDisplayLabel(boolean show) {
        this.showLabel = show;
    }

    public void createSection() {
        if (this.isTabbed) {
            this.getTitleControl(this.parent);
        } else if (this.showLabel) {
            this.getLabelControl(this.parent);
        }
        this.getFormControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public TabbedPropertyTitle getTitleControl() {
        return this.title;
    }

    protected TabbedPropertyTitle getTitleControl(Composite parent) {
        if (this.title == null) {
            this.title = new TabbedPropertyTitle(parent, FormWidgetFactory.getInstance());
            this.title.setLayoutData((Object)new GridData(768));
            this.title.setFont(parent.getFont());
            this.title.setLayoutData((Object)new GridData());
            String text = this.getLabelText();
            if (text != null) {
                this.title.setTitle(text, null);
            }
            this.title.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FormSection.this.title = null;
                }
            });
        } else {
            this.checkParent((Control)this.title, parent);
        }
        return this.title;
    }

    public FormPropertyDescriptor getFormControl() {
        return this.form;
    }

    protected FormPropertyDescriptor getFormControl(Composite parent) {
        if (this.form == null) {
            this.form = this.customForm != null ? this.customForm : DescriptorToolkit.createFormPropertyDescriptor(true);
            if (this.style != -1) {
                this.form.setStyle(this.style);
            }
            if (this.getProvider() != null) {
                this.form.setDescriptorProvider(this.getProvider());
            }
            this.form.setButtonWithDialog(this.withDialog);
            this.form.createControl(parent);
            this.form.getControl().setLayoutData((Object)new GridData());
            this.form.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FormSection.this.form = null;
                }
            });
        } else {
            this.checkParent(this.form.getControl(), parent);
        }
        return this.form;
    }

    public void setDisplayLabelStyle(int style) {
        this.displayLabelStyle = style;
    }

    public void layout() {
        GridData gd = (GridData)this.form.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - this.placeholder;
        if (this.displayLabel != null && (this.displayLabelStyle & 0x100) != 0) {
            --gd.horizontalSpan;
        }
        gd.horizontalAlignment = 4;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillForm;
        }
        if (this.height > -1) {
            gd.heightHint = this.height > this.form.getControl().computeSize((int)-1, (int)-1).y ? this.height : this.form.getControl().computeSize((int)-1, (int)-1).y;
            gd.grabExcessVerticalSpace = false;
        } else {
            gd.grabExcessVerticalSpace = this.fillForm;
        }
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        if (this.displayLabel != null) {
            if ((this.displayLabelStyle & 0x200) != 0) {
                gd = (GridData)this.displayLabel.getLayoutData();
                gd.horizontalSpan = ((GridLayout)this.parent.getLayout()).numColumns;
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalAlignment = 4;
            } else {
                gd = (GridData)this.displayLabel.getLayoutData();
                gd.verticalAlignment = 1;
            }
        }
        if (this.title != null) {
            gd = (GridData)this.title.getLayoutData();
            gd.horizontalSpan = ((GridLayout)this.parent.getLayout()).numColumns;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
        }
    }

    public void load() {
        if (this.form != null && !this.form.getControl().isDisposed()) {
            if (this.getProvider() instanceof AbstractFormHandleProvider) {
                ((AbstractFormHandleProvider)this.getProvider()).setReadOnly(this.isReadOnly());
            }
            this.form.load();
            this.setLabelText(this.getProvider().getDisplayName());
        }
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.form != null) {
            this.form.setDescriptorProvider(provider);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setInput(Object input) {
        assert (input != null);
        this.form.setInput(input);
    }

    public boolean isFillForm() {
        return this.fillForm;
    }

    public void setFillForm(boolean fillForm) {
        this.fillForm = fillForm;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, isHidden);
        }
        if (this.title != null) {
            WidgetUtil.setExcludeGridData((Control)this.title, isHidden);
        }
        if (this.form != null) {
            this.form.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.title != null) {
            this.title.setVisible(isVisible);
        }
        if (this.form != null) {
            this.form.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
        if (this.form != null) {
            this.form.setStyle(style);
        }
    }

    public void setButtonWithDialog(boolean withDialog) {
        this.withDialog = withDialog;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setCustomForm(FormPropertyDescriptor customForm) {
        this.customForm = customForm;
    }

    public void setButtonGroupIndex(int index) {
        this.customForm.setButtonGroupIndex(index);
    }
}

