/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BorderColorDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.ColorPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ColorBuilder;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.IPropertyDescriptor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ColorPropertyDescriptor
extends PropertyDescriptor
implements IPropertyDescriptor {
    protected ColorBuilder builder;
    private String value;

    public ColorPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }

    public void load() {
        boolean stateFlag;
        String strValue = this.getDescriptorProvider().load().toString();
        boolean bl = stateFlag = strValue == null == this.builder.getEnabled();
        if (stateFlag) {
            this.builder.setEnabled(strValue != null);
        }
        this.builder.setColorValue(strValue);
    }

    public Control getControl() {
        return this.builder;
    }

    public Control createControl(Composite parent) {
        this.builder = new ColorBuilder(parent, 0, this.isFormStyle());
        if (this.getDescriptorProvider() instanceof ColorPropertyDescriptorProvider) {
            this.builder.setChoiceSet(((ColorPropertyDescriptorProvider)this.getDescriptorProvider()).getElementChoiceSet());
        } else if (this.getDescriptorProvider() instanceof BorderColorDescriptorProvider) {
            this.builder.setChoiceSet(((BorderColorDescriptorProvider)this.getDescriptorProvider()).getElementChoiceSet());
        }
        this.builder.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ColorPropertyDescriptor.this.handleColorBuilderModifyEvent();
            }
        });
        if (this.value != null) {
            this.builder.setColorValue(this.value);
        }
        return this.builder;
    }

    public void setColorValue(String value) {
        if (this.builder != null) {
            this.builder.setColorValue(value);
        }
        this.value = value;
    }

    public RGB getColorValue() {
        if (this.builder != null) {
            return this.builder.getRGB();
        }
        return null;
    }

    protected void handleColorBuilderModifyEvent() {
        int oldValue = ColorUtil.parseColor((String)this.getDescriptorProvider().load().toString());
        ColorUtil.getRGBs((int)oldValue);
        RGB rgb = this.builder.getRGB();
        int colorValue = -1;
        if (rgb != null) {
            colorValue = ColorUtil.formRGB((int)rgb.red, (int)rgb.green, (int)rgb.blue);
        }
        if (oldValue == colorValue) {
            String colorString = this.getDescriptorProvider().load().toString();
            this.builder.setColorValue(colorString);
            return;
        }
        String value = this.builder.getPredefinedColor();
        if (value == null && rgb != null) {
            value = ColorUtil.format((int)colorValue, (int)0);
        }
        try {
            this.save(value);
        }
        catch (SemanticException e) {
            WidgetUtil.processError(this.builder.getShell(), (Exception)((Object)e));
        }
        if (rgb == null) {
            String colorString = this.getDescriptorProvider().load().toString();
            this.builder.setColorValue(colorString);
        }
    }

    public void save(Object value) throws SemanticException {
        this.descriptorProvider.save(value);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.builder, isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.builder.setVisible(isVisible);
    }
}

