/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.GroupPropertyHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.BackgroundImageCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.ComboBoxColorCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.ComboBoxDimensionCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.DateTimeCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.DimensionCellEditor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.widget.CTextCellEditor;
import org.eclipse.birt.report.designer.ui.widget.ComboBoxCellEditor;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;

public class PropertyEditorFactory {
    private static PropertyEditorFactory instance = new PropertyEditorFactory();
    private static String[] booleanValues = new String[]{"false", "true"};
    private static String[] booleanDisplayValues = new String[]{Messages.getString((String)"PropertyEditorFactory.Boolean.False"), Messages.getString((String)"PropertyEditorFactory.Boolean.True")};

    private PropertyEditorFactory() {
    }

    public static PropertyEditorFactory getInstance() {
        return instance;
    }

    public CellEditor createPropertyEditor(Composite parent, Object o) {
        ComboBoxCellEditor editor = null;
        String[] unitsList = null;
        GroupPropertyHandleProvider handle = GroupPropertyHandleProvider.getInstance();
        if (handle.isReadOnly(o)) {
            return null;
        }
        String[] values = this.getChoiceNames(o);
        String[] displayNames = this.getChoiceDisplayNames(o);
        String value = ((GroupPropertyHandle)o).getStringValue();
        if (value == null) {
            value = "";
        }
        if (handle.isBooleanProperty(o)) {
            editor = handle.isEditable(o) ? new ComboBoxCellEditor(parent, booleanDisplayValues, booleanValues, 0) : new ComboBoxCellEditor(parent, booleanDisplayValues, booleanValues, 8);
            editor.setValue((Object)value);
        } else if (handle.isColorProperty(o)) {
            editor = new ComboBoxColorCellEditor(parent, displayNames, values, 8);
            editor.setValue((Object)value);
        } else if (handle.isDateTimeProperty(o)) {
            editor = new DateTimeCellEditor(parent);
            editor.setValue((Object)value);
        } else if (handle.isFontSizeProperty(o)) {
            editor = new ComboBoxDimensionCellEditor(parent, displayNames, values);
            IChoiceSet choiceSet = DesignEngine.getMetaDataDictionary().getChoiceSet("units");
            unitsList = ChoiceSetFactory.getNamefromChoiceSet((IChoiceSet)choiceSet);
            ((ComboBoxDimensionCellEditor)editor).setUnitsList(unitsList);
            DimensionValue dimensionValue = null;
            try {
                dimensionValue = DimensionValue.parse((String)value);
                if (dimensionValue != null) {
                    editor.setValue((Object)dimensionValue.toDisplayString());
                    ((ComboBoxDimensionCellEditor)editor).setUnits(dimensionValue.getUnits());
                }
            }
            catch (PropertyValueException propertyValueException) {
                editor.setValue((Object)value);
            }
        } else if (handle.isDimensionProperty(o)) {
            IChoiceSet choiceSet = ((GroupPropertyHandle)o).getPropertyDefn().getAllowedUnits();
            values = ChoiceSetFactory.getNamefromChoiceSet((IChoiceSet)choiceSet);
            DimensionValue dimensionValue = null;
            try {
                dimensionValue = DimensionValue.parse((String)value);
            }
            catch (PropertyValueException propertyValueException) {}
            editor = handle.isEditable(o) ? new DimensionCellEditor(parent, values, 8) : new DimensionCellEditor(parent, values, 0);
            if (dimensionValue != null) {
                ((DimensionCellEditor)editor).setUnits(dimensionValue.getUnits());
                editor.setValue((Object)dimensionValue.toDisplayString());
            }
        } else if (handle.isElementRefValue(o)) {
            GroupPropertyHandle propertyHandle = (GroupPropertyHandle)o;
            List handles = propertyHandle.getReferenceableElementList();
            values = new String[handles.size()];
            int i = 0;
            while (i < handles.size()) {
                values[i] = ((DesignElementHandle)handles.get(i)).getQualifiedName();
                ++i;
            }
            ElementPropertyDefn propDefn = (ElementPropertyDefn)propertyHandle.getPropertyDefn();
            ElementDefn elementDefn = (ElementDefn)propDefn.getTargetElementType();
            assert (elementDefn != null);
            if ("Style".equals(elementDefn.getName())) {
                values = this.filterPreStyles(values);
            }
            editor = new ComboBoxCellEditor(parent, values);
            editor.setValue((Object)value);
        } else if (handle.isExpressionProperty(o)) {
            editor = new ExpressionCellEditor(parent, 8);
            editor.setValue(((GroupPropertyHandle)o).getValue());
        } else if (handle.isPassProperty(o)) {
            editor = new CTextCellEditor(parent, 0x400000);
            editor.setValue((Object)value);
        } else if (handle.isBackgroundImageProperty(o)) {
            editor = new BackgroundImageCellEditor(parent);
            editor.setValue((Object)value);
        } else if (displayNames.length > 0) {
            editor = handle.isEditable(o) ? new ComboBoxCellEditor(parent, displayNames, values, 0) : new ComboBoxCellEditor(parent, displayNames, values, 8);
            editor.setValue((Object)value);
        } else {
            editor = new CTextCellEditor(parent);
            editor.setValue((Object)value);
        }
        return editor;
    }

    private String[] getChoiceNames(Object o) {
        IChoice[] choices;
        String[] values = null;
        if (o instanceof GroupPropertyHandle && ((GroupPropertyHandle)o).getPropertyDefn().getAllowedChoices() != null && (choices = ((GroupPropertyHandle)o).getPropertyDefn().getAllowedChoices().getChoices()).length > 0) {
            values = new String[choices.length];
            int i = 0;
            while (i < choices.length) {
                values[i] = choices[i].getName();
                ++i;
            }
        }
        if (values == null) {
            return new String[0];
        }
        return values;
    }

    private String[] getChoiceDisplayNames(Object o) {
        IChoice[] choices;
        String[] values = null;
        if (o instanceof GroupPropertyHandle && ((GroupPropertyHandle)o).getPropertyDefn().getAllowedChoices() != null && (choices = ((GroupPropertyHandle)o).getPropertyDefn().getAllowedChoices().getChoices()).length > 0) {
            values = new String[choices.length];
            int i = 0;
            while (i < choices.length) {
                values[i] = choices[i].getDisplayName();
                ++i;
            }
        }
        if (values == null) {
            return new String[0];
        }
        return values;
    }

    public String getName(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof GroupPropertyHandle) {
            return ((GroupPropertyHandle)o).getPropertyDefn().getName();
        }
        return "nullname";
    }

    public String getTooltip(Object o) {
        return null;
    }

    public String getDisplayName(Object model) {
        if (model instanceof GroupPropertyHandle) {
            return ((GroupPropertyHandle)model).getPropertyDefn().getDisplayName();
        }
        return "";
    }

    private String[] filterPreStyles(String[] items) {
        List preStyles = DesignEngine.getMetaDataDictionary().getPredefinedStyles();
        ArrayList<String> preStyleNames = new ArrayList<String>();
        int i = 0;
        while (i < preStyles.size()) {
            preStyleNames.add(((IPredefinedStyle)preStyles.get(i)).getName());
            ++i;
        }
        ArrayList<String> sytleNames = new ArrayList<String>();
        int i2 = 0;
        while (i2 < items.length) {
            if (preStyleNames.indexOf(items[i2]) == -1) {
                sytleNames.add(items[i2]);
            }
            ++i2;
        }
        return sytleNames.toArray(new String[0]);
    }
}

