/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.fmc.activemq.facade;

import com.fusesource.fmc.activemq.facade.BrokerFacade;
import com.fusesource.fmc.activemq.facade.BrokerFacadeSupport;
import com.fusesource.fmc.activemq.facade.BrokerViewFacade;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.command.ActiveMQDestination;

public class LocalBrokerFacade
extends BrokerFacadeSupport {
    private BrokerService brokerService;

    public LocalBrokerFacade(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    @Override
    public String getId() throws Exception {
        return this.brokerService.getBrokerName();
    }

    @Override
    public BrokerFacade[] getBrokers() throws Exception {
        return new BrokerFacade[]{this};
    }

    @Override
    public String getBrokerName() throws Exception {
        return this.brokerService.getBrokerName();
    }

    public Broker getBroker() throws Exception {
        return this.brokerService.getBroker();
    }

    @Override
    public ManagementContext getManagementContext() {
        return this.brokerService.getManagementContext();
    }

    @Override
    public BrokerViewFacade getBrokerAdmin() throws Exception {
        return LocalBrokerFacade.proxy(BrokerViewFacade.class, this.brokerService.getAdminView(), this.brokerService.getBrokerName());
    }

    public ManagedRegionBroker getManagedBroker() throws Exception {
        BrokerView adminView = this.brokerService.getAdminView();
        if (adminView == null) {
            return null;
        }
        return adminView.getBroker();
    }

    @Override
    public void purgeQueue(ActiveMQDestination destination) throws Exception {
        Set destinations = this.getManagedBroker().getQueueRegion().getDestinations(destination);
        for (Destination dest : destinations) {
            if (!(dest instanceof Queue)) continue;
            Queue regionQueue = (Queue)dest;
            regionQueue.purge();
        }
    }

    @Override
    public Set queryNames(ObjectName name, QueryExp query) throws Exception {
        return this.getManagementContext().queryNames(name, query);
    }

    @Override
    public Object newProxyInstance(ObjectName objectName, Class interfaceClass, boolean notificationBroadcaster) {
        return this.getManagementContext().newProxyInstance(objectName, interfaceClass, notificationBroadcaster);
    }
}

