/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.pom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.m2e.core.ui.internal.dialogs.MavenPropertyDialog;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.editor.MavenEditorImages;
import org.eclipse.m2e.editor.composites.ListEditorComposite;
import org.eclipse.m2e.editor.composites.ListEditorContentProvider;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.pom.MavenPomEditorPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesSection {
    private static Logger LOG = LoggerFactory.getLogger(PropertiesSection.class);
    private final MavenPomEditorPage page;
    private FormToolkit toolkit;
    private Composite composite;
    private Section propertiesSection;
    ListEditorComposite<PropertyElement> propertiesEditor;
    private VerifyListener listener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            e.doit = DataValue.XMLChar.isValidName((String)e.text);
        }
    };

    public PropertiesSection(FormToolkit toolkit, Composite composite, MavenPomEditorPage page) {
        this.toolkit = toolkit;
        this.composite = composite;
        this.page = page;
        this.createSection();
    }

    private List<PropertyElement> getProperties() {
        final ArrayList<PropertyElement> toRet = new ArrayList<PropertyElement>();
        try {
            PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(this.page.getPomEditor().getDocument(), new PomEdits.Operation(){

                public void process(Document document) {
                    Element properties = PomEdits.findChild((Element)document.getDocumentElement(), (String)"properties");
                    if (properties != null) {
                        NodeList nl = properties.getChildNodes();
                        int i = 0;
                        while (i < nl.getLength()) {
                            Node child = nl.item(i);
                            if (child instanceof Element) {
                                toRet.add(new PropertyElement(child.getNodeName(), PomEdits.getTextValue((Node)child)));
                            }
                            ++i;
                        }
                    }
                }
            }, true)});
        }
        catch (Exception e) {
            LOG.error("Cannot read properties", (Throwable)e);
        }
        return toRet;
    }

    private Section createSection() {
        this.propertiesSection = this.toolkit.createSection(this.composite, 322);
        this.propertiesSection.setLayoutData((Object)new GridData(4, 128, true, false));
        this.propertiesSection.setText(Messages.PropertiesSection_section_properties);
        this.propertiesSection.setData("name", (Object)"propertiesSection");
        this.toolkit.paintBordersFor((Composite)this.propertiesSection);
        this.propertiesEditor = new ListEditorComposite((Composite)this.propertiesSection, 0);
        this.propertiesSection.setClient(this.propertiesEditor);
        this.propertiesEditor.getViewer().getTable().setData("name", (Object)"properties");
        this.propertiesEditor.setContentProvider(new ListEditorContentProvider());
        this.propertiesEditor.setLabelProvider((ILabelProvider)new PropertyPairLabelProvider());
        this.propertiesEditor.setCreateButtonListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesSection.this.createNewProperty();
            }
        });
        this.propertiesEditor.setRemoveButtonListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesSection.this.deleteProperties(PropertiesSection.this.propertiesEditor.getSelection());
            }
        });
        this.propertiesEditor.setDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PropertiesSection.this.editProperty(PropertiesSection.this.propertiesEditor.getSelection());
            }
        });
        this.toolkit.paintBordersFor(this.propertiesEditor);
        this.toolkit.adapt(this.propertiesEditor);
        return this.propertiesSection;
    }

    public void refresh() {
        this.propertiesEditor.setInput(this.getProperties());
        this.propertiesEditor.refresh();
    }

    void editProperty(List<PropertyElement> list) {
        if (list.size() != 1) {
            return;
        }
        final PropertyElement pp = list.get(0);
        MavenPropertyDialog dialog = new MavenPropertyDialog(this.propertiesSection.getShell(), Messages.PropertiesSection_title_editProperty, pp.getName(), pp.getValue(), this.listener);
        if (dialog.open() == 0) {
            final String key = dialog.getName();
            final String value = dialog.getValue();
            try {
                this.page.performEditOperation(new PomEdits.Operation(){

                    public void process(Document document) {
                        Element properties = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"properties"});
                        Element old = PomEdits.findChild((Element)properties, (String)pp.getName());
                        if (old == null) {
                            old = PomEdits.getChild((Element)properties, (String[])new String[]{pp.getName()});
                        }
                        if (!pp.getName().equals(key)) {
                            Element newElement = document.createElement(key);
                            properties.replaceChild(newElement, old);
                            PomEdits.setText((Element)newElement, (String)pp.getValue());
                            old = newElement;
                        }
                        if (!pp.getValue().equals(value)) {
                            PomEdits.setText((Element)old, (String)value);
                        }
                    }
                }, LOG, "error updating property");
            }
            finally {
                this.propertiesEditor.setInput(this.getProperties());
            }
        }
    }

    void createNewProperty() {
        MavenPropertyDialog dialog = new MavenPropertyDialog(this.propertiesSection.getShell(), Messages.PropertiesSection_title_addProperty, "", "", this.listener);
        if (dialog.open() == 0) {
            final String key = dialog.getName();
            final String value = dialog.getValue();
            try {
                this.page.performEditOperation(new PomEdits.Operation(){

                    public void process(Document document) {
                        Element prop = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"properties", key});
                        PomEdits.setText((Element)prop, (String)value);
                    }
                }, LOG, "error creating property");
            }
            finally {
                this.propertiesEditor.setInput(this.getProperties());
            }
        }
    }

    void deleteProperties(final List<PropertyElement> selection) {
        try {
            this.page.performEditOperation(new PomEdits.Operation(){

                public void process(Document document) {
                    Element props = PomEdits.findChild((Element)document.getDocumentElement(), (String)"properties");
                    if (props != null) {
                        for (PropertyElement el : selection) {
                            Element prop = PomEdits.findChild((Element)props, (String)el.getName());
                            PomEdits.removeChild((Element)props, (Element)prop);
                        }
                        PomEdits.removeIfNoChildElement((Element)props);
                    }
                }
            }, LOG, "error deleting property");
        }
        finally {
            this.propertiesEditor.setInput(this.getProperties());
        }
    }

    public ExpandableComposite getSection() {
        return this.propertiesSection;
    }

    static class PropertyElement {
        private final String name;
        private final String value;

        public PropertyElement(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }
    }

    static class PropertyPairLabelProvider
    extends LabelProvider {
        PropertyPairLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof PropertyElement) {
                PropertyElement pair = (PropertyElement)element;
                return NLS.bind((String)Messages.PropertyPairLabelProvider_0, (Object)pair.getName(), (Object)pair.getValue());
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return MavenEditorImages.IMG_PROPERTY;
        }
    }
}

