/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui;

import com.fusesource.ide.jmx.ui.RootJmxNodeProvider;
import com.fusesource.ide.jmx.ui.internal.adapters.JMXAdapterFactory;
import com.fusesource.ide.jmx.ui.internal.views.navigator.MBeanExplorerContentProvider;
import com.fusesource.rider.commons.logging.RiderLogFacade;
import com.fusesource.rider.commons.tree.RefreshableUI;
import com.fusesource.rider.commons.ui.ImagesActivatorSupport;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServerConnection;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.osgi.framework.BundleContext;

public class JMXUIActivator
extends ImagesActivatorSupport {
    public static final String PLUGIN_ID = "com.fusesource.ide.jmx.ui";
    private static JMXUIActivator plugin;
    private static List<RootJmxNodeProvider> rootJmxNodeProviders;
    private static List<MBeanExplorerContentProvider> contentProviders;
    private JMXAdapterFactory adapterFactory;
    private MBeanServerConnection connection;

    static {
        rootJmxNodeProviders = new ArrayList<RootJmxNodeProvider>();
        contentProviders = new ArrayList<MBeanExplorerContentProvider>();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerAdapters();
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.unregisterAdapters();
        super.stop(context);
    }

    public static JMXUIActivator getDefault() {
        return plugin;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = JMXUIActivator.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return JMXUIActivator.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        return JMXUIActivator.getDefault().internalGetActivePage();
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public void setCurrentConnection(MBeanServerConnection connection) {
        this.connection = connection;
    }

    public MBeanServerConnection getCurrentConnection() {
        return this.connection;
    }

    public static RiderLogFacade getLogger() {
        return RiderLogFacade.getLog((ILog)JMXUIActivator.getDefault().getLog());
    }

    public static void log(IStatus status) {
        JMXUIActivator.getDefault().getLog().log(status);
    }

    public static void log(int severity, String message, Throwable e) {
        JMXUIActivator.log((IStatus)new Status(severity, PLUGIN_ID, 0, message, e));
    }

    private void registerAdapters() {
        this.adapterFactory = new JMXAdapterFactory();
        Class<?>[] classArray = this.adapterFactory.getAdapterClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> aClass = classArray[n2];
            Platform.getAdapterManager().registerAdapters((IAdapterFactory)this.adapterFactory, aClass);
            ++n2;
        }
    }

    private void unregisterAdapters() {
        Class<?>[] classArray = this.adapterFactory.getAdapterClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> aClass = classArray[n2];
            Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)this.adapterFactory, aClass);
            ++n2;
        }
    }

    public static void provideRootNodes(RefreshableUI explorerContentProvider, List list) {
        for (RootJmxNodeProvider provider : rootJmxNodeProviders) {
            provider.provideRootJmxNodes(explorerContentProvider, list);
        }
    }

    public static void addRootJmxNodeProvider(RootJmxNodeProvider provider) {
        rootJmxNodeProviders.add(provider);
        for (RefreshableUI refreshableUI : contentProviders) {
            refreshableUI.fireRefresh();
        }
    }

    public static void removeRootJmxNodeProvider(RootJmxNodeProvider provider) {
        rootJmxNodeProviders.remove(provider);
    }

    public static void addExplorer(MBeanExplorerContentProvider contentProvider) {
        contentProviders.add(contentProvider);
    }

    public static void removeExplorer(RefreshableUI contentProvider) {
        contentProviders.remove(contentProvider);
    }
}

