/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui;

import com.fusesource.ide.jmx.ui.ConnectionWizardPage;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class UIExtensionManager {
    private static final String CONNECTION_PAGES = "com.fusesource.ide.jmx.ui.providerUI";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String ICON = "icon";
    private static final String CLASS = "class";
    private static HashMap<String, ConnectionProviderUI> connectionUIElements;

    public static HashMap<String, ConnectionProviderUI> getConnectionUIElements() {
        if (connectionUIElements == null) {
            UIExtensionManager.loadConnectionUI();
        }
        return connectionUIElements;
    }

    public static ConnectionProviderUI getConnectionProviderUI(String id) {
        if (connectionUIElements == null) {
            UIExtensionManager.loadConnectionUI();
        }
        return connectionUIElements.get(id);
    }

    private static void loadConnectionUI() {
        HashMap<String, ConnectionProviderUI> map = new HashMap<String, ConnectionProviderUI>();
        IExtension[] extensions = UIExtensionManager.findExtension(CONNECTION_PAGES);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    ConnectionProviderUI pUI = new ConnectionProviderUI(elements[j]);
                    map.put(pUI.getId(), pUI);
                }
                catch (InvalidRegistryObjectException invalidRegistryObjectException) {}
                ++j;
            }
            ++i;
        }
        connectionUIElements = map;
    }

    public static IWizardPage[] getNewConnectionWizardPages(String typeName) {
        IWizardPage[] pages;
        ConnectionProviderUI ui = connectionUIElements.get(typeName);
        if (ui != null && (pages = ui.createPages()) != null) {
            return pages;
        }
        return new IWizardPage[0];
    }

    private static IExtension[] findExtension(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionId);
        return extensionPoint.getExtensions();
    }

    public static class ConnectionProviderUI {
        String id;
        String name;
        String icon;
        IConfigurationElement[] wizardPages;
        ImageDescriptor imageDescriptor;

        public ConnectionProviderUI(IConfigurationElement element) {
            this.id = element.getAttribute(UIExtensionManager.ID);
            this.name = element.getAttribute(UIExtensionManager.NAME);
            this.icon = element.getAttribute(UIExtensionManager.ICON);
            this.wizardPages = element.getChildren();
            String pluginName = element.getDeclaringExtension().getContributor().getName();
            this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginName, (String)this.icon);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getIcon() {
            return this.icon;
        }

        public ImageDescriptor getImageDescriptor() {
            return this.imageDescriptor;
        }

        public ConnectionWizardPage[] createPages() {
            ArrayList<ConnectionWizardPage> list = new ArrayList<ConnectionWizardPage>();
            int i = 0;
            while (i < this.wizardPages.length) {
                try {
                    ConnectionWizardPage wp = (ConnectionWizardPage)this.wizardPages[i].createExecutableExtension(UIExtensionManager.CLASS);
                    list.add(wp);
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                }
                ++i;
            }
            return list.toArray(new ConnectionWizardPage[list.size()]);
        }
    }
}

