/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal;

import com.fusesource.ide.jmx.ui.JMXUIActivator;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class JMXImages {
    public static final IPath ICONS_PATH = new Path("$nl$/icons/full");
    private static final String NAME_PREFIX = "com.fusesource.ide.jmx.ui.";
    private static final int NAME_PREFIX_LENGTH = "com.fusesource.ide.jmx.ui.".length();
    private static ImageRegistry fgImageRegistry = null;
    private static HashMap<String, ImageDescriptor> fgAvoidSWTErrorMap = null;
    private static final String T_OBJ = "obj16";
    public static final String IMG_MISC_PUBLIC = "com.fusesource.ide.jmx.ui.methpub_obj.gif";
    public static final String IMG_FIELD_PUBLIC = "com.fusesource.ide.jmx.ui.field_public_obj.gif";
    public static final String IMG_OBJS_INTERFACE = "com.fusesource.ide.jmx.ui.int_obj.gif";
    public static final String IMG_OBJS_METHOD = "com.fusesource.ide.jmx.ui.jmeth_obj.gif";
    public static final String IMG_OBJS_PACKAGE = "com.fusesource.ide.jmx.ui.package_obj.gif";
    public static final String IMG_OBJS_LIBRARY = "com.fusesource.ide.jmx.ui.library_obj.gif";
    public static final String IMG_OBJS_READ_WRITE = "com.fusesource.ide.jmx.ui.readwrite_obj.gif";
    public static final String IMG_GEARS = "com.fusesource.ide.jmx.ui.releng_gears.gif";
    public static final String IMG_OBJS_READ = "com.fusesource.ide.jmx.ui.read_obj.gif";
    public static final String IMG_OBJS_WRITE = "com.fusesource.ide.jmx.ui.write_obj.gif";
    public static final ImageDescriptor DESC_MISC_PUBLIC = JMXImages.createManagedFromKey("obj16", "com.fusesource.ide.jmx.ui.methpub_obj.gif");
    public static final ImageDescriptor DESC_FIELD_PUBLIC = JMXImages.createManagedFromKey("obj16", "com.fusesource.ide.jmx.ui.field_public_obj.gif");
    public static final ImageDescriptor DESC_OBJS_PACKAGE = JMXImages.createManagedFromKey("obj16", "com.fusesource.ide.jmx.ui.package_obj.gif");
    public static final ImageDescriptor DESC_OBJS_INTERFACE = JMXImages.createManagedFromKey("obj16", "com.fusesource.ide.jmx.ui.int_obj.gif");
    public static final ImageDescriptor DESC_OBJS_METHOD = JMXImages.createManagedFromKey("obj16", "com.fusesource.ide.jmx.ui.jmeth_obj.gif");
    public static final ImageDescriptor DESC_OBJS_LIBRARY = JMXImages.createManagedFromKey("obj16", "com.fusesource.ide.jmx.ui.library_obj.gif");
    public static final ImageDescriptor DESC_OBJS_READ_WRITE = JMXImages.createManagedFromKey("obj16", "com.fusesource.ide.jmx.ui.readwrite_obj.gif");
    public static final ImageDescriptor DESC_OBJS_READ = JMXImages.createManagedFromKey("obj16", "com.fusesource.ide.jmx.ui.read_obj.gif");
    public static final ImageDescriptor DESC_OBJS_WRITE = JMXImages.createManagedFromKey("obj16", "com.fusesource.ide.jmx.ui.write_obj.gif");

    public static Image get(String key) {
        return JMXImages.getImageRegistry().get(key);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        JMXImages.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id = JMXImages.create("d" + type, relPath, false);
        if (id != null) {
            action.setDisabledImageDescriptor(id);
        }
        ImageDescriptor descriptor = JMXImages.create("e" + type, relPath, true);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry();
            for (String key : fgAvoidSWTErrorMap.keySet()) {
                fgImageRegistry.put(key, fgAvoidSWTErrorMap.get(key));
            }
            fgAvoidSWTErrorMap = null;
        }
        return fgImageRegistry;
    }

    private static ImageDescriptor createManagedFromKey(String prefix, String key) {
        return JMXImages.createManaged(prefix, key.substring(NAME_PREFIX_LENGTH), key);
    }

    private static ImageDescriptor createManaged(String prefix, String name, String key) {
        ImageDescriptor result = JMXImages.create(prefix, name, true);
        if (fgAvoidSWTErrorMap == null) {
            fgAvoidSWTErrorMap = new HashMap();
        }
        fgAvoidSWTErrorMap.put(key, result);
        return result;
    }

    private static ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(prefix).append(name);
        return JMXImages.createImageDescriptor(JMXUIActivator.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }
}

