/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.actions;

import com.fusesource.ide.jmx.core.DeleteConnectionJob;
import com.fusesource.ide.jmx.core.DisconnectJob;
import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.ui.Messages;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;

public class DeleteConnectionAction
extends Action {
    private IConnectionWrapper[] connection;

    public DeleteConnectionAction(IConnectionWrapper[] wrapper) {
        this.connection = wrapper;
        boolean enabled = true;
        int i = 0;
        while (i < this.connection.length) {
            if (!this.connection[i].getProvider().canDelete(this.connection[i])) {
                enabled = false;
            }
            ++i;
        }
        String key = enabled ? "IMG_TOOL_DELETE" : "IMG_TOOL_DELETE_DISABLED";
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(key));
        this.setEnabled(enabled);
        this.setText(Messages.DeleteConnection);
    }

    public void run() {
        if (this.connection != null) {
            IConnectionWrapper[] wrapper = this.connection;
            DisconnectJob dj = new DisconnectJob(wrapper);
            DeleteConnectionJob deleteJob = new DeleteConnectionJob(wrapper);
            dj.setNextJob((Job)deleteJob);
            dj.schedule();
        }
    }
}

