/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.actions;

import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.core.tree.Root;
import com.fusesource.ide.jmx.ui.Messages;
import com.fusesource.ide.jmx.ui.internal.JMXImages;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.Refreshable;
import com.fusesource.rider.commons.util.Objects;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class RefreshAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private StructuredViewer viewer;
    private final String viewId;

    public RefreshAction(String viewId) {
        this.viewId = viewId;
        Objects.notNull((Object)viewId, (String)"No viewId for RefreshAction");
        this.setText(Messages.RefreshAction_text);
        this.setDescription(Messages.RefreshAction_description);
        this.setToolTipText(Messages.RefreshAction_tooltip);
        JMXImages.setLocalImageDescriptors((IAction)this, "refresh.gif");
    }

    public void run() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return;
        }
        IWorkbenchWindow aww = wb.getActiveWorkbenchWindow();
        if (aww == null) {
            return;
        }
        IWorkbenchPage ap = aww.getActivePage();
        if (ap == null) {
            return;
        }
        ISelection sel = this.getSelection(ap);
        if (sel instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)sel;
            Object onode = ss.getFirstElement();
            if (onode instanceof Refreshable) {
                Refreshable refreshable = (Refreshable)onode;
                refreshable.refresh();
                this.refreshViewer(onode);
            } else {
                IConnectionWrapper wrapper = null;
                if (onode instanceof IConnectionWrapper) {
                    wrapper = (IConnectionWrapper)onode;
                } else if (onode instanceof Node) {
                    Node node = (Node)onode;
                    while (!(node instanceof Root) && node != null) {
                        node = node.getParent();
                    }
                    if (node != null) {
                        wrapper = ((Root)node).getConnection();
                    }
                }
                if (wrapper != null) {
                    try {
                        wrapper.disconnect();
                        wrapper.connect();
                        this.refreshViewer(wrapper);
                        if (this.viewer instanceof TreeViewer) {
                            TreeViewer treeViewer = (TreeViewer)this.viewer;
                            treeViewer.expandToLevel((Object)wrapper, 1);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    protected ISelection getSelection(IWorkbenchPage ap) {
        return ap.getSelection(this.viewId);
    }

    private void refreshViewer(Object node) {
        if (this.viewer != null) {
            this.viewer.refresh(node);
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void setViewer(StructuredViewer viewer) {
        this.viewer = viewer;
    }
}

