/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.adapters;

import com.fusesource.ide.jmx.core.DomainWrapper;
import com.fusesource.ide.jmx.core.MBeanAttributeInfoWrapper;
import com.fusesource.ide.jmx.core.MBeanInfoWrapper;
import com.fusesource.ide.jmx.core.MBeanOperationInfoWrapper;
import com.fusesource.ide.jmx.core.tree.ObjectNameNode;
import com.fusesource.ide.jmx.ui.internal.adapters.DomainPropertySourceAdapter;
import com.fusesource.ide.jmx.ui.internal.adapters.MBeanAttributeInfoPropertySourceAdapter;
import com.fusesource.ide.jmx.ui.internal.adapters.MBeanInfoPropertySourceAdapter;
import com.fusesource.ide.jmx.ui.internal.adapters.MBeanOperationInfoPropertySourceAdapter;
import com.fusesource.ide.jmx.ui.internal.adapters.ObjectNameNodePropertySourceAdapter;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.views.properties.IPropertySource;

public class JMXAdapterFactory
implements IAdapterFactory {
    private Class<?>[] adapterClasses = new Class[]{DomainWrapper.class, MBeanInfoWrapper.class, MBeanAttributeInfoWrapper.class, MBeanOperationInfoWrapper.class, ObjectNameNode.class};

    public Class[] getAdapterList() {
        return new Class[]{IPropertySource.class};
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IPropertySource.class) {
            return this.adaptToPropertySource(adaptableObject);
        }
        return null;
    }

    private IPropertySource adaptToPropertySource(Object adaptableObject) {
        if (adaptableObject instanceof DomainWrapper) {
            DomainWrapper domain = (DomainWrapper)adaptableObject;
            return new DomainPropertySourceAdapter(domain.getName());
        }
        if (adaptableObject instanceof MBeanInfoWrapper) {
            MBeanInfoWrapper wrapper = (MBeanInfoWrapper)adaptableObject;
            return new MBeanInfoPropertySourceAdapter(wrapper.getObjectName(), wrapper.getMBeanInfo());
        }
        if (adaptableObject instanceof MBeanAttributeInfoWrapper) {
            MBeanAttributeInfoWrapper wrapper = (MBeanAttributeInfoWrapper)adaptableObject;
            return new MBeanAttributeInfoPropertySourceAdapter(wrapper.getMBeanAttributeInfo(), wrapper.getObjectName(), wrapper.getMBeanServerConnection());
        }
        if (adaptableObject instanceof MBeanOperationInfoWrapper) {
            MBeanOperationInfoWrapper wrapper = (MBeanOperationInfoWrapper)adaptableObject;
            return new MBeanOperationInfoPropertySourceAdapter(wrapper.getMBeanOperationInfo());
        }
        if (adaptableObject instanceof ObjectNameNode) {
            ObjectNameNode objectName = (ObjectNameNode)adaptableObject;
            return new ObjectNameNodePropertySourceAdapter(objectName);
        }
        return null;
    }

    public Class<?>[] getAdapterClasses() {
        return this.adapterClasses;
    }
}

