/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.adapters;

import com.fusesource.ide.jmx.core.Impact;
import com.fusesource.ide.jmx.ui.Messages;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class MBeanOperationInfoPropertySourceAdapter
implements IPropertySource {
    private MBeanOperationInfo opInfo;

    public MBeanOperationInfoPropertySourceAdapter(MBeanOperationInfo opInfo) {
        this.opInfo = opInfo;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        this.addDescriptor("name", Messages.name, Messages.general, descriptors);
        this.addDescriptor("description", Messages.description, Messages.general, descriptors);
        this.addDescriptor("returnType", Messages.returnType, Messages.general, descriptors);
        this.addDescriptor("impact", Messages.impact, Messages.general, descriptors);
        this.addDescriptor("writable", Messages.writable, Messages.general, descriptors);
        MBeanParameterInfo[] paramInfos = this.opInfo.getSignature();
        int i = 0;
        while (i < paramInfos.length) {
            MBeanParameterInfo paramInfo = paramInfos[i];
            this.addDescriptor("param" + i, paramInfo.getName(), Messages.parameters, descriptors);
            ++i;
        }
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    private void addDescriptor(String id, String displayName, String category, List<PropertyDescriptor> descriptors) {
        PropertyDescriptor descriptor = new PropertyDescriptor((Object)id, displayName);
        descriptor.setCategory(category);
        descriptors.add(descriptor);
    }

    public Object getPropertyValue(Object id) {
        String idStr;
        if ("name".equals(id)) {
            return this.opInfo.getName();
        }
        if ("description".equals(id)) {
            return this.opInfo.getDescription();
        }
        if ("returnType".equals(id)) {
            return this.opInfo.getReturnType();
        }
        if ("impact".equals(id)) {
            return Impact.parseInt((int)this.opInfo.getImpact());
        }
        if (id instanceof String && (idStr = (String)id).startsWith("param")) {
            String indexStr = idStr.substring(idStr.length() - 1);
            int i = new Integer(indexStr);
            int j = 0;
            while (j < this.opInfo.getSignature().length) {
                MBeanParameterInfo paramInfo = this.opInfo.getSignature()[j];
                if (i == j) {
                    return paramInfo.getType();
                }
                ++j;
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

