/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.controls;

import com.fusesource.ide.jmx.core.MBeanUtils;
import com.fusesource.ide.jmx.core.util.StringUtils;
import com.fusesource.ide.jmx.ui.JMXUIActivator;
import com.fusesource.ide.jmx.ui.Messages;
import com.fusesource.ide.jmx.ui.extensions.IAttributeControlFactory;
import com.fusesource.ide.jmx.ui.extensions.IWritableAttributeHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TextControlFactory
implements IAttributeControlFactory {
    @Override
    public Control createControl(final Composite parent, FormToolkit toolkit, boolean writable, final String type, Object value, final IWritableAttributeHandler handler) {
        String attrValue = "";
        try {
            attrValue = StringUtils.toString((Object)value, (boolean)true);
        }
        catch (Exception e) {
            JMXUIActivator.log(4, Messages.MBeanAttributeValue_Warning, e);
            attrValue = Messages.unavailable;
        }
        int style = 2048;
        style = value instanceof Number || value instanceof Character ? (style |= 4) : (style |= 0x42);
        if (!writable) {
            Text text = TextControlFactory.createTextControl(parent, toolkit, style);
            text.setText(attrValue);
            text.setEditable(false);
            text.setForeground(parent.getDisplay().getSystemColor(2));
            return text;
        }
        Composite composite = toolkit.createComposite(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        final Text text = TextControlFactory.createTextControl(composite, toolkit, style);
        text.setText(attrValue);
        text.setEditable(true);
        text.setForeground(parent.getDisplay().getSystemColor(9));
        if (handler != null) {
            Button updateButton = toolkit.createButton(composite, Messages.AttributeControlFactory_updateButtonTitle, 8);
            updateButton.setLayoutData((Object)new GridData(0x1000008, 128, false, false));
            updateButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    try {
                        Object newValue = MBeanUtils.getValue((String)text.getText(), (String)type);
                        handler.write(newValue);
                        text.setText(newValue.toString());
                    }
                    catch (Throwable t) {
                        Status errorStatus = new Status(4, "com.fusesource.ide.jmx.ui", 0, t.getMessage(), t);
                        ErrorDialog.openError((Shell)parent.getShell(), (String)Messages.AttributeDetailsSection_errorTitle, (String)t.getMessage(), (IStatus)errorStatus);
                    }
                }

                public void widgetSelected(SelectionEvent event) {
                    this.widgetDefaultSelected(event);
                }
            });
        }
        return text;
    }

    private static Text createTextControl(Composite parent, FormToolkit toolkit, int style) {
        Text text = toolkit != null ? toolkit.createText(parent, "", style) : new Text(parent, style);
        return text;
    }
}

