/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.dialogs;

import com.fusesource.ide.jmx.core.MBeanInfoWrapper;
import com.fusesource.ide.jmx.ui.JMXUIActivator;
import com.fusesource.ide.jmx.ui.internal.views.navigator.MBeanExplorerLabelProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class OpenMBeanSelectionDialog
extends SelectionStatusDialog {
    private TreeViewer viewer;

    public OpenMBeanSelectionDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        Point size = new Point(480, 320);
        result.x = Math.max(result.x, size.x);
        result.y = Math.max(result.y, size.y);
        Rectangle display = this.getShell().getDisplay().getClientArea();
        result.x = Math.min(result.x, display.width);
        result.y = Math.min(result.y, display.height);
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        FilteredTree filter = new FilteredTree(area, 770, new PatternFilter());
        this.viewer = filter.getViewer();
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MBeanExplorerLabelProvider());
        MBeanServerConnection mbsc = JMXUIActivator.getDefault().getCurrentConnection();
        if (mbsc != null) {
            try {
                Set<ObjectName> set = mbsc.queryNames(ObjectName.getInstance("*:*"), null);
                ArrayList<MBeanInfoWrapper> mbeans = new ArrayList<MBeanInfoWrapper>();
                for (ObjectName objectName : set) {
                    MBeanInfo info = mbsc.getMBeanInfo(objectName);
                    mbeans.add(new MBeanInfoWrapper(objectName, info, mbsc));
                }
                Collections.sort(mbeans);
                this.viewer.setInput(mbeans);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return area;
    }

    protected void computeResult() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selected = selection.getFirstElement();
        if (selected == null) {
            this.setResult(null);
            return;
        }
        if (selected instanceof MBeanInfoWrapper) {
            MBeanInfoWrapper wrapper = (MBeanInfoWrapper)selected;
            ArrayList<MBeanInfoWrapper> results = new ArrayList<MBeanInfoWrapper>();
            results.add(wrapper);
            this.setResult(results);
        }
    }

    class ContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private List mbeans;

        ContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            this.mbeans = (List)newInput;
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (this.mbeans != null) {
                return this.mbeans.toArray(new MBeanInfoWrapper[this.mbeans.size()]);
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getChildren(Object parent) {
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            return false;
        }
    }
}

