/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.editors;

import com.fusesource.ide.jmx.core.MBeanAttributeInfoWrapper;
import com.fusesource.ide.jmx.core.MBeanInfoWrapper;
import com.fusesource.ide.jmx.ui.Messages;
import com.fusesource.ide.jmx.ui.internal.editors.ActionUtils;
import com.fusesource.ide.jmx.ui.internal.editors.AttributeDetails;
import com.fusesource.ide.jmx.ui.internal.editors.AttributesSection;
import com.fusesource.ide.jmx.ui.internal.editors.MBeanEditorInput;
import com.fusesource.ide.jmx.ui.internal.views.navigator.UpdateSelectionJob;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class AttributesPage
extends FormPage {
    static final String ID = "attributes";
    private AttributesBLock block;
    private MBeanInfoWrapper wrapper;

    public AttributesPage(FormEditor editor) {
        super(editor, ID, Messages.AttributesPage_title);
        MBeanEditorInput input = (MBeanEditorInput)editor.getEditorInput();
        this.wrapper = input.getWrapper();
        this.block = new AttributesBLock();
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.getForm().setSeparatorVisible(true);
        form.getForm().setText(this.wrapper.getObjectName().toString());
        this.block.createContent(managedForm);
        this.block.masterSection.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UpdateSelectionJob.launchJob("com.fusesource.ide.jmx.ui.internal.views.navigator.MBeanExplorer");
            }
        });
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.block.masterSection.getTableViewer().getSelection();
    }

    public boolean selectReveal(Object object) {
        if (object instanceof MBeanAttributeInfoWrapper) {
            MBeanAttributeInfoWrapper attrWrapper = (MBeanAttributeInfoWrapper)object;
            this.getEditor().setActivePage(ID);
            return this.block.masterSection.setFormInput(attrWrapper);
        }
        return super.selectReveal(object);
    }

    public class AttributesBLock
    extends MasterDetailsBlock
    implements IDetailsPageProvider {
        private AttributesSection masterSection;
        private IDetailsPage attributeDetails;

        protected void createMasterPart(IManagedForm managedForm, Composite parent) {
            this.masterSection = new AttributesSection(AttributesPage.this.wrapper, managedForm, parent);
            managedForm.addPart((IFormPart)this.masterSection);
        }

        protected void registerPages(DetailsPart detailsPart) {
            this.attributeDetails = new AttributeDetails((IFormPart)this.masterSection);
            detailsPart.setPageLimit(10);
            detailsPart.setPageProvider((IDetailsPageProvider)this);
            detailsPart.registerPage(MBeanAttributeInfoWrapper.class, this.attributeDetails);
        }

        protected void createToolBarActions(IManagedForm managedForm) {
            ActionUtils.createLayoutActions(managedForm, this.sashForm);
        }

        public Object getPageKey(Object object) {
            return object;
        }

        public IDetailsPage getPage(Object key) {
            if (key instanceof MBeanAttributeInfoWrapper) {
                return this.attributeDetails;
            }
            return null;
        }
    }
}

