/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.editors;

import com.fusesource.ide.jmx.core.ExtensionManager;
import com.fusesource.ide.jmx.core.IConnectionProviderListener;
import com.fusesource.ide.jmx.core.IConnectionWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.Workbench;

public class EditorConnectionMapping
implements IConnectionProviderListener {
    private HashMap<IConnectionWrapper, ArrayList<IEditorPart>> map = new HashMap();
    private IWorkbenchPage page = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();

    public EditorConnectionMapping() {
        ExtensionManager.addConnectionProviderListener((IConnectionProviderListener)this);
    }

    public void open(IConnectionWrapper wrapper, IEditorPart editor) {
        ArrayList<Object> list = this.map.get(wrapper);
        if (list == null) {
            list = new ArrayList();
            this.map.put(wrapper, list);
        }
        if (!list.contains(editor)) {
            list.add(editor);
        }
    }

    public void close(final IConnectionWrapper wrapper) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArrayList list = (ArrayList)EditorConnectionMapping.this.map.get(wrapper);
                if (list != null) {
                    for (IEditorPart ep : list) {
                        EditorConnectionMapping.this.page.closeEditor(ep, false);
                    }
                    EditorConnectionMapping.this.map.remove(wrapper);
                }
            }
        });
    }

    public void connectionChanged(IConnectionWrapper connection) {
        if (!connection.isConnected()) {
            this.close(connection);
        }
    }

    public void connectionAdded(IConnectionWrapper connection) {
    }

    public void connectionRemoved(IConnectionWrapper connection) {
        if (!connection.isConnected()) {
            this.close(connection);
        }
    }
}

