/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.editors;

import com.fusesource.ide.jmx.core.MBeanInfoWrapper;
import com.fusesource.ide.jmx.core.MBeanOperationInfoWrapper;
import com.fusesource.ide.jmx.ui.Messages;
import com.fusesource.ide.jmx.ui.internal.editors.ActionUtils;
import com.fusesource.ide.jmx.ui.internal.editors.MBeanEditorInput;
import com.fusesource.ide.jmx.ui.internal.editors.OperationDetails;
import com.fusesource.ide.jmx.ui.internal.editors.OperationsSection;
import com.fusesource.ide.jmx.ui.internal.views.navigator.UpdateSelectionJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class OperationsPage
extends FormPage {
    static final String ID = "operations";
    private OperationsBLock block;
    private MBeanInfoWrapper wrapper;

    public OperationsPage(FormEditor editor) {
        super(editor, ID, Messages.OperationsPage_title);
        MBeanEditorInput input = (MBeanEditorInput)editor.getEditorInput();
        this.wrapper = input.getWrapper();
        this.block = new OperationsBLock();
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.getForm().setSeparatorVisible(true);
        form.getForm().setText(this.wrapper.getObjectName().toString());
        this.block.createContent(managedForm);
        this.block.masterSection.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UpdateSelectionJob.launchJob("com.fusesource.ide.jmx.ui.internal.views.navigator.MBeanExplorer");
            }
        });
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.block.masterSection.getTableViewer().getSelection();
    }

    public boolean selectReveal(Object object) {
        Assert.isNotNull((Object)object);
        if (object instanceof MBeanOperationInfoWrapper) {
            MBeanOperationInfoWrapper opWrapper = (MBeanOperationInfoWrapper)object;
            this.getEditor().setActivePage(ID);
            return this.block.masterSection.setFormInput(opWrapper);
        }
        return super.selectReveal(object);
    }

    public class OperationsBLock
    extends MasterDetailsBlock
    implements IDetailsPageProvider {
        private OperationsSection masterSection;
        private IDetailsPage operationDetails;

        protected void createMasterPart(IManagedForm managedForm, Composite parent) {
            this.masterSection = new OperationsSection(OperationsPage.this.wrapper, managedForm, parent);
            managedForm.addPart((IFormPart)this.masterSection);
        }

        protected void registerPages(DetailsPart detailsPart) {
            this.operationDetails = new OperationDetails((IFormPart)this.masterSection);
            detailsPart.setPageLimit(10);
            detailsPart.setPageProvider((IDetailsPageProvider)this);
            detailsPart.registerPage(MBeanOperationInfoWrapper.class, this.operationDetails);
        }

        protected void createToolBarActions(IManagedForm managedForm) {
            ActionUtils.createLayoutActions(managedForm, this.sashForm);
        }

        public Object getPageKey(Object object) {
            return object;
        }

        public IDetailsPage getPage(Object key) {
            if (key instanceof MBeanOperationInfoWrapper) {
                return this.operationDetails;
            }
            return null;
        }
    }
}

