/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.tables;

import com.fusesource.ide.jmx.core.MBeanInfoWrapper;
import com.fusesource.ide.jmx.ui.Messages;
import com.fusesource.ide.jmx.ui.internal.tables.AttributesContentProvider;
import com.fusesource.ide.jmx.ui.internal.tables.AttributesLabelProvider;
import com.fusesource.ide.jmx.ui.internal.tables.AttributesViewerSorter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MBeanAttributesTable {
    private TableViewer viewer;

    public MBeanAttributesTable(Composite parent, FormToolkit toolkit) {
        Table attrTable = toolkit.createTable(parent, 65536);
        GridData gd = new GridData(1808);
        gd.heightHint = 20;
        gd.widthHint = 100;
        attrTable.setLayoutData((Object)gd);
        toolkit.paintBordersFor(parent);
        this.createColumns(attrTable);
        attrTable.setLinesVisible(true);
        attrTable.setHeaderVisible(true);
        this.viewer = new TableViewer(attrTable);
        this.viewer.setContentProvider((IContentProvider)new AttributesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AttributesLabelProvider());
    }

    private void createColumns(final Table attrTable) {
        final TableColumn attrName = new TableColumn(attrTable, 0);
        attrName.setText(Messages.name);
        attrName.setWidth(150);
        final TableColumn attrValue = new TableColumn(attrTable, 0);
        attrValue.setText(Messages.value);
        attrValue.setWidth(350);
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                int colIndex;
                TableColumn sortColumn = attrTable.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = attrTable.getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    attrTable.setSortColumn(currentColumn);
                    dir = 128;
                }
                if (currentColumn == attrName) {
                    colIndex = 0;
                } else if (currentColumn == attrValue) {
                    colIndex = 1;
                } else {
                    return;
                }
                attrTable.setSortDirection(dir);
                MBeanAttributesTable.this.viewer.setSorter((ViewerSorter)new AttributesViewerSorter(dir, colIndex));
            }
        };
        attrName.addListener(13, sortListener);
        attrTable.setSortColumn(attrName);
        attrTable.setSortDirection(128);
    }

    public void setInput(MBeanInfoWrapper input) {
        if (input == null || input.getMBeanInfo() == null) {
            this.viewer.setInput(null);
        } else {
            this.viewer.setInput((Object)input.getMBeanAttributeInfoWrappers());
        }
        this.viewer.getTable().redraw();
    }

    public Viewer getViewer() {
        return this.viewer;
    }
}

