/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.views.navigator;

import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.core.tree.Root;
import com.fusesource.ide.jmx.ui.internal.actions.DeleteConnectionAction;
import com.fusesource.ide.jmx.ui.internal.actions.DoubleClickAction;
import com.fusesource.ide.jmx.ui.internal.actions.MBeanServerConnectAction;
import com.fusesource.ide.jmx.ui.internal.actions.MBeanServerDisconnectAction;
import com.fusesource.ide.jmx.ui.internal.actions.NewConnectionAction;
import com.fusesource.ide.jmx.ui.internal.actions.RefreshAction;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class ActionProvider
extends CommonActionProvider {
    private DoubleClickAction doubleClickAction;
    private NewConnectionAction newConnectionAction;
    private RefreshAction refreshAction;
    private ICommonActionExtensionSite site;

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        this.site = site;
        this.doubleClickAction = new DoubleClickAction();
        this.newConnectionAction = new NewConnectionAction();
        String viewId = site.getViewSite().getId();
        System.out.println("============================= View ID: " + viewId);
        this.refreshAction = new RefreshAction(viewId);
        StructuredViewer viewer = site.getStructuredViewer();
        this.refreshAction.setViewer(viewer);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.doubleClickAction);
    }

    public StructuredViewer getStructuredViewer() {
        return this.site.getStructuredViewer();
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.doubleClickAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        IConnectionWrapper[] connections;
        menu.appendToGroup("additions", (IAction)this.refreshAction);
        Object firstSelection = this.getFirstSelection();
        if (firstSelection instanceof ContextMenuProvider) {
            ContextMenuProvider provider = (ContextMenuProvider)firstSelection;
            provider.provideContextMenu(menu);
        }
        if ((connections = this.getWrappersFromSelection()) != null && connections.length > 0) {
            if (!this.anyConnected(connections) && this.allControlable(connections)) {
                menu.add((IAction)new MBeanServerConnectAction(this.getStructuredViewer(), connections));
            } else if (this.allControlable(connections)) {
                menu.add((IAction)new MBeanServerDisconnectAction(connections));
            }
            menu.add((IAction)new DeleteConnectionAction(connections));
        }
        if (firstSelection == null || firstSelection instanceof Root || firstSelection instanceof IConnectionWrapper) {
            menu.add((IAction)this.newConnectionAction);
        }
    }

    protected boolean anyConnected(IConnectionWrapper[] connections) {
        int i = 0;
        while (i < connections.length) {
            if (connections[i].isConnected()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean allControlable(IConnectionWrapper[] connections) {
        int i = 0;
        while (i < connections.length) {
            if (!connections[i].canControl()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected IConnectionWrapper[] getWrappersFromSelection() {
        ArrayList<IConnectionWrapper> list = new ArrayList<IConnectionWrapper>();
        IStructuredSelection selection = this.getContextSelection();
        if (selection != null) {
            for (Object o : selection) {
                if (!(o instanceof IConnectionWrapper)) continue;
                list.add((IConnectionWrapper)o);
            }
        }
        return list.toArray(new IConnectionWrapper[list.size()]);
    }

    protected Object getFirstSelection() {
        IStructuredSelection selection = this.getContextSelection();
        if (selection != null) {
            return selection.getFirstElement();
        }
        return null;
    }

    protected IStructuredSelection getContextSelection() {
        ISelection sel;
        IStructuredSelection answer = null;
        if (this.getContext() != null && this.getContext().getSelection() != null && (sel = this.getContext().getSelection()) instanceof IStructuredSelection) {
            answer = (IStructuredSelection)sel;
        }
        return answer;
    }
}

