/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.views.navigator;

import com.fusesource.ide.jmx.core.ExtensionManager;
import com.fusesource.ide.jmx.core.IConnectionProviderListener;
import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.core.MBeanFeatureInfoWrapper;
import com.fusesource.ide.jmx.core.tree.DomainNode;
import com.fusesource.ide.jmx.core.tree.ObjectNameNode;
import com.fusesource.ide.jmx.core.tree.Root;
import com.fusesource.ide.jmx.ui.JMXUIActivator;
import com.fusesource.ide.jmx.ui.internal.views.navigator.Navigator;
import com.fusesource.rider.commons.Viewers;
import com.fusesource.rider.commons.tree.HasChildrenArray;
import com.fusesource.rider.commons.tree.HasViewer;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableUI;
import java.util.HashMap;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class MBeanExplorerContentProvider
implements IConnectionProviderListener,
IStructuredContentProvider,
ITreeContentProvider,
RefreshableUI,
HasViewer {
    private Viewer viewer;
    private HashMap<IConnectionWrapper, DelayProxy> loading;

    public MBeanExplorerContentProvider() {
        ExtensionManager.addConnectionProviderListener((IConnectionProviderListener)this);
        this.loading = new HashMap();
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.viewer = v;
        JMXUIActivator.addExplorer(this);
    }

    public void dispose() {
        JMXUIActivator.removeExplorer(this);
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof Node) {
            Node node = (Node)child;
            return node.getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        DomainNode node;
        IConnectionWrapper wrapper;
        if (parent == null) {
            return new Object[0];
        }
        if (parent instanceof HasChildrenArray) {
            HasChildrenArray hasChildren = (HasChildrenArray)parent;
            return hasChildren.getChildObjectArray();
        }
        if (parent instanceof Navigator) {
            Navigator navigator = (Navigator)((Object)parent);
            return navigator.getRootNodes();
        }
        if (parent instanceof IConnectionWrapper && (wrapper = (IConnectionWrapper)parent).isConnected()) {
            return this.loadAndGetRootChildren(parent);
        }
        if (parent instanceof Root) {
            Root root = (Root)parent;
            return root.getChildren();
        }
        if (parent instanceof DomainNode) {
            node = (DomainNode)parent;
            return node.getChildren();
        }
        if (parent instanceof ObjectNameNode) {
            node = (ObjectNameNode)parent;
            return node.getMbeanInfoWrapper().getMBeanFeatureInfos();
        }
        if (parent instanceof Node) {
            node = (Node)parent;
            return node.getChildren();
        }
        return new Object[0];
    }

    protected synchronized Object[] loadAndGetRootChildren(final Object parent) {
        final IConnectionWrapper w = (IConnectionWrapper)parent;
        Root root = w.getRoot();
        if (root != null) {
            return this.getChildren(root);
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    w.loadRoot();
                }
                catch (Throwable re) {
                    JMXUIActivator.getLogger().error("Error while loading from connection...", re);
                }
                MBeanExplorerContentProvider.this.loading.remove(w);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (MBeanExplorerContentProvider.this.viewer instanceof StructuredViewer) {
                            ((StructuredViewer)MBeanExplorerContentProvider.this.viewer).refresh(parent);
                        } else {
                            MBeanExplorerContentProvider.this.viewer.refresh();
                        }
                    }
                });
            }
        };
        if (this.loading.containsKey(parent)) {
            DelayProxy delayProxy = this.loading.get(parent);
            return new Object[]{delayProxy};
        }
        DelayProxy p = new DelayProxy(w);
        this.loading.put(w, p);
        t.start();
        return new Object[]{p};
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof HasChildrenArray) {
            HasChildrenArray cfr_ignored_0 = (HasChildrenArray)parent;
            return true;
        }
        if (parent instanceof ObjectNameNode) {
            ObjectNameNode node = (ObjectNameNode)parent;
            return node.getMbeanInfoWrapper().getMBeanFeatureInfos().length > 0;
        }
        if (parent instanceof Node) {
            Node node = (Node)parent;
            return node.getChildren().length > 0;
        }
        if (parent instanceof MBeanFeatureInfoWrapper) {
            return false;
        }
        if (parent instanceof IConnectionWrapper) {
            return ((IConnectionWrapper)parent).isConnected();
        }
        return true;
    }

    public void connectionAdded(IConnectionWrapper connection) {
        this.fireRefresh(connection, true);
    }

    public void connectionChanged(IConnectionWrapper connection) {
        this.fireRefresh(connection, false);
    }

    public void connectionRemoved(IConnectionWrapper connection) {
        this.fireRefresh(connection, true);
    }

    public void fireRefresh(final Object node, final boolean full) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (Viewers.isVisible((Viewer)MBeanExplorerContentProvider.this.viewer)) {
                    ISelection sel = MBeanExplorerContentProvider.this.viewer.getSelection();
                    IStructuredSelection isel = (IStructuredSelection)sel;
                    Object o = isel.getFirstElement();
                    if (o instanceof Node) {
                        Node n = (Node)o;
                        while (n.getParent() != null) {
                            n = n.getParent();
                        }
                        if (n instanceof Root) {
                            Root r = (Root)n;
                            IConnectionWrapper iconwrap = r.getConnection();
                            MBeanExplorerContentProvider.this.viewer.setSelection(null);
                            if (iconwrap != null && iconwrap.isConnected()) {
                                MBeanExplorerContentProvider.this.viewer.setSelection(sel);
                            } else {
                                Tree tree = (Tree)MBeanExplorerContentProvider.this.viewer.getControl();
                                TreeItem[] items = tree.getItems();
                                if (items.length > 0) {
                                    tree.setSelection(items[0]);
                                    tree.showSelection();
                                }
                            }
                        }
                    }
                    if (full || !(MBeanExplorerContentProvider.this.viewer instanceof StructuredViewer)) {
                        MBeanExplorerContentProvider.this.viewer.refresh();
                    } else {
                        StructuredViewer structuredViewer = (StructuredViewer)MBeanExplorerContentProvider.this.viewer;
                        structuredViewer.refresh(node);
                    }
                }
            }
        });
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public void fireRefresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MBeanExplorerContentProvider.this.viewer != null) {
                    MBeanExplorerContentProvider.this.viewer.refresh();
                }
            }
        });
    }

    public static class DelayProxy {
        public IConnectionWrapper wrapper;

        public DelayProxy(IConnectionWrapper wrapper) {
            this.wrapper = wrapper;
        }
    }
}

