/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.views.navigator;

import com.fusesource.ide.jmx.core.ExtensionManager;
import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.core.JMXActivator;
import com.fusesource.ide.jmx.core.tree.NodeProvider;
import com.fusesource.ide.jmx.ui.JMXUIActivator;
import com.fusesource.ide.jmx.ui.internal.actions.NewConnectionAction;
import com.fusesource.ide.jmx.ui.internal.actions.RefreshAction;
import com.fusesource.ide.jmx.ui.internal.views.navigator.QueryContribution;
import com.fusesource.rider.commons.Viewers;
import com.fusesource.rider.commons.tree.HasChildrenArray;
import com.fusesource.rider.commons.tree.HasViewer;
import com.fusesource.rider.commons.tree.RefreshableUI;
import com.fusesource.rider.commons.ui.Selections;
import com.fusesource.rider.commons.ui.drop.DelegateDropListener;
import com.fusesource.rider.commons.ui.drop.DeployMenuProvider;
import com.fusesource.rider.commons.ui.drop.DropHandler;
import com.fusesource.rider.commons.ui.drop.DropHandlerFactory;
import com.fusesource.rider.commons.ui.views.DynamicPropertySheetTracker;
import com.fusesource.rider.deployment.DeployPlugin;
import com.fusesource.rider.deployment.DeployViews;
import com.fusesource.rider.deployment.maven.ProjectDropHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class Navigator
extends CommonNavigator
implements DeployMenuProvider {
    private Text filterText;
    private QueryContribution query;
    private DynamicPropertySheetTracker propertySheetTracker = new DynamicPropertySheetTracker();
    private RefreshAction refreshAction;
    private ISelection viewerSelection;
    private Object[] rootNodes;
    protected RefreshableUI refreshableUI = new RefreshableUIImplementation();
    private boolean registered;

    protected IAdaptable getInitialInput() {
        return this;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            IAdaptable adaptable;
            Object answer;
            Object firstSelection = null;
            if (this.viewerSelection != null) {
                firstSelection = Selections.getFirstSelection((ISelection)this.viewerSelection);
            }
            if (firstSelection == null) {
                firstSelection = Selections.getFirstSelection((IWorkbenchSite)this.getViewSite());
            }
            if (firstSelection == null) {
                firstSelection = Selections.getFirstSelection((Viewer)this.getCommonViewer());
            }
            if (firstSelection instanceof IAdaptable && (answer = (adaptable = (IAdaptable)firstSelection).getAdapter(adapter)) != null) {
                return answer;
            }
            return new PropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    public void createPartControl(Composite aParent) {
        this.fillActionBars();
        Composite newParent = new Composite(aParent, 0);
        newParent.setLayout((Layout)new FormLayout());
        super.createPartControl(newParent);
        this.filterText = new Text(newParent, 2052);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.top = new FormAttachment(0, 5);
        this.filterText.setLayoutData((Object)fd);
        Text topOfTree = this.filterText;
        boolean haveTools = false;
        try {
            haveTools = Class.forName("javax.tools.ToolProvider", false, ((Object)((Object)this)).getClass().getClassLoader()) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (!haveTools) {
            Link noJDKLlink = new Link(newParent, 4);
            noJDKLlink.setText("You cannot use the JMX browser until you specify the location of the JDK\u2019s tools.jar file. Go to the <a>JMX Tools preferences page</a> to set it.");
            noJDKLlink.setForeground(noJDKLlink.getDisplay().getSystemColor(3));
            fd = new FormData();
            fd.left = new FormAttachment(0, 5);
            fd.right = new FormAttachment(100, -5);
            fd.top = new FormAttachment((Control)this.filterText, 5);
            noJDKLlink.setLayoutData((Object)fd);
            noJDKLlink.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    PreferenceDialog pref = PreferencesUtil.createPreferenceDialogOn((Shell)((Control)e.widget).getShell(), (String)"com.fusesource.ide.jvmmonitor.tools.ToolsPreferencePage", null, null);
                    if (pref != null) {
                        pref.open();
                    }
                }
            });
            topOfTree = noJDKLlink;
        }
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)topOfTree, 5);
        fd.bottom = new FormAttachment(100, 0);
        CommonViewer viewer = this.getCommonViewer();
        Tree tree = viewer.getTree();
        tree.setLayoutData((Object)fd);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                Navigator.this.viewerSelection = selection;
                Navigator.this.propertySheetTracker.selectionChanged((IWorkbenchPart)Navigator.this, selection);
            }
        });
        this.filterText.setToolTipText("Type in a filter");
        this.filterText.setText("Type in a filter");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Navigator.this.query = new QueryContribution(Navigator.this);
            }
        });
    }

    public Text getFilterText() {
        return this.filterText;
    }

    public RefreshAction getRefreshAction() {
        if (this.refreshAction == null) {
            this.refreshAction = new RefreshAction(this.getViewSite().getId());
            this.refreshAction.setViewer((StructuredViewer)this.getCommonViewer());
        }
        return this.refreshAction;
    }

    public void fillActionBars() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)new NewConnectionAction());
        toolBarManager.add((IAction)this.getRefreshAction());
        toolBarManager.add((IContributionItem)new Separator());
        this.getViewSite().getActionBars().updateActionBars();
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        return new CommonViewer(this.getViewSite().getId(), aParent, 770){

            public void addDragSupport(int operations, Transfer[] transferTypes, DragSourceListener listener) {
                super.addDragSupport(operations, transferTypes, listener);
            }

            public void addDropSupport(int operations, Transfer[] transferTypes, DropTargetListener listener) {
                Transfer[] newTransferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance(), ResourceTransfer.getInstance(), TextTransfer.getInstance()};
                super.addDropSupport(operations, newTransferTypes, (DropTargetListener)new DelegateDropListener((Viewer)this, listener));
            }
        };
    }

    public void appendDeployActions(Menu menu, final IResource resource) {
        boolean added = false;
        if (resource instanceof IProject) {
            Object[] nodes;
            Object[] objectArray = nodes = this.getRootNodes();
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof HasChildrenArray) {
                    Object[] children;
                    HasChildrenArray node = (HasChildrenArray)object;
                    Object[] objectArray2 = children = node.getChildObjectArray();
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        DropHandlerFactory factory;
                        DropHandler handler;
                        Object child = objectArray2[n4];
                        if (child instanceof DropHandlerFactory && (handler = (factory = (DropHandlerFactory)child).createDropHandler(null)) instanceof ProjectDropHandler) {
                            final ProjectDropHandler projectHandler = (ProjectDropHandler)handler;
                            System.out.println("Found child " + child);
                            MenuItem i = new MenuItem(menu, 8);
                            i.setText(child.toString());
                            i.setImage(DeployPlugin.getDefault().getImage("container.png"));
                            i.setData(child);
                            i.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    System.out.println("======== about to deploy to handler: " + projectHandler);
                                    projectHandler.dropProject((IProject)resource);
                                }
                            });
                            added = true;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        if (added) {
            new MenuItem(menu, 2);
        }
    }

    public Object[] getRootNodes() {
        Object[] answer;
        if (this.rootNodes == null) {
            IConnectionWrapper[] connections = ExtensionManager.getAllConnections();
            ArrayList<IConnectionWrapper> list = new ArrayList<IConnectionWrapper>();
            JMXUIActivator.provideRootNodes(this.refreshableUI, list);
            list.addAll(Arrays.asList(connections));
            List nodeProviders = JMXActivator.getNodeProviders();
            for (NodeProvider provider : nodeProviders) {
                provider.provideRootNodes(list);
            }
            this.rootNodes = list.toArray();
        }
        if ((answer = this.rootNodes) != null && answer.length == 0) {
            this.rootNodes = null;
        }
        if (this.rootNodes != null) {
            this.ensureDeployViewRegistered();
        }
        return answer;
    }

    protected void ensureDeployViewRegistered() {
        if (!this.registered) {
            DeployViews.registerView((String)this.getViewId(), (IViewPart)this);
            this.registered = true;
        }
    }

    protected String getViewId() {
        return "com.fusesource.ide.jmx.ui.internal.views.navigator.MBeanExplorer";
    }

    public final class RefreshableUIImplementation
    implements RefreshableUI,
    HasViewer {
        public void fireRefresh(final Object node, final boolean full) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Navigator.this.getCommonViewer().refresh(node, full);
                }
            });
        }

        public void fireRefresh() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Viewers.refresh((Viewer)Navigator.this.getCommonViewer());
                }
            });
        }

        public Viewer getViewer() {
            return Navigator.this.getCommonViewer();
        }
    }
}

