/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.wizards;

import com.fusesource.ide.jmx.core.ExtensionManager;
import com.fusesource.ide.jmx.core.IConnectionProvider;
import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.ui.ConnectionWizardPage;
import com.fusesource.ide.jmx.ui.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class DefaultConnectionWizardPage
extends WizardPage
implements ConnectionWizardPage {
    private static final String _BLANK_ = "";
    private TabFolder folder;
    private TabItem simpleItem;
    private TabItem advancedItem;
    private Text hostText;
    private Text portText;
    private Text urlText;
    private Text nameText;
    private Text userNameText;
    private Text passwordText;
    private Text advancedNameText;
    private Text advancedUserNameText;
    private Text advancedPasswordText;
    private String name;
    private String url;
    private String userName;
    private String password;

    private void addListeners() {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DefaultConnectionWizardPage.this.validate();
            }
        };
        SelectionListener tabListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TabItem[] tabs = DefaultConnectionWizardPage.this.folder.getSelection();
                if (tabs[0] == DefaultConnectionWizardPage.this.simpleItem) {
                    DefaultConnectionWizardPage.this.nameText.setText(DefaultConnectionWizardPage.this.advancedNameText.getText());
                    DefaultConnectionWizardPage.this.userNameText.setText(DefaultConnectionWizardPage.this.advancedUserNameText.getText());
                    DefaultConnectionWizardPage.this.passwordText.setText(DefaultConnectionWizardPage.this.advancedPasswordText.getText());
                } else {
                    DefaultConnectionWizardPage.this.advancedNameText.setText(DefaultConnectionWizardPage.this.nameText.getText());
                    DefaultConnectionWizardPage.this.advancedUserNameText.setText(DefaultConnectionWizardPage.this.userNameText.getText());
                    DefaultConnectionWizardPage.this.advancedPasswordText.setText(DefaultConnectionWizardPage.this.passwordText.getText());
                }
            }
        };
        this.nameText.addModifyListener(listener);
        this.hostText.addModifyListener(listener);
        this.portText.addModifyListener(listener);
        this.urlText.addModifyListener(listener);
        this.userNameText.addModifyListener(listener);
        this.passwordText.addModifyListener(listener);
        this.advancedNameText.addModifyListener(listener);
        this.advancedUserNameText.addModifyListener(listener);
        this.advancedPasswordText.addModifyListener(listener);
        this.folder.addSelectionListener(tabListener);
    }

    public DefaultConnectionWizardPage() {
        super(_BLANK_);
        this.setDescription(Messages.DefaultConnectionWizardPage_Description);
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new FillLayout());
        this.folder = new TabFolder(c, 128);
        this.simpleItem = new TabItem(this.folder, 0);
        this.simpleItem.setText(Messages.DefaultConnectionWizardPage_Simple);
        this.simpleItem.setControl(this.createSimpleConnectionPage((Composite)this.folder));
        this.advancedItem = new TabItem(this.folder, 0);
        this.advancedItem.setText(Messages.DefaultConnectionWizardPage_Advanced);
        this.advancedItem.setControl(this.createAdvancedConnectionPage((Composite)this.folder));
        this.setControl((Control)c);
        this.addListeners();
        this.validate();
    }

    private Control createSimpleConnectionPage(Composite parent) {
        Composite fieldComposite = new Composite(parent, 2048);
        fieldComposite.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(1808);
        Label nameLabel = new Label(fieldComposite, 0x1000000);
        nameLabel.setText(Messages.DefaultConnectionWizardPage_Name);
        this.nameText = new Text(fieldComposite, 2048);
        this.nameText.setText(this.getNextName());
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.nameText.setLayoutData((Object)data);
        Label label = new Label(fieldComposite, 0x1000000);
        label.setText(Messages.DefaultConnectionWizardPage_Host);
        this.hostText = new Text(fieldComposite, 2048);
        this.hostText.setText("localhost");
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)data);
        label = new Label(fieldComposite, 0x1000000);
        label.setText(Messages.DefaultConnectionWizardPage_Port);
        this.portText = new Text(fieldComposite, 2048);
        this.portText.setTextLimit(5);
        this.portText.setText("3000");
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.portText.setLayoutData((Object)data);
        label = new Label(fieldComposite, 0x1000000);
        label.setText(Messages.DefaultConnectionWizardPage_Username);
        this.userNameText = new Text(fieldComposite, 2048);
        this.userNameText.setText(_BLANK_);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.userNameText.setLayoutData((Object)data);
        label = new Label(fieldComposite, 0x1000000);
        label.setText(Messages.DefaultConnectionWizardPage_Password);
        this.passwordText = new Text(fieldComposite, 0x400800);
        this.passwordText.setText(_BLANK_);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.passwordText.setLayoutData((Object)data);
        return fieldComposite;
    }

    private Control createAdvancedConnectionPage(Composite parent) {
        Composite fieldComposite = new Composite(parent, 2048);
        fieldComposite.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(1808);
        Label nameLabel = new Label(fieldComposite, 0x1000000);
        nameLabel.setText(Messages.DefaultConnectionWizardPage_Name);
        this.advancedNameText = new Text(fieldComposite, 2048);
        this.advancedNameText.setText(this.getNextName());
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.advancedNameText.setLayoutData((Object)data);
        Label label = new Label(fieldComposite, 0x1000000);
        label.setText(Messages.DefaultConnectionWizardPage_JMX_URL);
        this.urlText = new Text(fieldComposite, 2048);
        this.urlText.setText("service:jmx:rmi:");
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.urlText.setLayoutData((Object)data);
        label = new Label(fieldComposite, 0x1000000);
        label.setText(Messages.DefaultConnectionWizardPage_Username);
        this.advancedUserNameText = new Text(fieldComposite, 2048);
        this.advancedUserNameText.setText(_BLANK_);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.advancedUserNameText.setLayoutData((Object)data);
        label = new Label(fieldComposite, 0x1000000);
        label.setText(Messages.DefaultConnectionWizardPage_Password);
        this.advancedPasswordText = new Text(fieldComposite, 0x400800);
        this.advancedPasswordText.setText(_BLANK_);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.advancedPasswordText.setLayoutData((Object)data);
        return fieldComposite;
    }

    protected String getNextName() {
        int count = 1;
        if (this.nameTaken(Messages.DefaultConnectionWizardPage_Default_Name)) {
            String name;
            while (this.nameTaken(name = String.valueOf(Messages.DefaultConnectionWizardPage_Default_Name) + " " + count++)) {
            }
            return name;
        }
        return Messages.DefaultConnectionWizardPage_Default_Name;
    }

    protected void validate() {
        if (this.folder.getSelectionIndex() == 0) {
            int port;
            this.name = this.nameText.getText();
            this.userName = this.userNameText.getText();
            this.password = this.passwordText.getText();
            if (this.hostText.getText().equals(_BLANK_)) {
                this.showError(_BLANK_, _BLANK_);
                return;
            }
            try {
                InetAddress.getByName(this.hostText.getText());
            }
            catch (UnknownHostException unknownHostException) {
                this.showError(_BLANK_, _BLANK_);
                return;
            }
            String host = this.hostText.getText();
            if (this.portText.getText().equals(_BLANK_)) {
                this.showError(_BLANK_, _BLANK_);
                return;
            }
            try {
                port = Integer.parseInt(this.portText.getText());
                if (port < 1 || port > 65535) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.showError(_BLANK_, _BLANK_);
                return;
            }
            this.url = "service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/jmxrmi";
        } else if (this.folder.getSelectionIndex() == 1) {
            this.name = this.advancedNameText.getText();
            this.userName = this.advancedUserNameText.getText();
            this.password = this.advancedPasswordText.getText();
            if (this.urlText.getText().equals(_BLANK_)) {
                this.showError(_BLANK_, _BLANK_);
                return;
            }
            this.url = this.urlText.getText();
        }
        if (this.name == null || this.nameTaken(this.name)) {
            this.showError(_BLANK_, _BLANK_);
            return;
        }
        this.clearMessage();
    }

    protected void clearMessage() {
        this.setErrorMessage(null);
        this.getContainer().updateMessage();
    }

    protected void showError(String one, String two) {
        this.setErrorMessage("There's an error somewhere");
        this.getContainer().updateMessage();
    }

    protected boolean nameTaken(String s) {
        IConnectionProvider provider = ExtensionManager.getProvider((String)"com.fusesource.ide.jmx.core.providers.DefaultConnectionProvider");
        IConnectionWrapper[] connections = provider.getConnections();
        int i = 0;
        while (i < connections.length) {
            if (provider.getName(connections[i]).equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    String getURL() {
        return this.url;
    }

    String getUserName() {
        return this.userName;
    }

    String getPassword() {
        return this.password;
    }

    @Override
    public IConnectionWrapper getConnection() throws CoreException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", this.name);
        map.put("url", this.url);
        map.put("username", this.userName);
        map.put("password", this.password);
        IConnectionProvider provider = ExtensionManager.getProvider((String)"com.fusesource.ide.jmx.core.providers.DefaultConnectionProvider");
        return provider.createConnection(map);
    }
}

