/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.analyzer.config;

import org.eclipse.wst.wsi.internal.core.WSIException;

public final class AssertionResultType {
    private String resultType = "all";
    private static final String _ALL = "all";
    private static final String _NOT_INFO = "notInfo";
    private static final String _ONLY_FAILED = "onlyFailed";
    private static final String _NOT_PASSED = "notPassed";
    public static final AssertionResultType ALL = new AssertionResultType("all");
    public static final AssertionResultType NOT_INFO = new AssertionResultType("notInfo");
    public static final AssertionResultType ONLY_FAILED = new AssertionResultType("onlyFailed");
    public static final AssertionResultType NOT_PASSED = new AssertionResultType("notPassed");

    private AssertionResultType() {
    }

    private AssertionResultType(String resultType) {
        this.resultType = resultType;
    }

    public boolean isAll() {
        return this.resultType.equals(_ALL);
    }

    public boolean isFailedOnly() {
        return this.resultType.equals(_ONLY_FAILED);
    }

    public boolean isNotPassed() {
        return this.resultType.equals(_NOT_PASSED);
    }

    public boolean isNotInfo() {
        return this.resultType.equals(_NOT_INFO);
    }

    public String getType() {
        return this.resultType;
    }

    public static AssertionResultType newInstance(String resultType) throws WSIException {
        AssertionResultType assertionResultType = null;
        if (resultType == null) {
            assertionResultType = NOT_INFO;
        } else if (resultType.equals(_ALL)) {
            assertionResultType = ALL;
        } else if (resultType.equals(_ONLY_FAILED)) {
            assertionResultType = ONLY_FAILED;
        } else if (resultType.equals(_NOT_PASSED)) {
            assertionResultType = NOT_PASSED;
        } else if (resultType.equals(_NOT_INFO)) {
            assertionResultType = NOT_INFO;
        } else {
            throw new WSIException("An invalid assertion result type was specified: " + resultType + ".");
        }
        return assertionResultType;
    }

    public String toString() {
        return this.resultType;
    }
}

