/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr;

import java.lang.ref.WeakReference;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionAtomic;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombinedOperator;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNested;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.actions.DeleteExpressionAction;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr.ExpressionElement;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr.ExpressionsByOperatorsPage;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.views.BuilderUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.DynamicComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.NavigableTableViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ExpressionsTable
extends NavigableTableViewer
implements IMenuListener {
    public static final String P_EXPRESSION = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.P_EXPRESSION";
    public static final String P_OPERATOR = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.P_OPERATOR";
    private SQLDomainModel domainModel;
    private DynamicComboBoxCellEditor expressionsComboBoxCellEditor;
    private OperatorsComboBoxCellEditor operatorsComboBoxCellEditor;
    private SQLQueryObject sqlStatement;
    private ExpressionsByOperatorsPage expressionsByOperatorsPage;
    private Table table;
    private TableColumn c1;
    private TableColumn c2;

    ExpressionsTable(ExpressionsByOperatorsPage ebop, Composite parent, SQLDomainModel domainModel, SQLQueryObject sqlStmt) {
        super(new Table(parent, 67586));
        this.domainModel = domainModel;
        this.sqlStatement = sqlStmt;
        this.expressionsByOperatorsPage = ebop;
        this.table = this.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.expressionsComboBoxCellEditor = new DynamicComboBoxCellEditor((Composite)this.table, null, (Object)this);
        this.c1 = new TableColumn(this.table, 0);
        this.c1.setText(Messages._UI_COLUMN_EXPRESSION);
        this.operatorsComboBoxCellEditor = new OperatorsComboBoxCellEditor((Composite)this.table);
        this.c2 = new TableColumn(this.table, 0);
        this.c2.setText(Messages._UI_COLUMN_OPERATOR);
        this.fillOperatorsComboBox();
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(330, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(75, true));
        this.table.setLayout((Layout)layout);
        String[] properties = new String[]{P_EXPRESSION, P_OPERATOR};
        this.setColumnProperties(properties);
        CellEditor[] editors = new CellEditor[]{this.expressionsComboBoxCellEditor, this.operatorsComboBoxCellEditor};
        this.setCellEditors(editors);
        this.setCellModifier(new ExpressionsTableCellModifier(this));
        this.setLabelProvider((IBaseLabelProvider)new ExpressionsTableLabelProvider());
        this.setContentProvider((IContentProvider)new ExpressionsTableContentProvider());
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    public ExpressionsByOperatorsPage getExpressionsByOperatorsPage() {
        return this.expressionsByOperatorsPage;
    }

    public SQLDomainModel getDomainModel() {
        return this.domainModel;
    }

    public SQLQueryObject getSQLStatement() {
        return this.sqlStatement;
    }

    public void refresh() {
        if (!this.isCellEditorActive()) {
            super.refresh();
        }
    }

    public void refreshCellEditor(int row) {
        QueryValueExpression expr;
        boolean existsExpression = false;
        Object obj = this.getElementAt(row);
        if (obj instanceof ExpressionElement && (expr = ((ExpressionElement)obj).getExpression()) instanceof QueryValueExpression) {
            existsExpression = true;
        }
        BuilderUtility.fillColumnComboBox(this.expressionsComboBoxCellEditor, this.sqlStatement, true, existsExpression);
        CellEditor[] editors = new CellEditor[]{this.expressionsComboBoxCellEditor, this.operatorsComboBoxCellEditor};
        this.setCellEditors(editors);
    }

    public void menuAboutToShow(IMenuManager menu) {
        DeleteExpressionAction deleteExpressionAction = new DeleteExpressionAction(this, this.expressionsByOperatorsPage);
        menu.add((IAction)deleteExpressionAction);
    }

    private void fillOperatorsComboBox() {
        LabelValuePair[] operators = new LabelValuePair[]{new LabelValuePair(" ", " "), new LabelValuePair("+", "+"), new LabelValuePair("-", "-"), new LabelValuePair("*", "*"), new LabelValuePair("/", "/"), new LabelValuePair("CONCAT", "CONCAT")};
        this.operatorsComboBoxCellEditor.createItems(operators);
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
    }

    public class ExpressionsTableCellModifier
    implements ICellModifier {
        ExpressionsTable viewer;
        Object currentElement;
        Object currentValue;
        String currentProperty;
        ExpressionElement expressionElement;
        QueryValueExpression expr;

        public ExpressionsTableCellModifier(ExpressionsTable viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return property.equals(ExpressionsTable.P_EXPRESSION) || property.equals(ExpressionsTable.P_OPERATOR);
        }

        public Object getValue(Object element, String property) {
            return element;
        }

        public void modify(Object element, String property, Object value) {
            this.currentElement = element;
            this.currentProperty = property;
            this.currentValue = value;
            Object data = ((TableItem)this.currentElement).getData();
            if (property.equals(ExpressionsTable.P_EXPRESSION)) {
                Assert.isTrue((boolean)(this.currentElement instanceof TableItem));
                if (this.currentValue == null) {
                    return;
                }
                if (data instanceof ExpressionElement) {
                    this.expressionElement = (ExpressionElement)data;
                    if (this.currentValue instanceof QueryValueExpression) {
                        this.expr = (QueryValueExpression)this.currentValue;
                        this.expressionElement.setExpression(this.expr);
                        Vector elements = this.expressionElement.getElementsVector();
                        if (elements != null && !elements.isEmpty()) {
                            ExpressionElement e = (ExpressionElement)elements.get(0);
                            QueryValueExpression firstExpr = e.getExpression();
                            ExpressionsTable.this.getExpressionsByOperatorsPage().setExpression(firstExpr);
                            this.viewer.setInput(firstExpr);
                        }
                        ExpressionsTable.this.getExpressionsByOperatorsPage().updateFinishButton();
                    } else if (this.currentValue instanceof String) {
                        String valueString = (String)this.currentValue;
                        ExpressionsTable.this.getExpressionsByOperatorsPage().setElementToUpdate(this.expressionElement);
                        QueryValueExpression currExpr = this.expressionElement.getExpression();
                        if (valueString.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_EDIT_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                            ExpressionBuilderWizard wizard = new ExpressionBuilderWizard(ExpressionsTable.this.getDomainModel(), ExpressionsTable.this.getSQLStatement());
                            if (valueString.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                                wizard.setInputExpression(null);
                            } else if (valueString.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
                                wizard.setInputExpression(currExpr);
                            }
                            wizard.setIsColumn(false);
                            ExpressionBuilderDialog dialog = new ExpressionBuilderDialog(Display.getDefault().getActiveShell(), wizard);
                            dialog.create();
                            dialog.setBlockOnOpen(true);
                            int result = dialog.open();
                            QueryValueExpression newExpr = null;
                            if (result == 0) {
                                newExpr = wizard.getSQLExpression();
                            }
                            if (newExpr != null) {
                                if (newExpr instanceof ValueExpressionCombined) {
                                    ValueExpressionNested nestedExpr = ExpressionHelper.createNestedExpression(newExpr);
                                    this.expressionElement.setExpression((QueryValueExpression)nestedExpr);
                                } else {
                                    this.expressionElement.setExpression(newExpr);
                                }
                                Vector elements = this.expressionElement.getElementsVector();
                                if (elements != null && !elements.isEmpty()) {
                                    ExpressionElement e = (ExpressionElement)elements.get(0);
                                    QueryValueExpression expr2 = e.getExpression();
                                    ExpressionsTable.this.getExpressionsByOperatorsPage().setExpression(expr2);
                                    this.viewer.setInput(this.expr);
                                }
                            }
                            ExpressionsTable.this.getExpressionsByOperatorsPage().updateFinishButton();
                        }
                    }
                }
            } else if (property.equals(ExpressionsTable.P_OPERATOR)) {
                Assert.isTrue((boolean)(element instanceof TableItem));
                if (this.currentValue == null) {
                    return;
                }
                if (data instanceof ExpressionElement) {
                    this.expressionElement = (ExpressionElement)data;
                    if (this.currentValue instanceof String) {
                        this.expressionElement.setOperator((String)this.currentValue);
                        Vector elements = this.expressionElement.getElementsVector();
                        if (elements != null && !elements.isEmpty()) {
                            ExpressionElement e = (ExpressionElement)elements.get(0);
                            QueryValueExpression expr2 = e.getExpression();
                            ExpressionsTable.this.getExpressionsByOperatorsPage().setExpression(expr2);
                            this.viewer.setInput(expr2);
                        }
                        ExpressionsTable.this.getExpressionsByOperatorsPage().updateFinishButton();
                    }
                }
            }
        }
    }

    public class ExpressionsTableContentProvider
    implements IStructuredContentProvider {
        protected Vector tableElements;

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }

        public Object[] getElements(Object object) {
            this.tableElements = new Vector();
            if (object instanceof QueryValueExpression) {
                QueryValueExpression initialNode = (QueryValueExpression)object;
                this.getAllExpressionElements(initialNode);
                this.addBlankExpressionElement(initialNode);
            }
            return this.tableElements.toArray();
        }

        void getAllExpressionElements(QueryValueExpression expr) {
            ValueExpressionCombined parent = null;
            ValueExpressionCombinedOperator operator = null;
            if (expr instanceof ValueExpressionAtomic || expr instanceof ValueExpressionNested) {
                parent = expr.getValueExprCombinedLeft();
                if (parent != null) {
                    operator = parent.getCombinedOperator();
                }
                this.creatExpressionElement(expr, operator);
            } else if (expr instanceof ValueExpressionCombined) {
                ValueExpressionCombined combinedExpr = (ValueExpressionCombined)expr;
                parent = expr.getValueExprCombinedLeft();
                QueryValueExpression rightChild = combinedExpr.getRightValueExpr();
                if (rightChild != null) {
                    if (parent != null) {
                        operator = parent.getCombinedOperator();
                    }
                    this.creatExpressionElement(rightChild, operator);
                }
            }
            if (parent != null) {
                this.getAllExpressionElements((QueryValueExpression)parent);
            }
        }

        void creatExpressionElement(QueryValueExpression node, ValueExpressionCombinedOperator opr) {
            ExpressionElement exprElement = new ExpressionElement(node, opr);
            WeakReference<Vector> tableElementRef = new WeakReference<Vector>(this.tableElements);
            exprElement.setExprElementVectorRef(tableElementRef);
            this.tableElements.add(exprElement);
        }

        void addBlankExpressionElement(QueryValueExpression initialNode) {
            if (this.tableElements.size() == 0) {
                this.creatExpressionElement(initialNode, null);
            } else {
                ExpressionElement lastElement = (ExpressionElement)this.tableElements.lastElement();
                if (lastElement.getOperator() != null) {
                    this.creatExpressionElement(null, null);
                }
            }
        }
    }

    class ExpressionsTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ExpressionsTableLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof ExpressionElement) {
                ExpressionElement expressionElement = (ExpressionElement)object;
                if (columnIndex == 0) {
                    return expressionElement.getExpressionString();
                }
                if (columnIndex == 1) {
                    return expressionElement.getOperatorString();
                }
            }
            return "";
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }

    class OperatorsComboBoxCellEditor
    extends ComboBoxCellEditor {
        public OperatorsComboBoxCellEditor(Composite parent) {
            super(parent, null);
        }

        protected void doSetValue(Object value) {
            super.doSetValue(value);
        }
    }
}

