/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.DeltaProcessingState;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.index.IndexManager;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.IClasspathManager;
import org.eclipse.m2e.jdt.IClasspathManagerDelegate;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.ClasspathDescriptor;
import org.eclipse.m2e.jdt.internal.DefaultClasspathManagerDelegate;
import org.eclipse.m2e.jdt.internal.DownloadSourcesJob;
import org.eclipse.m2e.jdt.internal.MavenClasspathContainer;
import org.eclipse.m2e.jdt.internal.MavenClasspathContainerSaveHelper;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;
import org.eclipse.m2e.jdt.internal.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPathManager
implements IMavenProjectChangedListener,
IResourceChangeListener,
IClasspathManager {
    private static final Logger log = LoggerFactory.getLogger(BuildPathManager.class);
    public static final String M2_REPO = "M2_REPO";
    private static final String PROPERTY_SRC_ROOT = ".srcRoot";
    private static final String PROPERTY_SRC_PATH = ".srcPath";
    private static final String PROPERTY_JAVADOC_URL = ".javadoc";
    static final String CLASSIFIER_SOURCES = "sources";
    static final String CLASSIFIER_JAVADOC = "javadoc";
    static final String CLASSIFIER_TESTS = "tests";
    static final String CLASSIFIER_TESTSOURCES = "test-sources";
    public static final ArtifactFilter SCOPE_FILTER_RUNTIME = new ScopeArtifactFilter("runtime");
    public static final ArtifactFilter SCOPE_FILTER_TEST = new ScopeArtifactFilter("test");
    final IMavenProjectRegistry projectManager;
    final IMavenConfiguration mavenConfiguration;
    final IndexManager indexManager;
    final BundleContext bundleContext;
    final IMaven maven;
    final File stateLocationDir;
    private String jdtVersion;
    private final DownloadSourcesJob downloadSourcesJob;
    private final DefaultClasspathManagerDelegate defaultDelegate;

    public BuildPathManager(IMavenProjectRegistry projectManager, IndexManager indexManager, BundleContext bundleContext, File stateLocationDir) {
        this.projectManager = projectManager;
        this.indexManager = indexManager;
        this.mavenConfiguration = MavenPlugin.getMavenConfiguration();
        this.bundleContext = bundleContext;
        this.stateLocationDir = stateLocationDir;
        this.maven = MavenPlugin.getMaven();
        this.downloadSourcesJob = new DownloadSourcesJob(this);
        this.defaultDelegate = new DefaultClasspathManagerDelegate();
    }

    public static IClasspathEntry getMavenContainerEntry(IJavaProject javaProject) {
        if (javaProject != null) {
            try {
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (MavenClasspathHelpers.isMaven2ClasspathContainer(entry.getPath())) {
                        return entry;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forcePackageExplorerRefresh(IJavaProject javaProject) {
        if (this.getJDTVersion().startsWith("3.3")) {
            DeltaProcessingState state;
            DeltaProcessingState deltaProcessingState = state = JavaModelManager.getJavaModelManager().deltaState;
            synchronized (deltaProcessingState) {
                IElementChangedListener[] iElementChangedListenerArray = state.elementChangedListeners;
                int n = state.elementChangedListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    IElementChangedListener listener = iElementChangedListenerArray[n2];
                    if (listener instanceof PackageExplorerContentProvider) {
                        JavaElementDelta delta = new JavaElementDelta((IJavaElement)javaProject);
                        delta.changed(131072);
                        listener.elementChanged(new ElementChangedEvent((IJavaElementDelta)delta, 1));
                    }
                    ++n2;
                }
            }
        }
    }

    private synchronized String getJDTVersion() {
        if (this.jdtVersion == null) {
            Bundle[] bundles = this.bundleContext.getBundles();
            int i = 0;
            while (i < bundles.length) {
                if ("org.eclipse.jdt.core".equals(bundles[i].getSymbolicName())) {
                    this.jdtVersion = (String)bundles[i].getHeaders().get("Bundle-Version");
                    break;
                }
                ++i;
            }
        }
        return this.jdtVersion;
    }

    public static IClasspathContainer getMaven2ClasspathContainer(IJavaProject project) throws JavaModelException {
        IClasspathEntry[] entries = project.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 5 && MavenClasspathHelpers.isMaven2ClasspathContainer(entry.getPath())) {
                return JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
            }
            ++i;
        }
        return null;
    }

    public void mavenProjectChanged(MavenProjectChangedEvent[] events, IProgressMonitor monitor) {
        HashSet<IProject> projects = new HashSet<IProject>();
        monitor.setTaskName(Messages.BuildPathManager_monitor_setting_cp);
        int i = 0;
        while (i < events.length) {
            MavenProjectChangedEvent event = events[i];
            IFile pom = event.getSource();
            IProject project = pom.getProject();
            if (project.isAccessible() && projects.add(project)) {
                this.updateClasspath(project, monitor);
            }
            ++i;
        }
    }

    @Override
    public void updateClasspath(IProject project, IProgressMonitor monitor) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            try {
                IClasspathEntry containerEntry = BuildPathManager.getMavenContainerEntry(javaProject);
                IPath path = containerEntry != null ? containerEntry.getPath() : new Path("org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER");
                IClasspathEntry[] classpath = this.getClasspath(project, monitor);
                MavenClasspathContainer container = new MavenClasspathContainer(path, classpath);
                JavaCore.setClasspathContainer((IPath)container.getPath(), (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, (IProgressMonitor)monitor);
                this.forcePackageExplorerRefresh(javaProject);
                this.saveContainerState(project, container);
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void saveContainerState(IProject project, IClasspathContainer container) {
        block12: {
            File containerStateFile = this.getContainerStateFile(project);
            FileOutputStream is = null;
            try {
                try {
                    is = new FileOutputStream(containerStateFile);
                    new MavenClasspathContainerSaveHelper().writeContainer(container, is);
                }
                catch (IOException ex) {
                    log.error("Can't save classpath container state for " + project.getName(), (Throwable)ex);
                    if (is == null) break block12;
                    try {
                        is.close();
                    }
                    catch (IOException ex2) {
                        log.error("Can't close output stream for " + containerStateFile.getAbsolutePath(), (Throwable)ex2);
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        log.error("Can't close output stream for " + containerStateFile.getAbsolutePath(), (Throwable)ex);
                    }
                }
            }
        }
    }

    public IClasspathContainer getSavedContainer(IProject project) throws CoreException {
        File containerStateFile = this.getContainerStateFile(project);
        if (!containerStateFile.exists()) {
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(containerStateFile);
            IClasspathContainer iClasspathContainer = new MavenClasspathContainerSaveHelper().readContainer(is);
            return iClasspathContainer;
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, MavenJdtPlugin.PLUGIN_ID, -1, "Can't read classpath container state for " + project.getName(), (Throwable)ex));
        }
        catch (ClassNotFoundException ex) {
            throw new CoreException((IStatus)new Status(4, MavenJdtPlugin.PLUGIN_ID, -1, "Can't read classpath container state for " + project.getName(), (Throwable)ex));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    log.error("Can't close output stream for " + containerStateFile.getAbsolutePath(), (Throwable)ex);
                }
            }
        }
    }

    private IClasspathEntry[] getClasspath(IMavenProjectFacade projectFacade, int kind, Properties sourceAttachment, boolean uniquePaths, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)projectFacade.getProject());
        ClasspathDescriptor classpath = new ClasspathDescriptor(javaProject);
        this.getDelegate(projectFacade, monitor).populateClasspath(classpath, projectFacade, kind, monitor);
        this.configureAttchedSourcesAndJavadoc(projectFacade, sourceAttachment, classpath, monitor);
        IClasspathEntry[] entries = classpath.getEntries();
        if (uniquePaths) {
            LinkedHashMap<IPath, IClasspathEntry> paths = new LinkedHashMap<IPath, IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (!paths.containsKey(entry.getPath())) {
                    paths.put(entry.getPath(), entry);
                }
                ++n2;
            }
            return paths.values().toArray(new IClasspathEntry[paths.size()]);
        }
        return entries;
    }

    private IClasspathManagerDelegate getDelegate(IMavenProjectFacade projectFacade, IProgressMonitor monitor) throws CoreException {
        ILifecycleMapping lifecycleMapping = LifecycleMappingFactory.getLifecycleMapping((IMavenProjectFacade)projectFacade);
        if (lifecycleMapping instanceof IClasspathManagerDelegate) {
            return (IClasspathManagerDelegate)lifecycleMapping;
        }
        return this.defaultDelegate;
    }

    private void configureAttchedSourcesAndJavadoc(IMavenProjectFacade facade, Properties sourceAttachment, ClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        for (IClasspathEntryDescriptor desc : classpath.getEntryDescriptors()) {
            String javaDocUrl;
            if (1 != desc.getEntryKind() || desc.getSourceAttachmentPath() != null) continue;
            ArtifactKey a = desc.getArtifactKey();
            String key = desc.getPath().toPortableString();
            IPath srcPath = desc.getSourceAttachmentPath();
            IPath srcRoot = desc.getSourceAttachmentRootPath();
            if (srcPath == null && sourceAttachment != null && sourceAttachment.containsKey(String.valueOf(key) + PROPERTY_SRC_PATH)) {
                srcPath = Path.fromPortableString((String)((String)sourceAttachment.get(String.valueOf(key) + PROPERTY_SRC_PATH)));
                if (sourceAttachment.containsKey(String.valueOf(key) + PROPERTY_SRC_ROOT)) {
                    srcRoot = Path.fromPortableString((String)((String)sourceAttachment.get(String.valueOf(key) + PROPERTY_SRC_ROOT)));
                }
            }
            if (srcPath == null && a != null) {
                srcPath = this.getSourcePath(a);
            }
            if ((javaDocUrl = desc.getJavadocUrl()) == null && sourceAttachment != null && sourceAttachment.containsKey(String.valueOf(key) + PROPERTY_JAVADOC_URL)) {
                javaDocUrl = (String)sourceAttachment.get(String.valueOf(key) + PROPERTY_JAVADOC_URL);
            }
            if (javaDocUrl == null && a != null) {
                javaDocUrl = this.getJavaDocUrl(a);
            }
            desc.setSourceAttachment(srcPath, srcRoot);
            desc.setJavadocUrl(javaDocUrl);
            ArtifactKey aKey = desc.getArtifactKey();
            if (aKey == null) continue;
            boolean downloadSources = desc.getSourceAttachmentPath() == null && srcPath == null && this.mavenConfiguration.isDownloadSources();
            boolean downloadJavaDoc = desc.getJavadocUrl() == null && javaDocUrl == null && this.mavenConfiguration.isDownloadJavaDoc();
            this.scheduleDownload(facade.getProject(), facade.getMavenProject(), aKey, downloadSources, downloadJavaDoc);
        }
    }

    private boolean isUnavailable(ArtifactKey a, List<ArtifactRepository> repositories) throws CoreException {
        return this.maven.isUnavailable(a.getGroupId(), a.getArtifactId(), a.getVersion(), "jar", a.getClassifier(), repositories);
    }

    public IClasspathEntry[] getClasspath(IProject project, int scope, IProgressMonitor monitor) throws CoreException {
        return this.getClasspath(project, scope, true, monitor);
    }

    @Override
    public IClasspathEntry[] getClasspath(IProject project, int scope, boolean uniquePaths, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = this.projectManager.create(project, monitor);
        if (facade == null) {
            return new IClasspathEntry[0];
        }
        try {
            Properties props = new Properties();
            File file = this.getSourceAttachmentPropertiesFile(project);
            if (file.canRead()) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                try {
                    props.load(is);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            return this.getClasspath(facade, scope, props, uniquePaths, monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, MavenJdtPlugin.PLUGIN_ID, -1, "Can't save classpath container changes", (Throwable)e));
        }
    }

    public IClasspathEntry[] getClasspath(IProject project, IProgressMonitor monitor) throws CoreException {
        return this.getClasspath(project, 0, monitor);
    }

    private Set<ArtifactKey> findArtifacts(IProject project, IPath path) throws CoreException {
        ArrayList<IClasspathEntry> entries = this.findClasspathEntries(project, path);
        LinkedHashSet<ArtifactKey> artifacts = new LinkedHashSet<ArtifactKey>();
        for (IClasspathEntry entry : entries) {
            ArtifactKey artifact = this.findArtifactByArtifactKey(entry);
            if (artifact == null) {
                artifact = this.findArtifactInIndex(project, entry);
                if (artifact == null) continue;
                artifacts.add(artifact);
                continue;
            }
            artifacts.add(artifact);
        }
        return artifacts;
    }

    public ArtifactKey findArtifact(IProject project, IPath path) throws CoreException {
        Set<ArtifactKey> artifacts;
        if (path != null && (artifacts = this.findArtifacts(project, path)).size() > 0) {
            return artifacts.iterator().next();
        }
        return null;
    }

    private ArtifactKey findArtifactByArtifactKey(IClasspathEntry entry) {
        IClasspathAttribute[] attributes = entry.getExtraAttributes();
        String groupId = null;
        String artifactId = null;
        String version = null;
        String classifier = null;
        int j = 0;
        while (j < attributes.length) {
            if ("maven.groupId".equals(attributes[j].getName())) {
                groupId = attributes[j].getValue();
            } else if ("maven.artifactId".equals(attributes[j].getName())) {
                artifactId = attributes[j].getValue();
            } else if ("maven.version".equals(attributes[j].getName())) {
                version = attributes[j].getValue();
            } else if ("maven.classifier".equals(attributes[j].getName())) {
                classifier = attributes[j].getValue();
            }
            ++j;
        }
        if (groupId != null && artifactId != null && version != null) {
            return new ArtifactKey(groupId, artifactId, version, classifier);
        }
        return null;
    }

    private ArtifactKey findArtifactInIndex(IProject project, IClasspathEntry entry) throws CoreException {
        IFile jarFile = project.getWorkspace().getRoot().getFile(entry.getPath());
        File file = jarFile == null || jarFile.getLocation() == null ? entry.getPath().toFile() : jarFile.getLocation().toFile();
        IndexedArtifactFile iaf = this.indexManager.getIndex(project).identify(file);
        if (iaf != null) {
            return new ArtifactKey(iaf.group, iaf.artifact, iaf.version, iaf.classifier);
        }
        return null;
    }

    private ArrayList<IClasspathEntry> findClasspathEntries(IProject project, IPath path) throws JavaModelException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        this.addEntries(entries, javaProject.getRawClasspath(), path);
        IClasspathContainer container = BuildPathManager.getMaven2ClasspathContainer(javaProject);
        if (container != null) {
            this.addEntries(entries, container.getClasspathEntries(), path);
        }
        return entries;
    }

    private void addEntries(Collection<IClasspathEntry> collection, IClasspathEntry[] entries, IPath path) {
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 1 && (path == null || path.equals((Object)entry.getPath()))) {
                collection.add(entry);
            }
            ++n2;
        }
    }

    public void persistAttachedSourcesAndJavadoc(IJavaProject project, IClasspathContainer containerSuggestion, IProgressMonitor monitor) throws CoreException {
        String path;
        IClasspathEntry entry;
        IFile pom = project.getProject().getFile("pom.xml");
        IMavenProjectFacade facade = this.projectManager.create(pom, false, null);
        if (facade == null) {
            return;
        }
        Properties props = new Properties();
        IClasspathEntry[] entries = containerSuggestion.getClasspathEntries();
        int i = 0;
        while (i < entries.length) {
            entry = entries[i];
            if (1 == entry.getEntryKind()) {
                String javadocUrl;
                path = entry.getPath().toPortableString();
                if (entry.getSourceAttachmentPath() != null) {
                    props.put(String.valueOf(path) + PROPERTY_SRC_PATH, entry.getSourceAttachmentPath().toPortableString());
                }
                if (entry.getSourceAttachmentRootPath() != null) {
                    props.put(String.valueOf(path) + PROPERTY_SRC_ROOT, entry.getSourceAttachmentRootPath().toPortableString());
                }
                if ((javadocUrl = this.getJavadocLocation(entry)) != null) {
                    props.put(String.valueOf(path) + PROPERTY_JAVADOC_URL, javadocUrl);
                }
            }
            ++i;
        }
        entries = this.getClasspath(facade, 0, null, true, monitor);
        i = 0;
        while (i < entries.length) {
            entry = entries[i];
            if (1 == entry.getEntryKind()) {
                path = entry.getPath().toPortableString();
                String value = (String)props.get(String.valueOf(path) + PROPERTY_SRC_PATH);
                if (value != null && entry.getSourceAttachmentPath() != null && value.equals(entry.getSourceAttachmentPath().toPortableString())) {
                    props.remove(String.valueOf(path) + PROPERTY_SRC_PATH);
                }
                if ((value = (String)props.get(String.valueOf(path) + PROPERTY_SRC_ROOT)) != null && entry.getSourceAttachmentRootPath() != null && value.equals(entry.getSourceAttachmentRootPath().toPortableString())) {
                    props.remove(String.valueOf(path) + PROPERTY_SRC_ROOT);
                }
            }
            ++i;
        }
        File file = this.getSourceAttachmentPropertiesFile(project.getProject());
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                props.store(os, null);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, MavenJdtPlugin.PLUGIN_ID, -1, "Can't save classpath container changes", (Throwable)e));
        }
        this.updateClasspath(project.getProject(), monitor);
    }

    public String getJavadocLocation(IClasspathEntry entry) {
        IClasspathAttribute[] attributes = entry.getExtraAttributes();
        int j = 0;
        while (j < attributes.length) {
            IClasspathAttribute attribute = attributes[j];
            if ("javadoc_location".equals(attribute.getName())) {
                return attribute.getValue();
            }
            ++j;
        }
        return null;
    }

    public File getSourceAttachmentPropertiesFile(IProject project) {
        return new File(this.stateLocationDir, String.valueOf(project.getName()) + ".sources");
    }

    public File getContainerStateFile(IProject project) {
        return new File(this.stateLocationDir, String.valueOf(project.getName()) + ".container");
    }

    public void resourceChanged(IResourceChangeEvent event) {
        int type = event.getType();
        if (4 == type) {
            File containerState;
            File attachmentProperties = this.getSourceAttachmentPropertiesFile((IProject)event.getResource());
            if (attachmentProperties.exists() && !attachmentProperties.delete()) {
                log.error("Can't delete " + attachmentProperties.getAbsolutePath());
            }
            if ((containerState = this.getContainerStateFile((IProject)event.getResource())).exists() && !containerState.delete()) {
                log.error("Can't delete " + containerState.getAbsolutePath());
            }
        }
    }

    public boolean setupVariables() {
        boolean changed = false;
        try {
            File localRepositoryDir = new File(this.maven.getLocalRepository().getBasedir());
            IPath oldPath = JavaCore.getClasspathVariable((String)M2_REPO);
            Path newPath = new Path(localRepositoryDir.getAbsolutePath());
            JavaCore.setClasspathVariable((String)M2_REPO, (IPath)newPath, (IProgressMonitor)new NullProgressMonitor());
            changed = !newPath.equals((Object)oldPath);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            changed = false;
        }
        return changed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean variablesAreInUse() {
        try {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject[] projects = model.getJavaProjects();
            int i = 0;
            block2: while (true) {
                if (i >= projects.length) {
                    return false;
                }
                IClasspathEntry[] entries = projects[i].getRawClasspath();
                int k = 0;
                while (true) {
                    String var;
                    if (k >= entries.length) {
                        ++i;
                        continue block2;
                    }
                    IClasspathEntry curr = entries[k];
                    if (curr.getEntryKind() == 4 && M2_REPO.equals(var = curr.getPath().segment(0))) {
                        return true;
                    }
                    ++k;
                }
                break;
            }
        }
        catch (JavaModelException javaModelException) {
            return true;
        }
    }

    static String getSourcesClassifier(String baseClassifier) {
        return CLASSIFIER_TESTS.equals(baseClassifier) ? CLASSIFIER_TESTSOURCES : CLASSIFIER_SOURCES;
    }

    private IPath getSourcePath(ArtifactKey a) {
        File file = this.getAttachedArtifactFile(a, BuildPathManager.getSourcesClassifier(a.getClassifier()));
        if (file != null) {
            return Path.fromOSString((String)file.getAbsolutePath());
        }
        return null;
    }

    private File getAttachedArtifactFile(ArtifactKey a, String classifier) {
        try {
            ArtifactRepository localRepository = this.maven.getLocalRepository();
            String relPath = this.maven.getArtifactPath(localRepository, a.getGroupId(), a.getArtifactId(), a.getVersion(), "jar", classifier);
            File file = new File(localRepository.getBasedir(), relPath).getCanonicalFile();
            if (file.canRead()) {
                return file;
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    private String getJavaDocUrl(ArtifactKey base) {
        File file = this.getAttachedArtifactFile(base, CLASSIFIER_JAVADOC);
        return BuildPathManager.getJavaDocUrl(file);
    }

    static String getJavaDocUrl(File file) {
        try {
            if (file != null) {
                URL fileUrl = file.toURL();
                return "jar:" + fileUrl.toExternalForm() + "!/" + BuildPathManager.getJavaDocPathInArchive(file);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    /*
     * Exception decompiling
     */
    private static String getJavaDocPathInArchive(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Job getDownloadSourcesJob() {
        return this.downloadSourcesJob;
    }

    @Override
    public void scheduleDownload(IPackageFragmentRoot fragment, boolean downloadSources, boolean downloadJavadoc) {
        ArtifactKey artifact = (ArtifactKey)fragment.getAdapter(ArtifactKey.class);
        if (artifact == null) {
            return;
        }
        IProject project = fragment.getJavaProject().getProject();
        try {
            if (project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                MavenProject mavenProject;
                IMavenProjectFacade facade = this.projectManager.getProject(project);
                MavenProject mavenProject2 = mavenProject = facade != null ? facade.getMavenProject() : null;
                if (mavenProject != null) {
                    this.scheduleDownload(project, mavenProject, artifact, downloadSources, downloadJavadoc);
                } else {
                    this.downloadSourcesJob.scheduleDownload(project, artifact, downloadSources, downloadJavadoc);
                }
            } else {
                List repositories = this.maven.getArtifactRepositories();
                ArtifactKey[] attached = this.getAttachedSourcesAndJavadoc(artifact, repositories, downloadSources, downloadJavadoc);
                if (attached[0] != null || attached[1] != null) {
                    this.downloadSourcesJob.scheduleDownload(fragment, artifact, downloadSources, downloadJavadoc);
                }
            }
        }
        catch (CoreException e) {
            log.error("Could not schedule sources/javadoc download", (Throwable)e);
        }
    }

    @Override
    public void scheduleDownload(IProject project, boolean downloadSources, boolean downloadJavadoc) {
        try {
            if (project != null && project.isAccessible() && project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                MavenProject mavenProject;
                IMavenProjectFacade facade = this.projectManager.getProject(project);
                MavenProject mavenProject2 = mavenProject = facade != null ? facade.getMavenProject() : null;
                if (mavenProject != null) {
                    for (Artifact artifact : mavenProject.getArtifacts()) {
                        ArtifactKey artifactKey = new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getClassifier());
                        this.scheduleDownload(project, mavenProject, artifactKey, downloadSources, downloadJavadoc);
                    }
                } else {
                    this.downloadSourcesJob.scheduleDownload(project, null, downloadSources, downloadJavadoc);
                }
            }
        }
        catch (CoreException e) {
            log.error("Could not schedule sources/javadoc download", (Throwable)e);
        }
    }

    private void scheduleDownload(IProject project, MavenProject mavenProject, ArtifactKey artifact, boolean downloadSources, boolean downloadJavadoc) throws CoreException {
        ArtifactKey[] attached = this.getAttachedSourcesAndJavadoc(artifact, mavenProject.getRemoteArtifactRepositories(), downloadSources, downloadJavadoc);
        if (attached[0] != null || attached[1] != null) {
            this.downloadSourcesJob.scheduleDownload(project, artifact, downloadSources, downloadJavadoc);
        }
    }

    ArtifactKey[] getAttachedSourcesAndJavadoc(ArtifactKey a, List<ArtifactRepository> repositories, boolean downloadSources, boolean downloadJavaDoc) throws CoreException {
        ArtifactKey sourcesArtifact = new ArtifactKey(a.getGroupId(), a.getArtifactId(), a.getVersion(), BuildPathManager.getSourcesClassifier(a.getClassifier()));
        ArtifactKey javadocArtifact = new ArtifactKey(a.getGroupId(), a.getArtifactId(), a.getVersion(), CLASSIFIER_JAVADOC);
        if (repositories != null) {
            downloadSources = downloadSources && !this.isUnavailable(sourcesArtifact, repositories);
            downloadJavaDoc = downloadJavaDoc && !this.isUnavailable(javadocArtifact, repositories);
        }
        ArtifactKey[] result = new ArtifactKey[2];
        if (downloadSources) {
            result[0] = sourcesArtifact;
        }
        if (downloadJavaDoc) {
            result[1] = javadocArtifact;
        }
        return result;
    }

    void attachSourcesAndJavadoc(IPackageFragmentRoot fragment, File sources, File javadoc, IProgressMonitor monitor) {
        IJavaProject javaProject = fragment.getJavaProject();
        IPath srcPath = sources != null ? Path.fromOSString((String)sources.getAbsolutePath()) : null;
        String javaDocUrl = BuildPathManager.getJavaDocUrl(javadoc);
        try {
            IClasspathEntry[] cp = javaProject.getRawClasspath();
            int i = 0;
            while (i < cp.length) {
                IClasspathEntry entry = cp[i];
                if (1 == entry.getEntryKind() && entry.equals(fragment.getRawClasspathEntry())) {
                    ArrayList<IClasspathAttribute> attributes = new ArrayList<IClasspathAttribute>(Arrays.asList(entry.getExtraAttributes()));
                    if (srcPath == null && javaDocUrl != null) {
                        attributes.add(JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javaDocUrl));
                    }
                    cp[i] = JavaCore.newLibraryEntry((IPath)entry.getPath(), (IPath)srcPath, null, (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])attributes.toArray(new IClasspathAttribute[attributes.size()]), (boolean)entry.isExported());
                    break;
                }
                ++i;
            }
            javaProject.setRawClasspath(cp, monitor);
        }
        catch (CoreException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

