/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.lock.LockResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanLocksOperation
extends AbstractActionOperation {
    protected IResource[] resources;
    protected int depth;
    protected Map<IResource, List<LockResource>> lockResources = new HashMap<IResource, List<LockResource>>();

    public ScanLocksOperation(IResource[] resources) {
        this(resources, 3);
    }

    public ScanLocksOperation(IResource[] resources, int depth) {
        super("Operation_ScanLocks", SVNUIMessages.class);
        this.resources = resources;
        this.depth = depth;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] shrinkedResources = FileUtility.shrinkChildNodes((IResource[])this.resources);
        int i = 0;
        while (i < shrinkedResources.length && !monitor.isCanceled()) {
            final IResource resource = shrinkedResources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    ArrayList<SVNChangeStatus> lockStatuses = new ArrayList<SVNChangeStatus>();
                    IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resource);
                    ISVNConnector proxy = location.acquireSVNProxy();
                    try {
                        SVNChangeStatus[] changeStatuses;
                        SVNChangeStatus[] sVNChangeStatusArray = changeStatuses = SVNUtility.status((ISVNConnector)proxy, (String)FileUtility.getWorkingCopyPath((IResource)resource), (int)ScanLocksOperation.this.depth, (long)64L, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)ScanLocksOperation.this, monitor, null));
                        int n = changeStatuses.length;
                        int n2 = 0;
                        while (n2 < n) {
                            SVNChangeStatus status = sVNChangeStatusArray[n2];
                            if (status.lockToken != null || status.reposLock != null) {
                                lockStatuses.add(status);
                            }
                            ++n2;
                        }
                    }
                    finally {
                        location.releaseSVNProxy(proxy);
                    }
                    if (!lockStatuses.isEmpty()) {
                        ArrayList<LockResource> lockResourcesList = new ArrayList<LockResource>();
                        ScanLocksOperation.this.lockResources.put(resource, lockResourcesList);
                        for (SVNChangeStatus status : lockStatuses) {
                            Path path = new Path(status.path);
                            String name = path.lastSegment();
                            LockResource lockResource = ScanLocksOperation.this.createLockFile(status, name);
                            lockResourcesList.add(lockResource);
                        }
                    }
                }
            }, monitor, shrinkedResources.length);
            ++i;
        }
    }

    public Map<IResource, List<LockResource>> getLockResourcesMap() {
        return this.lockResources;
    }

    public LockResource[] getLockResources() {
        ArrayList<LockResource> res = new ArrayList<LockResource>();
        for (List<LockResource> list : this.lockResources.values()) {
            res.addAll(list);
        }
        return res.toArray(new LockResource[0]);
    }

    protected LockResource createLockFile(SVNChangeStatus status, String resourceName) {
        LockResource.LockStatusEnum lockStatus = null;
        String owner = null;
        Date creationDate = null;
        String comment = null;
        if (status.lockToken != null && status.reposLock != null && status.lockOwner.equals(status.reposLock.owner) && status.lockToken.equals(status.reposLock.token)) {
            lockStatus = LockResource.LockStatusEnum.LOCALLY_LOCKED;
            owner = status.lockOwner;
            creationDate = new Date(status.lockCreationDate);
            comment = status.lockComment;
        } else if (status.lockToken == null && status.reposLock != null) {
            lockStatus = LockResource.LockStatusEnum.OTHER_LOCKED;
            owner = status.reposLock.owner;
            creationDate = new Date(status.reposLock.creationDate);
            comment = status.reposLock.comment;
        } else if (status.lockToken != null && status.reposLock == null) {
            lockStatus = LockResource.LockStatusEnum.BROKEN;
            owner = status.lockOwner;
            creationDate = new Date(status.lockCreationDate);
            comment = status.lockComment;
        } else if (status.lockToken != null && status.reposLock != null && !status.lockToken.equals(status.reposLock.token)) {
            lockStatus = LockResource.LockStatusEnum.STOLEN;
            owner = status.reposLock.owner;
            creationDate = new Date(status.reposLock.creationDate);
            comment = status.reposLock.comment;
        }
        return lockStatus != null ? new LockResource(resourceName, owner, true, lockStatus, creationDate, comment, status.path, status.url) : null;
    }

    public static class CreateLockResourcesHierarchyOperation
    extends AbstractActionOperation {
        protected ScanLocksOperation scanOp;
        protected LockResource lockResourceRoot;

        public CreateLockResourcesHierarchyOperation(ScanLocksOperation scanOp) {
            super("Operation_CreateLockResourcesHierarchy", SVNUIMessages.class);
            this.scanOp = scanOp;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            Map<IResource, List<LockResource>> lockResources = this.scanOp.getLockResourcesMap();
            if (!lockResources.isEmpty()) {
                Set<IResource> keys = lockResources.keySet();
                IResource resource = keys.iterator().next();
                List<LockResource> lockResourcesList = lockResources.get(resource);
                this.lockResourceRoot = this.mapChangeStatusesToLockResource(resource, lockResourcesList.toArray(new LockResource[0]));
                this.compressLockResources(this.lockResourceRoot);
            }
        }

        protected LockResource mapChangeStatusesToLockResource(IResource resource, LockResource[] resources) {
            String rootPath;
            if (resource.getType() == 1) {
                resource = resource.getParent();
            }
            if ((rootPath = resource.getFullPath().toString()).startsWith("/")) {
                rootPath = rootPath.substring(1);
            }
            LockResource root = LockResource.createDirectory(rootPath);
            String fullRootPath = FileUtility.getWorkingCopyPath((IResource)resource);
            LockResource[] lockResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                LockResource lockResource = lockResourceArray[n2];
                String path = lockResource.getFullFileSystemPath();
                if (path.startsWith(fullRootPath)) {
                    String relativePath = path.substring(fullRootPath.length());
                    if (relativePath.startsWith("/")) {
                        relativePath = relativePath.substring(1);
                    }
                    String[] subPaths = relativePath.split("/");
                    LockResource parent = root;
                    int i = 0;
                    while (i < subPaths.length) {
                        String subPath = subPaths[i];
                        LockResource child = parent.getChildByName(subPath);
                        if (child == null) {
                            child = i == subPaths.length - 1 ? lockResource : LockResource.createDirectory(subPath);
                            parent.addChild(child);
                        }
                        if (child != null) {
                            parent = child;
                        }
                        ++i;
                    }
                }
                ++n2;
            }
            return root;
        }

        protected void compressLockResources(LockResource resource) {
            LockResource[] children;
            if (resource.isFile()) {
                return;
            }
            LockResource[] lockResourceArray = children = resource.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                LockResource child = lockResourceArray[n2];
                if (!child.isFile()) {
                    this.compressLockResources(child);
                }
                ++n2;
            }
            if (!resource.isRoot() && children.length == 1 && !children[0].isFile()) {
                resource.setName(String.valueOf(resource.getName()) + "/" + children[0].getName());
                resource.removeChild(children[0]);
                resource.addChildren(children[0].getChildren());
            }
        }

        public LockResource getLockResourceRoot() {
            return this.lockResourceRoot;
        }
    }
}

