/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.view.property;

import java.util.StringTokenizer;
import org.eclipse.team.svn.ui.SVNUIMessages;

public class SVNKeywordProperty {
    public static final String[] DATE_NAMES = new String[]{"LastChangedDate", "Date"};
    public static final String[] REVISION_NAMES = new String[]{"LastChangedRevision", "Rev"};
    public static final String[] AUTHOR_NAMES = new String[]{"LastChangedBy", "Author"};
    public static final String[] HEAD_URL_NAMES = new String[]{"HeadURL", "URL"};
    public static final String[] ID_NAMES = new String[]{"Id"};
    public static final String DATE_SAMPLE = "$LastChangedDate: 2006-08-07 15:40:37 +0000 (Mon, 08 Aug 2006) $";
    public static final String REVISION_SAMPLE = "$LastChangedRevision: 7206 $";
    public static final String AUTHOR_SAMPLE = "$LastChangedBy: J.M.Wade $";
    public static final String HEAD_URL_SAMPLE = "$HeadURL: http://svn.eclipse.org/community/Subversive/src/ui/PropertyKeywordEditPanel.java $";
    public static final String ID_SAMPLE = "$Id: PropertyKeywordEditPanel.java 7206 2006-08-07 15:40:37 J.M.Wade $";
    protected boolean dateEnabled;
    protected boolean revisionEnabled;
    protected boolean lastChangedByEnabled;
    protected boolean headURLEnabled;
    protected boolean idEnabled;

    public static String DATE_DESCR() {
        return SVNUIMessages.SVNKeywordProperty_DATE_DESCR;
    }

    public static String REVISION_DESCR() {
        return SVNUIMessages.SVNKeywordProperty_REVISION_DESCR;
    }

    public static String AUTHOR_DESCR() {
        return SVNUIMessages.SVNKeywordProperty_AUTHOR_DESCR;
    }

    public static String HEAD_URL_DESCR() {
        return SVNUIMessages.SVNKeywordProperty_HEAD_URL_DESCR;
    }

    public static String ID_DESCR() {
        return SVNUIMessages.SVNKeywordProperty_ID_DESCR;
    }

    public SVNKeywordProperty(String keywordsValue) {
        if (keywordsValue != null) {
            this.parsePropertyValue(keywordsValue);
        }
    }

    public boolean isHeadUrlEnabled() {
        return this.headURLEnabled;
    }

    public boolean isIdEnabled() {
        return this.idEnabled;
    }

    public boolean isLastChangedByEnabled() {
        return this.lastChangedByEnabled;
    }

    public boolean isDateEnabled() {
        return this.dateEnabled;
    }

    public boolean isRevisionEnabled() {
        return this.revisionEnabled;
    }

    public void setHeadUrlEnabled(boolean headURL) {
        this.headURLEnabled = headURL;
    }

    public void setIdEnabled(boolean id) {
        this.idEnabled = id;
    }

    public void setLastChangedByEnabled(boolean lastChangedBy) {
        this.lastChangedByEnabled = lastChangedBy;
    }

    public void setDateEnabled(boolean lastChangedDate) {
        this.dateEnabled = lastChangedDate;
    }

    public void setRevisionEnabled(boolean lastChangedRev) {
        this.revisionEnabled = lastChangedRev;
    }

    public String toString() {
        String result = "";
        if (this.dateEnabled) {
            result = this.addKeyword(result, DATE_NAMES[0]);
        }
        if (this.revisionEnabled) {
            result = this.addKeyword(result, REVISION_NAMES[0]);
        }
        if (this.lastChangedByEnabled) {
            result = this.addKeyword(result, AUTHOR_NAMES[0]);
        }
        if (this.headURLEnabled) {
            result = this.addKeyword(result, HEAD_URL_NAMES[0]);
        }
        if (this.idEnabled) {
            result = this.addKeyword(result, ID_NAMES[0]);
        }
        return result;
    }

    protected String addKeyword(String result, String keyword) {
        if (result.trim().length() > 0) {
            result = String.valueOf(result) + ' ';
        }
        result = String.valueOf(result) + keyword;
        return result;
    }

    protected void parsePropertyValue(String keywordValue) {
        StringTokenizer st = new StringTokenizer(keywordValue, " ");
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            if (name.equals(DATE_NAMES[0]) || name.equals(DATE_NAMES[1])) {
                this.dateEnabled = true;
                continue;
            }
            if (name.equals(REVISION_NAMES[0]) || name.equals(REVISION_NAMES[1])) {
                this.revisionEnabled = true;
                continue;
            }
            if (name.equals(AUTHOR_NAMES[0]) || name.equals(AUTHOR_NAMES[1])) {
                this.lastChangedByEnabled = true;
                continue;
            }
            if (name.equals(HEAD_URL_NAMES[0]) || name.equals(HEAD_URL_NAMES[1])) {
                this.headURLEnabled = true;
                continue;
            }
            if (!name.equals(ID_NAMES[0])) continue;
            this.idEnabled = true;
        }
    }
}

