/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.compare.ThreeWayPropertyCompareInput;
import org.eclipse.team.svn.ui.synchronize.action.AbstractActionHelper;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ComparePropertiesActionHelper
extends AbstractActionHelper {
    public ComparePropertiesActionHelper(IAction action, ISynchronizePageConfiguration configuration) {
        super(action, configuration);
    }

    public IActionOperation getOperation() {
        SVNEntryRevisionReference baseReference;
        IResource resource = this.getSelectedResource();
        ILocalResource baseResource = SVNRemoteStorage.instance().asLocalResource(resource);
        IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(resource);
        SVNEntryRevisionReference remoteReference = baseReference = new SVNEntryRevisionReference(FileUtility.getWorkingCopyPath((IResource)resource), null, SVNRevision.BASE);
        ILocalResource change = this.getSelectedSVNSyncInfo().getRemoteChangeResource();
        if (change instanceof IResourceChange) {
            remote = ((IResourceChange)change).getOriginator();
            remoteReference = new SVNEntryRevisionReference(remote.getUrl(), remote.getPegRevision(), (SVNRevision)SVNRevision.fromNumber((long)((IResourceChange)change).getRevision()));
        }
        ThreeWayPropertyCompareInput input = new ThreeWayPropertyCompareInput(new CompareConfiguration(), resource, remoteReference, baseReference, remote.getRepositoryLocation(), baseResource.getRevision());
        CompareUI.openCompareEditor((CompareEditorInput)input);
        return null;
    }
}

