/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.update.action;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.ui.action.local.LockAction;
import org.eclipse.team.svn.ui.lock.LockResource;
import org.eclipse.team.svn.ui.lock.LocksComposite;
import org.eclipse.team.svn.ui.synchronize.action.AbstractActionHelper;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class LockActionHelper
extends AbstractActionHelper {
    public LockActionHelper(IAction action, ISynchronizePageConfiguration configuration) {
        super(action, configuration);
    }

    public FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                return super.select(info) && IStateFilter.SF_READY_TO_LOCK.accept(((AbstractSVNSyncInfo)info).getLocalResource());
            }
        };
    }

    public IActionOperation getOperation() {
        List<LockResource> lockResources = LockAction.getLockResources(this.getSyncInfoSelector().getSelectedResources());
        if (lockResources != null) {
            Iterator<LockResource> iter = lockResources.iterator();
            while (iter.hasNext()) {
                LockResource lockResource = iter.next();
                if (lockResource.getLockStatus() != LockResource.LockStatusEnum.LOCALLY_LOCKED) continue;
                iter.remove();
            }
            return LocksComposite.performLockAction(lockResources.toArray(new LockResource[0]), false, this.configuration.getSite().getShell());
        }
        return null;
    }
}

