/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html.buffer;

import java.util.ArrayList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.buffer.ContainerBufferNode;
import org.eclipse.birt.report.engine.layout.html.buffer.INode;
import org.eclipse.birt.report.engine.layout.html.buffer.IPageBuffer;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;
import org.eclipse.birt.report.engine.util.ContentUtil;
import org.w3c.dom.css.CSSValue;

public class TableBreakBuffer
implements IPageBuffer {
    IPageBuffer currentBuffer = null;
    IPageBuffer[] buffers = null;
    HTMLLayoutContext context;
    int nestCount = 0;
    int currentTableIndex = -1;
    int[] pageBreakIndexs;
    int currentIndex = 0;
    boolean hasRepeatedColumn = true;
    int repeatStart = 0;
    int repeatEnd = 0;
    boolean isRepeatStatus = false;
    boolean isRepeatCellContent = false;
    ArrayList<ContentEvent> repeatEvent = new ArrayList();
    ArrayList<ContentEvent> repeatCellContentEvent = new ArrayList();

    public TableBreakBuffer(IPageBuffer parentBuffer, HTMLLayoutContext context) {
        this.currentBuffer = parentBuffer != null ? parentBuffer : context.getBufferFactory().createBuffer();
        this.context = context;
    }

    public void startContainer(IContent content, boolean isFirst, IContentEmitter emitter, boolean visible) throws BirtException {
        switch (content.getContentType()) {
            case 10: {
                ++this.nestCount;
                if (this.buffers == null) {
                    ITableContent table = (ITableContent)content;
                    boolean hasPageBreak = this.hasPageBreak(table);
                    if (hasPageBreak) {
                        if (this.currentTableIndex >= 0) break;
                        INode[] nodeList = this.currentBuffer.getNodeStack();
                        this.pageBreakIndexs = this.getPageBreakIndex(table);
                        this.repeatEnd = this.getRepeatEnd(table);
                        this.currentBuffer.startContainer(this.createTable(table, this.pageBreakIndexs, 0), isFirst, emitter, visible);
                        this.currentTableIndex = this.nestCount;
                        this.buffers = new IPageBuffer[this.pageBreakIndexs.length];
                        this.buffers[0] = this.currentBuffer;
                        String tableId = table.getInstanceID().toUniqueString();
                        this.currentBuffer.addTableColumnHint(new TableColumnHint(tableId, 0, this.pageBreakIndexs[0] + 1));
                        int i = 1;
                        while (i < this.pageBreakIndexs.length) {
                            this.buffers[i] = new TableBreakBuffer(null, this.context);
                            INode[] list = new INode[nodeList.length + 1];
                            ITableContent newTable = this.createTable(table, this.pageBreakIndexs, i);
                            list[0] = new ContainerBufferNode(newTable, emitter, null, true);
                            int j = 0;
                            while (j < nodeList.length) {
                                list[j + 1] = nodeList[j];
                                ++j;
                            }
                            this.buffers[i].openPage(list);
                            if (this.hasRepeatedColumn && this.repeatEnd > this.repeatStart) {
                                this.buffers[i].addTableColumnHint(new TableColumnHint(tableId, this.repeatStart, this.repeatEnd - this.repeatStart));
                            }
                            this.buffers[i].addTableColumnHint(new TableColumnHint(tableId, this.pageBreakIndexs[i - 1] + 1, this.pageBreakIndexs[i] - this.pageBreakIndexs[i - 1]));
                            ++i;
                        }
                        break;
                    }
                    this.currentBuffer.startContainer(content, isFirst, emitter, visible);
                    break;
                }
                this.currentBuffer.startContainer(content, isFirst, emitter, visible);
                break;
            }
            case 8: 
            case 9: 
            case 17: {
                if (this.currentTableIndex == this.nestCount && this.currentTableIndex > 0) {
                    this.currentIndex = 0;
                    this.currentBuffer = this.buffers[0];
                    this.startContainerInPages(content, isFirst, emitter, visible);
                    if (!this.hasRepeatedColumn) break;
                    this.repeatEvent.clear();
                    break;
                }
                this.currentBuffer.startContainer(content, isFirst, emitter, visible);
                break;
            }
            case 1: {
                if (this.currentTableIndex == this.nestCount && this.currentTableIndex > 0) {
                    int col;
                    int colSpan;
                    int index;
                    if (this.hasRepeatedColumn && this.isRepeatedCell((ICellContent)content)) {
                        this.isRepeatStatus = true;
                    }
                    if ((index = this.getStartPageIndex((ICellContent)content)) != this.currentIndex) {
                        int i = this.currentIndex + 1;
                        while (i <= index) {
                            this.currentBuffer = this.buffers[i];
                            this.repeatCells(emitter);
                            ++i;
                        }
                        this.currentIndex = index;
                    }
                    this.currentBuffer = this.buffers[this.currentIndex];
                    if (this.isRepeatCellContent && this.currentIndex >= 1) {
                        ICellContent cc = (ICellContent)content;
                        int start = cc.getColumn();
                        if (start > this.pageBreakIndexs[this.currentIndex - 1] + 1) {
                            this.repeatCellContent(emitter);
                        }
                        this.repeatCellContentEvent.clear();
                        this.isRepeatCellContent = false;
                    }
                    if (((ICellContent)content).repeatContent() && (colSpan = ((ICellContent)content).getColSpan()) > 1 && (col = ((ICellContent)content).getColumn()) + colSpan > this.pageBreakIndexs[this.currentIndex] + 1) {
                        this.isRepeatCellContent = true;
                    }
                }
                this.currentBuffer.startContainer(content, isFirst, emitter, visible);
                break;
            }
            default: {
                this.currentBuffer.startContainer(content, isFirst, emitter, visible);
            }
        }
        if (this.isRepeatStatus) {
            this.repeatEvent.add(new ContentEvent(content, visible, 0));
        }
        if (this.isRepeatCellContent) {
            this.repeatCellContentEvent.add(new ContentEvent(content, visible, 0));
        }
    }

    protected void repeatCellContent(IContentEmitter emitter) throws BirtException {
        int size = this.repeatCellContentEvent.size();
        if (size > 0) {
            ContentEvent last = this.repeatCellContentEvent.get(size - 1);
            last.isFirst = false;
            for (ContentEvent child : this.repeatCellContentEvent) {
                this.visitEvent(child, emitter);
            }
        }
    }

    protected void repeatCells(IContentEmitter emitter) throws BirtException {
        int size = this.repeatEvent.size();
        if (size > 1) {
            ContentEvent last = this.repeatEvent.get(size - 1);
            last.isFirst = false;
            for (ContentEvent child : this.repeatEvent) {
                this.visitEvent(child, emitter);
            }
        }
    }

    void visitEvent(ContentEvent event, IContentEmitter emitter) throws BirtException {
        switch (event.eventType) {
            case 2: {
                this.currentBuffer.startContent(event.content, emitter, event.visible);
                break;
            }
            case 0: {
                this.currentBuffer.startContainer(event.content, event.isFirst, emitter, event.visible);
                break;
            }
            case 1: {
                this.currentBuffer.endContainer(event.content, event.isFirst, emitter, event.visible);
            }
        }
    }

    protected void startContainerInPages(IContent content, boolean isFirst, IContentEmitter emitter, boolean visible) throws BirtException {
        this.buffers[0].startContainer(content, isFirst, emitter, visible);
        int i = 1;
        while (i < this.buffers.length) {
            this.buffers[i].startContainer(content, false, emitter, visible);
            ++i;
        }
    }

    public void startContent(IContent content, IContentEmitter emitter, boolean visible) throws BirtException {
        this.currentBuffer.startContent(content, emitter, visible);
        if (this.isRepeatStatus) {
            this.repeatEvent.add(new ContentEvent(content, visible, 2));
        }
        if (this.isRepeatCellContent) {
            this.repeatCellContentEvent.add(new ContentEvent(content, visible, 2));
        }
    }

    public void endContainer(IContent content, boolean finished, IContentEmitter emitter, boolean visible) throws BirtException {
        switch (content.getContentType()) {
            case 10: {
                INode[] nodeList = this.currentBuffer.getNodeStack();
                --this.nestCount;
                if (this.currentTableIndex == this.nestCount + 1 && this.currentTableIndex > 0) {
                    assert (this.buffers != null);
                    int i = 0;
                    while (i < this.buffers.length - 1) {
                        this.buffers[i].closePage(nodeList);
                        this.buffers[i] = null;
                        ++i;
                    }
                    this.buffers[this.buffers.length - 1].endContainer(content, finished, emitter, visible);
                    this.context.getBufferFactory().refresh();
                    this.currentBuffer = this.buffers[this.buffers.length - 1];
                    this.currentTableIndex = -1;
                    break;
                }
                this.currentBuffer.endContainer(content, finished, emitter, visible);
                break;
            }
            case 8: 
            case 9: 
            case 17: {
                if (this.currentTableIndex == this.nestCount && this.currentTableIndex > 0) {
                    if (this.pageBreakIndexs.length - 1 != this.currentIndex) {
                        int i = this.currentIndex + 1;
                        while (i < this.pageBreakIndexs.length) {
                            this.currentIndex = i;
                            this.currentBuffer = this.buffers[this.currentIndex];
                            this.repeatCells(emitter);
                            if (this.isRepeatCellContent) {
                                this.repeatCellContent(emitter);
                            }
                            ++i;
                        }
                        this.repeatEvent.clear();
                        if (this.isRepeatCellContent) {
                            this.isRepeatCellContent = false;
                            this.repeatCellContentEvent.clear();
                        }
                    }
                    this.endContainerInPages(content, finished, emitter, visible);
                    break;
                }
                this.currentBuffer.endContainer(content, finished, emitter, visible);
                break;
            }
            case 1: {
                if (this.currentTableIndex == this.nestCount && this.currentTableIndex > 0) {
                    int pageIndex = this.getEndPageIndex((ICellContent)content);
                    if (pageIndex > this.currentIndex) {
                        this.currentBuffer.endContainer(content, finished, emitter, visible);
                        if (pageIndex > this.currentIndex + 1) {
                            if (this.isRepeatCellContent) {
                                this.repeatCellContentEvent.add(new ContentEvent(content, visible, 1));
                            }
                            int i = this.currentIndex + 1;
                            while (i < pageIndex) {
                                this.currentBuffer = this.buffers[i];
                                this.repeatCells(emitter);
                                if (this.isRepeatCellContent) {
                                    this.repeatCellContent(emitter);
                                }
                                ++i;
                            }
                            if (this.isRepeatCellContent) {
                                this.repeatCellContentEvent.remove(this.repeatCellContentEvent.size() - 1);
                            }
                        }
                        pageIndex = pageIndex == this.pageBreakIndexs.length ? pageIndex - 1 : pageIndex;
                        this.currentBuffer = this.buffers[pageIndex];
                    } else {
                        this.currentBuffer.endContainer(content, finished, emitter, visible);
                    }
                    if (!this.isRepeatStatus) break;
                    this.repeatEvent.add(new ContentEvent(content, visible, 1));
                    this.isRepeatStatus = false;
                    break;
                }
                this.currentBuffer.endContainer(content, finished, emitter, visible);
                break;
            }
            case 7: {
                this.currentBuffer.endContainer(content, finished, emitter, visible);
                this.context.getBufferFactory().refresh();
                break;
            }
            default: {
                this.currentBuffer.endContainer(content, finished, emitter, visible);
            }
        }
        if (this.isRepeatStatus) {
            this.repeatEvent.add(new ContentEvent(content, visible, 1));
        }
        if (this.isRepeatCellContent) {
            this.repeatCellContentEvent.add(new ContentEvent(content, visible, 1));
        }
    }

    protected void endContainerInPages(IContent content, boolean finished, IContentEmitter emitter, boolean visible) throws BirtException {
        if (this.currentTableIndex == this.nestCount && this.currentTableIndex > 0) {
            int i = 0;
            while (i < this.buffers.length - 1) {
                this.buffers[i].endContainer(content, false, emitter, visible);
                ++i;
            }
            this.buffers[this.buffers.length - 1].endContainer(content, finished, emitter, visible);
        } else {
            this.currentBuffer.endContainer(content, finished, emitter, visible);
        }
    }

    public void flush() throws BirtException {
        int i = 0;
        while (i < this.buffers.length) {
            this.buffers[i].flush();
            ++i;
        }
    }

    public boolean isRepeated() {
        if (this.currentBuffer != null) {
            return this.currentBuffer.isRepeated();
        }
        if (this.buffers != null) {
            return this.buffers[0].isRepeated();
        }
        return false;
    }

    public void setRepeated(boolean isRepeated) {
        if (this.currentBuffer != null) {
            this.currentBuffer.setRepeated(isRepeated);
        }
        if (this.buffers != null) {
            int i = 0;
            while (i < this.buffers.length) {
                this.buffers[i].setRepeated(isRepeated);
                ++i;
            }
        }
    }

    protected boolean hasPageBreak(ITableContent table) {
        return this.context.allowPageBreak() && ContentUtil.hasHorzPageBreak(table);
    }

    protected int getRepeatEnd(ITableContent table) {
        int count = table.getColumnCount();
        int i = 0;
        while (i < count) {
            IColumn column = table.getColumn(i);
            if (!column.isRepeated()) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected int[] getPageBreakIndex(ITableContent table) {
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        int count = table.getColumnCount();
        int i = 0;
        while (i < count) {
            IColumn column = table.getColumn(i);
            IStyle style = column.getStyle();
            CSSValue pageBreak = style.getProperty(47);
            if (i > 0 && IStyle.ALWAYS_VALUE == pageBreak && !indexs.contains(i - 1)) {
                indexs.add(i - 1);
            }
            pageBreak = style.getProperty(58);
            if (i < count - 1 && IStyle.ALWAYS_VALUE == pageBreak && !indexs.contains(i)) {
                indexs.add(i);
            }
            ++i;
        }
        if (!indexs.contains(count - 1)) {
            indexs.add(count - 1);
        }
        int[] values = new int[indexs.size()];
        int i2 = 0;
        while (i2 < indexs.size()) {
            values[i2] = (Integer)indexs.get(i2);
            ++i2;
        }
        return values;
    }

    public boolean isRepeatedCell(ICellContent cell) {
        int start = cell.getColumn();
        int end = start + cell.getColSpan();
        return start < this.repeatEnd && end > this.repeatStart;
    }

    public int getStartPageIndex(ICellContent cell) {
        int current;
        int start = cell.getColumn();
        if (start > this.pageBreakIndexs[current = this.currentIndex]) {
            while (start > this.pageBreakIndexs[current]) {
                if (++current != this.pageBreakIndexs.length) continue;
                current = 0;
                break;
            }
        }
        return current;
    }

    public int getEndPageIndex(ICellContent cell) {
        int current = this.currentIndex;
        int end = cell.getColumn() + cell.getColSpan();
        if (end > this.pageBreakIndexs[current]) {
            while (this.pageBreakIndexs[current] < end) {
                if (++current != this.pageBreakIndexs.length) continue;
                current = this.pageBreakIndexs.length;
                break;
            }
            return current;
        }
        return current;
    }

    public boolean finished() {
        return this.currentBuffer.finished();
    }

    public void closePage(INode[] nodeList) throws BirtException {
        this.currentBuffer.closePage(nodeList);
        --this.nestCount;
    }

    public void openPage(INode[] nodeList) throws BirtException {
        this.currentBuffer.openPage(nodeList);
        ++this.nestCount;
    }

    public INode[] getNodeStack() {
        return this.currentBuffer.getNodeStack();
    }

    protected ITableContent createTable(ITableContent table, int[] pageBreakIndex, int index) {
        return table;
    }

    public void addTableColumnHint(TableColumnHint hint) {
        if (this.currentBuffer != null) {
            this.currentBuffer.addTableColumnHint(hint);
        }
    }

    public static class ContentEvent {
        public static final int START_CONTAINER_EVENT = 0;
        public static final int END_CONTAINER_EVENT = 1;
        public static final int START_LEAF_EVENT = 2;
        IContent content;
        int eventType;
        boolean visible;
        boolean isFirst = true;

        public ContentEvent(IContent content, boolean visible, int eventType) {
            this.content = content;
            this.visible = visible;
            this.eventType = eventType;
        }
    }
}

