/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.core.template.TemplateParser;
import org.eclipse.birt.core.template.TextTemplate;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.api.CachedImage;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.ImageSize;
import org.eclipse.birt.report.engine.api.impl.Image;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.data.dte.SingleCubeResultSet;
import org.eclipse.birt.report.engine.data.dte.SingleQueryResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.template.TemplateExecutor;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemPresentation;
import org.eclipse.birt.report.engine.extension.Size;
import org.eclipse.birt.report.engine.extension.internal.ReportItemPresentationInfo;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.script.internal.OnRenderScriptVisitor;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.w3c.dom.css.CSSValue;

public class LocalizedContentVisitor {
    protected static Logger logger = Logger.getLogger(LocalizedContentVisitor.class.getName());
    private ExecutionContext context;
    private Locale locale;
    private String outputFormat;
    protected HashMap templates = new HashMap();
    private OnRenderScriptVisitor onRenderVisitor;
    static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public LocalizedContentVisitor(ExecutionContext context) {
        this.context = context;
        this.locale = context.getLocale();
        this.outputFormat = context.getOutputFormat();
        this.onRenderVisitor = new OnRenderScriptVisitor(context);
    }

    IReportContent getReportContent() {
        return this.context.getReportContent();
    }

    ModuleHandle getReportDesign() {
        return this.context.getDesign();
    }

    protected void processBackgroundImage(IStyle style) {
        URL url;
        if (style == null) {
            return;
        }
        String image = style.getBackgroundImage();
        if (image == null) {
            return;
        }
        ModuleHandle reportDesign = this.context.getDesign();
        if (reportDesign != null && (url = reportDesign.findResource(image, 1, this.context.getAppContext())) != null) {
            style.setBackgroundImage(url.toExternalForm());
        }
    }

    public IContent localize(IContent content) throws BirtException {
        IStyle style = content.getInlineStyle();
        this.processBackgroundImage(style);
        switch (content.getContentType()) {
            case 1: {
                return this.localizeCell((ICellContent)content);
            }
            case 3: {
                return this.localizeData((IDataContent)content);
            }
            case 4: {
                return this.localizeForeign((IForeignContent)content);
            }
            case 5: {
                return this.localizeImage((IImageContent)content);
            }
            case 6: {
                return this.localizeLabel((ILabelContent)content);
            }
            case 7: {
                return this.localizePage((IPageContent)content);
            }
            case 8: {
                return this.localizeRow((IRowContent)content);
            }
            case 10: {
                return this.localizeTable((ITableContent)content);
            }
            case 11: {
                return this.localizeText((ITextContent)content);
            }
            case 12: {
                return this.localizeAutoText((IAutoTextContent)content);
            }
            case 13: {
                return this.localizeList((IListContent)content);
            }
            case 15: 
            case 16: 
            case 17: {
                return this.localizeGroup((IGroupContent)content);
            }
        }
        return content;
    }

    public IReportContent localizeReport(IReportContent report) throws BirtException {
        this.processReport(report);
        return report;
    }

    protected IContent localizeAllChildren(IContent content) throws BirtException {
        ArrayList children = (ArrayList)content.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.size()) {
                IContent child = (IContent)children.get(i);
                this.localize(child);
                this.localizeAllChildren(child);
                ++i;
            }
        }
        return content;
    }

    private IPageContent localizePage(IPageContent page) throws BirtException {
        boolean isExecutingMasterPage = this.context.isExecutingMasterPage();
        this.context.setExecutingMasterPage(true);
        this.localizeAllChildren(page);
        this.context.setExecutingMasterPage(isExecutingMasterPage);
        return page;
    }

    protected TextTemplate parseTemplate(String text) throws BirtException {
        SoftReference<TextTemplate> templateRef = (SoftReference<TextTemplate>)this.templates.get(text);
        TextTemplate template = null;
        if (templateRef != null && (template = (TextTemplate)templateRef.get()) != null) {
            return template;
        }
        try {
            template = new TemplateParser().parse(text);
            templateRef = new SoftReference<TextTemplate>(template);
            this.templates.put(text, templateRef);
        }
        catch (Throwable ex) {
            throw new EngineException(ex.getLocalizedMessage(), ex);
        }
        return template;
    }

    private String executeTemplate(TextTemplate template, HashMap values) {
        return new TemplateExecutor(this.context).execute(template, values);
    }

    private IListContent localizeList(IListContent list) {
        this.handleOnRender(list);
        return list;
    }

    private ITableContent localizeTable(ITableContent table) {
        this.handleOnRender(table);
        String captionText = table.getCaption();
        String captionKey = table.getCaptionKey();
        captionText = this.localize(table, captionKey, captionText);
        table.setCaption(captionText);
        return table;
    }

    private IRowContent localizeRow(IRowContent row) {
        this.handleOnRender(row);
        return row;
    }

    private ICellContent localizeCell(ICellContent cell) {
        this.handleOnRender(cell);
        return cell;
    }

    private IDataContent localizeData(IDataContent data) {
        this.handleOnRender(data);
        this.processData(data);
        return data;
    }

    protected void processData(IDataContent data) {
        String helpText = this.localize(data, data.getHelpKey(), data.getHelpText());
        data.setHelpText(helpText);
        String text = "";
        if (data.getLabelKey() != null || data.getLabelText() != null) {
            text = this.localize(data, data.getLabelKey(), data.getLabelText());
        } else {
            CSSValue align;
            Object value = data.getValue();
            IStyle style = data.getComputedStyle();
            text = this.format(value, style);
            if (value instanceof Number && (align = style.getProperty(11)) != null && align != CSSValueConstants.NONE_VALUE) {
                data.getStyle().setProperty(24, align);
            }
        }
        data.setText(text == null ? "" : text);
    }

    protected String format(Object value, IStyle style) {
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object v = objectArray[n2];
                sb.append(this.format(v, style));
                sb.append(", ");
                ++n2;
            }
            if (sb.length() > 1) {
                sb.setLength(sb.length() - 2);
            }
            sb.append(']');
            return sb.toString();
        }
        if (value == null) {
            return null;
        }
        DataFormatValue dataFormat = style.getDataFormat();
        String pattern = null;
        String locale = null;
        if (value instanceof Number) {
            if (dataFormat != null) {
                pattern = dataFormat.getNumberPattern();
                locale = dataFormat.getNumberLocale();
            }
            NumberFormatter fmt = this.context.getNumberFormatter(pattern, locale);
            return fmt.format((Number)value);
        }
        if (value instanceof String) {
            if (dataFormat != null) {
                pattern = dataFormat.getStringPattern();
                locale = dataFormat.getStringLocale();
            }
            StringFormatter fmt = this.context.getStringFormatter(pattern, locale);
            return fmt.format((String)value);
        }
        if (value instanceof java.util.Date) {
            if (dataFormat != null) {
                if (value instanceof Date) {
                    pattern = dataFormat.getDatePattern();
                    locale = dataFormat.getDateLocale();
                } else if (value instanceof Time) {
                    pattern = dataFormat.getTimePattern();
                    locale = dataFormat.getTimeLocale();
                }
                if (pattern == null && locale == null) {
                    pattern = dataFormat.getDateTimePattern();
                    locale = dataFormat.getDateTimeLocale();
                }
            }
            DateFormatter fmt = this.context.getDateFormatter(pattern, locale);
            return fmt.format((java.util.Date)value);
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            int length = bytes.length <= 8 ? bytes.length : 8;
            StringBuffer buffer = new StringBuffer();
            int index = 0;
            while (index < length) {
                byte byteValue = bytes[index];
                int lowValue = byteValue & 0xF;
                int highValue = byteValue >> 4 & 0xF;
                buffer.append(HEX[highValue]).append(HEX[lowValue]).append(' ');
                ++index;
            }
            if (length > 0) {
                if (length != bytes.length) {
                    buffer.append("...");
                } else {
                    buffer.setLength(buffer.length() - 1);
                }
            }
            return buffer.toString();
        }
        return value.toString();
    }

    private ILabelContent localizeLabel(ILabelContent label) {
        this.handleOnRender(label);
        this.processLabel(label);
        return label;
    }

    protected void processLabel(ILabelContent label) {
        String helpText = this.localize(label, label.getHelpKey(), label.getHelpText());
        label.setHelpText(helpText);
        if (label.getText() == null) {
            String text = this.localize(label, label.getLabelKey(), label.getLabelText());
            label.setText(text);
        }
    }

    protected void processReport(IReportContent report) {
        if (report.getDesign() != null) {
            ReportDesignHandle handle = report.getDesign().getReportDesign();
            String title = this.localize(report, handle.getTitleKey(), handle.getTitle());
            report.setTitle(title);
        }
    }

    private ITextContent localizeText(ITextContent text) {
        this.handleOnRender(text);
        return text;
    }

    private IAutoTextContent localizeAutoText(IAutoTextContent autoText) {
        int type = autoText.getType();
        IStyle style = autoText.getComputedStyle();
        if (type == 1) {
            long number = this.context.getFilteredPageNumber();
            String text = this.format(number, style);
            autoText.setText(text == null ? "" : text);
        } else if (type == 0) {
            long totalPage = this.context.getFilteredTotalPage();
            if (totalPage <= 0L) {
                autoText.setText("---");
            } else {
                String text = this.format(totalPage, style);
                autoText.setText(text == null ? "" : text);
            }
        } else if (type == 3) {
            long number = this.context.getPageNumber();
            String text = this.format(number, style);
            autoText.setText(text == null ? "" : text);
        } else if (type == 2) {
            long totalPage = this.context.getTotalPage();
            if (totalPage <= 0L) {
                autoText.setText("---");
            } else {
                String text = this.format(totalPage, style);
                autoText.setText(text == null ? "" : text);
            }
        } else if (type == 4) {
            AutoTextItemDesign design = (AutoTextItemDesign)autoText.getGenerateBy();
            AutoTextHandle designHandle = (AutoTextHandle)design.getHandle();
            String varName = designHandle.getPageVariable();
            Object result = this.context.getPageVariable(varName);
            String text = this.format(result, style);
            autoText.setText(text == null ? "" : text);
        }
        this.handleOnRender(autoText);
        return autoText;
    }

    private IContent localizeForeign(IForeignContent foreignContent) {
        IReportContent reportContent = this.getReportContent();
        this.handleOnRender(foreignContent);
        String rawFormat = foreignContent.getRawType();
        Object rawValue = foreignContent.getRawValue();
        if ("text/template".equals(rawFormat)) {
            this.processTemplateContent(foreignContent);
            return foreignContent;
        }
        if ("object/external".equals(rawFormat)) {
            return this.processExtendedContent(foreignContent);
        }
        if ("binary/image".equals(rawFormat)) {
            if (rawValue instanceof IImageContent) {
                IImageContent image = (IImageContent)rawValue;
                this.processImage(image);
                return image;
            }
            if (rawValue instanceof byte[]) {
                IImageContent imageContent = reportContent.createImageContent(foreignContent);
                imageContent.setImageSource(2);
                imageContent.setData((byte[])rawValue);
                this.processImage(imageContent);
                return imageContent;
            }
        }
        if ("text/plaintext".equals(rawFormat)) {
            IDataContent textContent = reportContent.createDataContent(foreignContent);
            textContent.setText(rawValue == null ? "" : rawValue.toString());
            return textContent;
        }
        if ("text/html".equals(rawFormat)) {
            String key = foreignContent.getRawKey();
            if (key != null) {
                String text = this.localize(foreignContent, key, null);
                if (text != null) {
                    foreignContent.setRawValue(text);
                }
            } else {
                Object value = foreignContent.getRawValue();
                String text = this.format(value, foreignContent.getComputedStyle());
                if (text != null) {
                    foreignContent.setRawValue(text);
                }
            }
            return foreignContent;
        }
        if ("binary/value".equals(rawFormat)) {
            IDataContent dataContent = reportContent.createDataContent(foreignContent);
            dataContent.setParent(foreignContent.getParent());
            dataContent.setValue(rawValue);
            this.processData(dataContent);
            return dataContent;
        }
        return foreignContent;
    }

    private String localize(IContent content, String key, String text) {
        assert (content != null);
        if (content.getGenerateBy() != null) {
            String t;
            DesignElementHandle element = ((ReportItemDesign)content.getGenerateBy()).getHandle();
            if (key != null && element != null && (t = ModuleUtil.getExternalizedValue((DesignElementHandle)element, (String)key, (String)text, (ULocale)ULocale.forLocale((Locale)this.locale))) != null) {
                return t;
            }
        }
        return text;
    }

    private String localize(IReportContent content, String key, String text) {
        assert (content != null);
        if (content.getDesign() != null) {
            String t;
            ReportDesignHandle element = content.getDesign().getReportDesign();
            if (key != null && element != null && (t = ModuleUtil.getExternalizedValue((DesignElementHandle)element, (String)key, (String)text, (ULocale)ULocale.forLocale((Locale)this.locale))) != null) {
                return t;
            }
        }
        return text;
    }

    private IImageContent localizeImage(IImageContent image) {
        String appBaseUrl;
        IRenderOption option;
        String uri;
        this.handleOnRender(image);
        if (image.getImageSource() == 0) {
            String strUri = image.getURI();
            ModuleHandle reportDesign = this.context.getDesign();
            URL uri2 = reportDesign.findResource(strUri, 1, this.context.getAppContext());
            if (uri2 != null) {
                image.setURI(uri2.toExternalForm());
            }
        } else if (image.getImageSource() == 3 && !(uri = image.getURI()).contains(":/") && (option = this.context.getRenderOption()) != null && (appBaseUrl = option.getAppBaseURL()) != null) {
            if (appBaseUrl.endsWith("/")) {
                image.setURI(String.valueOf(appBaseUrl) + uri);
            } else {
                image.setURI(String.valueOf(appBaseUrl) + "/" + uri);
            }
        }
        this.processImage(image);
        return image;
    }

    protected void processImage(IImageContent image) {
        String altText = this.localize(image, image.getAltTextKey(), image.getAltText());
        image.setAltText(altText);
        String helpText = this.localize(image, image.getHelpKey(), image.getHelpText());
        image.setHelpText(helpText);
    }

    protected void processTemplateContent(IForeignContent foreignContent) {
        assert ("text/template".equals(foreignContent.getRawType()));
        if (foreignContent.getGenerateBy() instanceof TextItemDesign) {
            TextItemDesign design = (TextItemDesign)foreignContent.getGenerateBy();
            String text = null;
            HashMap rawValues = null;
            if (foreignContent.getRawValue() instanceof Object[]) {
                Object[] rawValue = (Object[])foreignContent.getRawValue();
                assert (rawValue.length == 2);
                assert (rawValue[0] == null || rawValue[0] instanceof String);
                if (rawValue[0] != null) {
                    text = (String)rawValue[0];
                }
                if (rawValue[1] instanceof HashMap) {
                    rawValues = (HashMap)rawValue[1];
                }
            }
            if (text == null) {
                String textKey = design.getTextKey();
                String textContent = design.getText();
                text = this.localize(foreignContent, textKey, textContent);
            }
            try {
                TextTemplate template = this.parseTemplate(text);
                String result = this.executeTemplate(template, rawValues);
                foreignContent.setRawType("text/html");
                foreignContent.setRawValue(result);
            }
            catch (BirtException ex) {
                this.context.addException(design, ex);
            }
        }
    }

    private IGroupContent localizeGroup(IGroupContent group) {
        this.handleOnRender(group);
        return group;
    }

    protected String getOutputFormat() {
        return this.outputFormat;
    }

    private int getChartResolution(IContent content) {
        Object tmp;
        Map appContext;
        int resolution = 0;
        Object chartDpi = this.context.getRenderOption().getOption("ChartDpi");
        if (chartDpi != null && chartDpi instanceof Number) {
            resolution = ((Number)chartDpi).intValue();
        }
        if (resolution == 0 && (appContext = this.context.getAppContext()) != null && (tmp = appContext.get("CHART_RESOLUTION")) != null && tmp instanceof Number) {
            resolution = ((Number)tmp).intValue();
        }
        if (resolution < 96) {
            Object renderOptionDpi = this.context.getRenderOption().getOption("RenderDpi");
            int dpi = 0;
            if (renderOptionDpi != null && renderOptionDpi instanceof Integer) {
                dpi = (Integer)renderOptionDpi;
            }
            resolution = PropertyUtil.getRenderDpi(content, dpi);
        }
        return resolution;
    }

    private String getChartFormats() {
        IRenderOption renderOption = this.context.getRenderOption();
        String formats = renderOption.getSupportedImageFormats();
        if (formats != null) {
            return formats;
        }
        return "PNG;GIF;JPG;BMP;";
    }

    private String getImageCacheID(IContent content) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(content.getInstanceID().toUniqueString());
        buffer.append(this.getChartResolution(content));
        buffer.append(this.getChartFormats());
        buffer.append(this.locale);
        return buffer.toString();
    }

    private ImageSize processImageSize(Size size) {
        if (size == null) {
            return null;
        }
        return new ImageSize(size.getUnit(), size.getWidth(), size.getHeight());
    }

    private IContent processCachedImage(IForeignContent content, CachedImage cachedImage) {
        IImageContent imageObj = this.getReportContent().createImageContent(content);
        imageObj.setParent(content.getParent());
        imageObj.setImageSource(0);
        imageObj.setURI(cachedImage.getURL());
        imageObj.setMIMEType(cachedImage.getMIMEType());
        imageObj.setImageMap(cachedImage.getImageMap());
        imageObj.setAltText(content.getAltText());
        imageObj.setAltTextKey(content.getAltTextKey());
        ImageSize size = cachedImage.getImageSize();
        if (size != null) {
            DimensionType height = new DimensionType(size.getHeight(), size.getUnit());
            DimensionType width = new DimensionType(size.getWidth(), size.getUnit());
            imageObj.setHeight(height);
            imageObj.setWidth(width);
        }
        this.processImage(imageObj);
        return imageObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IContent processExtendedContent(IForeignContent content) {
        String imageId;
        CachedImage cachedImage;
        IHTMLImageHandler imageHandler;
        assert ("object/external".equals(content.getRawType()));
        assert (content.getGenerateBy() instanceof ExtendedItemDesign);
        IContent generatedContent = content;
        ExtendedItemDesign design = (ExtendedItemDesign)content.getGenerateBy();
        ExtendedItemHandle handle = (ExtendedItemHandle)design.getHandle();
        String tagName = handle.getExtensionName();
        if ("Chart".equals(tagName) && (imageHandler = this.context.getImageHandler()) != null && (cachedImage = imageHandler.getCachedImage(imageId = this.getImageCacheID(content), 4, this.context.getReportContext())) != null) {
            return this.processCachedImage(content, cachedImage);
        }
        IReportItemPresentation itemPresentation = this.context.getExtendedItemManager().createPresentation(handle);
        int resolution = 0;
        if (itemPresentation != null) {
            DesignElementHandle elementHandle;
            IDataQueryDefinition[] queries = design.getQueries();
            ReportItemPresentationInfo info = new ReportItemPresentationInfo();
            info.setModelObject(handle);
            info.setApplicationClassLoader(this.context.getApplicationClassLoader());
            info.setReportContext(this.context.getReportContext());
            info.setReportQueries(queries);
            resolution = this.getChartResolution(content);
            info.setResolution(resolution);
            info.setExtendedItemContent(content);
            info.setSupportedImageFormats(this.getChartFormats());
            info.setActionHandler(this.context.getActionHandler());
            info.setOutputFormat(this.getOutputFormat());
            itemPresentation.init(info);
            Object rawValue = content.getRawValue();
            if (rawValue instanceof byte[]) {
                byte[] values = (byte[])rawValue;
                itemPresentation.deserialize(new ByteArrayInputStream(values));
            }
            if (queries == null && (elementHandle = design.getHandle()) instanceof ReportElementHandle) {
                queries = (IBaseQueryDefinition[])this.context.getReport().getQueryByReportHandle((ReportElementHandle)elementHandle);
            }
            IBaseResultSet[] rsets = this.context.getResultSets();
            IBaseResultSet[] resultSets = null;
            if (queries == null) {
                if (rsets != null) {
                    resultSets = new IBaseResultSet[1];
                    int type = rsets[0].getType();
                    if (type == 0) {
                        resultSets[0] = new SingleQueryResultSet((IQueryResultSet)rsets[0]);
                    } else {
                        if (1 != type) throw new UnsupportedOperationException("Unknown type of result set is found: " + rsets[0].getClass().getName());
                        resultSets[0] = new SingleCubeResultSet((ICubeResultSet)rsets[0]);
                    }
                }
            } else {
                resultSets = rsets;
            }
            try {
                Object output = itemPresentation.onRowSets(resultSets);
                int type = itemPresentation.getOutputType();
                String imageMIMEType = itemPresentation.getImageMIMEType();
                Size size = itemPresentation.getSize();
                if (output != null) {
                    generatedContent = this.processExtendedContent(content, type, output, imageMIMEType, size);
                }
                if (size != null) {
                    DimensionType height = new DimensionType(size.getHeight(), size.getUnit());
                    DimensionType width = new DimensionType(size.getWidth(), size.getUnit());
                    generatedContent.setHeight(height);
                    generatedContent.setWidth(width);
                }
                itemPresentation.finish();
            }
            catch (BirtException ex) {
                this.context.addException(design.getHandle(), ex);
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (!(generatedContent instanceof IImageContent)) return generatedContent;
        IImageContent imageContent = (IImageContent)generatedContent;
        imageContent.setResolution(resolution);
        return generatedContent;
    }

    protected IContent processExtendedContent(IForeignContent content, int type, Object output, String imageMIMEType, Size size) {
        assert ("object/external".equals(content.getRawType()));
        assert (output != null);
        IReportContent reportContent = this.getReportContent();
        switch (type) {
            case 0: {
                break;
            }
            case 1: 
            case 6: {
                Object imageMap = null;
                byte[] imageContent = new byte[]{};
                Object image = output;
                if (type == 6) {
                    Object[] imageWithMap = (Object[])output;
                    if (imageWithMap.length > 0) {
                        image = imageWithMap[0];
                    }
                    if (imageWithMap.length > 1) {
                        imageMap = imageWithMap[1];
                    }
                }
                if (image instanceof InputStream) {
                    imageContent = LocalizedContentVisitor.readContent((InputStream)image);
                } else if (output instanceof byte[]) {
                    imageContent = (byte[])image;
                } else {
                    assert (false);
                    logger.log(Level.WARNING, "unsupported image type:{0}", imageMIMEType != null ? imageMIMEType : "Unknown");
                }
                IImageContent imageObj = reportContent.createImageContent(content);
                imageObj.setParent(content.getParent());
                imageObj.setImageSource(2);
                imageObj.setData(imageContent);
                imageObj.setImageMap(imageMap);
                imageObj.setMIMEType(imageMIMEType);
                imageObj.setAltText(content.getAltText());
                imageObj.setAltTextKey(content.getAltTextKey());
                IHTMLImageHandler imageHandler = this.context.getImageHandler();
                if (imageHandler != null) {
                    Image img = new Image(imageObj);
                    img.setRenderOption(this.context.getRenderOption());
                    img.setReportRunnable(this.context.getRunnable());
                    img.setImageSize(this.processImageSize(size));
                    String imageId = this.getImageCacheID(content);
                    CachedImage cachedImage = imageHandler.addCachedImage(imageId, 4, img, this.context.getReportContext());
                    if (cachedImage != null) {
                        return this.processCachedImage(content, cachedImage);
                    }
                }
                this.processImage(imageObj);
                return imageObj;
            }
            case 5: {
                IDataContent dataObj = reportContent.createDataContent(content);
                dataObj.setValue(output);
                this.processData(dataObj);
                return dataObj;
            }
            case 3: {
                content.setRawType("text/html");
                content.setRawValue(output.toString());
                return content;
            }
            case 2: {
                ITextContent textObj = reportContent.createTextContent();
                textObj.setText(output.toString());
                return textObj;
            }
            case 7: {
                content.setRawValue(output);
                return content;
            }
            default: {
                assert (false);
                logger.log(Level.WARNING, "unsupported output format:{0}", type);
            }
        }
        return content;
    }

    protected static byte[] readContent(InputStream in) {
        BufferedInputStream bin = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int readSize = 0;
        try {
            readSize = bin.read(buffer);
            while (readSize != -1) {
                out.write(buffer, 0, readSize);
                readSize = bin.read(buffer);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return out.toByteArray();
    }

    protected void handleOnRender(IContent content) {
        Object genBy = content.getGenerateBy();
        if (genBy instanceof ReportItemDesign) {
            ReportItemDesign design = (ReportItemDesign)genBy;
            Expression onRender = design.getOnRender();
            String javaEventHandler = design.getJavaClass();
            if ((onRender != null || javaEventHandler != null || design instanceof ExtendedItemDesign) && this.context.getEngineTask().getTaskType() != 1) {
                this.onRenderVisitor.onRender(content);
            }
        }
    }
}

