/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RevertOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileReplaceListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        try {
            final ArrayList<IFile> added = new ArrayList<IFile>();
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getResource().getType() == 1 && delta.getKind() == 1) {
                        added.add((IFile)delta.getResource());
                    }
                    return true;
                }
            });
            if (!added.isEmpty()) {
                this.processResources(added);
            }
        }
        catch (CoreException e) {
            LoggedOperation.reportError(this.getClass().getName(), e);
        }
    }

    protected void processResources(List<IFile> addedFiles) {
        final ArrayList<ILocalResource> localResources = new ArrayList<ILocalResource>();
        final ArrayList<IResource> resources = new ArrayList<IResource>();
        for (IResource iResource : addedFiles) {
            ILocalResource localParent;
            IContainer parent;
            ILocalResource local = SVNRemoteStorage.instance().asLocalResource(iResource);
            if (!IStateFilter.SF_DELETED.accept(local) || (parent = local.getResource().getParent()) == null || IStateFilter.SF_DELETED.accept(localParent = SVNRemoteStorage.instance().asLocalResource((IResource)parent))) continue;
            localResources.add(local);
            resources.add(local.getResource());
        }
        if (!localResources.isEmpty()) {
            AbstractActionOperation abstractActionOperation = new AbstractActionOperation("Operation_FileReplaceListener", SVNMessages.class){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    for (ILocalResource local : localResources) {
                        File fileWithOriginalContent;
                        File tmpFile;
                        File originalFile;
                        boolean hasError;
                        block22: {
                            if (monitor.isCanceled()) {
                                return;
                            }
                            hasError = true;
                            originalFile = new File(FileUtility.getWorkingCopyPath(local.getResource()));
                            tmpFile = new File(originalFile + ".svntmp");
                            fileWithOriginalContent = originalFile;
                            try {
                                try {
                                    if (tmpFile.exists()) {
                                        tmpFile.delete();
                                    }
                                    if (originalFile.renameTo(tmpFile)) {
                                        fileWithOriginalContent = tmpFile;
                                        RevertOperation revertOp = new RevertOperation(new IResource[]{local.getResource()}, false);
                                        ProgressMonitorUtility.doTask(revertOp, monitor, 100, 60);
                                        if (revertOp.getExecutionState() == 0) {
                                            if (!originalFile.delete()) {
                                                throw new Exception("Failed to delete file: " + originalFile);
                                            }
                                            if (!tmpFile.renameTo(originalFile)) {
                                                throw new Exception("Failed to rename file: " + originalFile);
                                            }
                                            fileWithOriginalContent = originalFile;
                                            hasError = false;
                                        } else {
                                            this.reportStatus(revertOp.getStatus());
                                        }
                                        break block22;
                                    }
                                    throw new Exception("Failed to rename file: " + originalFile.getAbsolutePath());
                                }
                                catch (Throwable t) {
                                    this.reportStatus(4, null, t);
                                    if (!hasError) continue;
                                    if (fileWithOriginalContent.equals(tmpFile)) {
                                        if (originalFile.exists()) {
                                            originalFile.delete();
                                        }
                                        if (!tmpFile.renameTo(originalFile)) continue;
                                        tmpFile.delete();
                                        continue;
                                    }
                                    if (!fileWithOriginalContent.equals(originalFile) || !tmpFile.exists()) continue;
                                    tmpFile.delete();
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                if (hasError) {
                                    if (fileWithOriginalContent.equals(tmpFile)) {
                                        if (originalFile.exists()) {
                                            originalFile.delete();
                                        }
                                        if (tmpFile.renameTo(originalFile)) {
                                            tmpFile.delete();
                                        }
                                    } else if (fileWithOriginalContent.equals(originalFile) && tmpFile.exists()) {
                                        tmpFile.delete();
                                    }
                                }
                                throw throwable;
                            }
                        }
                        if (!hasError) continue;
                        if (fileWithOriginalContent.equals(tmpFile)) {
                            if (originalFile.exists()) {
                                originalFile.delete();
                            }
                            if (!tmpFile.renameTo(originalFile)) continue;
                            tmpFile.delete();
                            continue;
                        }
                        if (!fileWithOriginalContent.equals(originalFile) || !tmpFile.exists()) continue;
                        tmpFile.delete();
                    }
                }

                public ISchedulingRule getSchedulingRule() {
                    HashSet<IResource> ruleSet = new HashSet<IResource>();
                    ruleSet.addAll(resources);
                    for (IResource resource : resources) {
                        ruleSet.add((IResource)(resource instanceof IProject ? resource : resource.getParent()));
                    }
                    return new MultiRule((ISchedulingRule[])ruleSet.toArray(new IResource[ruleSet.size()]));
                }
            };
            CompositeOperation cmpOp = new CompositeOperation(abstractActionOperation.getId(), abstractActionOperation.getMessagesClass());
            cmpOp.add(abstractActionOperation);
            cmpOp.add(new RefreshResourcesOperation(resources.toArray(new IResource[0])));
            ProgressMonitorUtility.doTaskScheduledDefault(cmpOp);
        }
    }
}

