/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.svn.core.IProjectSetHandler;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.remote.CheckoutAsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SubclipseProjectSetHandler
implements IProjectSetHandler {
    protected static final String PLUGIN_INFORMATION = "0.9.3";

    public String getProjectNameForReference(String fullReference) {
        String[] parts = fullReference.split(",");
        if (parts.length < 3 || !parts[0].equals(PLUGIN_INFORMATION)) {
            return null;
        }
        return parts[2];
    }

    public IProject configureCheckoutOperation(CompositeOperation op, IProject project, String fullReference) throws TeamException {
        String[] parts = fullReference.split(",");
        IRepositoryLocation location = this.getLocationForReference(parts);
        IRepositoryContainer resource = location.asRepositoryContainer(parts[1], true);
        if (resource != null) {
            String projectLocation = project.exists() ? FileUtility.getResourcePath((IResource)project).removeLastSegments(1).toString() : Platform.getLocation().toString();
            CheckoutAsOperation mainOp = new CheckoutAsOperation(project.getName(), resource, projectLocation, 3, false);
            op.add(mainOp);
            return mainOp.getProject();
        }
        return null;
    }

    protected IRepositoryLocation getLocationForReference(String[] parts) {
        IRepositoryLocation location = null;
        String url = parts[1];
        IRepositoryLocation[] locations = SVNRemoteStorage.instance().getRepositoryLocations();
        IPath awaitingFor = SVNUtility.createPathForSVNUrl(url);
        int i = 0;
        while (i < locations.length) {
            if (SVNUtility.createPathForSVNUrl(locations[i].getUrl()).isPrefixOf(awaitingFor)) {
                return locations[i];
            }
            ++i;
        }
        location = SVNRemoteStorage.instance().newRepositoryLocation();
        location.setUrl(url);
        SVNRemoteStorage.instance().addRepositoryLocation(location);
        return location;
    }

    public String asReference(IProject project) throws TeamException {
        throw new RuntimeException("Unsupported operation");
    }

    public boolean accept(String referenceString) {
        return referenceString.startsWith(PLUGIN_INFORMATION);
    }
}

