/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;

public class SVNRevision {
    public static final SVNRevision HEAD = new SVNRevision(7);
    public static final SVNRevision START = new SVNRevision(0);
    public static final SVNRevision COMMITTED = new SVNRevision(3);
    public static final SVNRevision PREVIOUS = new SVNRevision(4);
    public static final SVNRevision BASE = new SVNRevision(5);
    public static final SVNRevision WORKING = new SVNRevision(6);
    public static final int INVALID_REVISION_NUMBER = -1;
    public static final Number INVALID_REVISION = new Number(-1L);
    protected int revKind;

    public static SVNRevision fromKind(int kind) {
        switch (kind) {
            case 5: {
                return BASE;
            }
            case 6: {
                return WORKING;
            }
            case 7: {
                return HEAD;
            }
            case 4: {
                return PREVIOUS;
            }
            case 0: {
                return START;
            }
            case 3: {
                return COMMITTED;
            }
            case 2: {
                throw new IllegalArgumentException("Use fromDate() method instead");
            }
            case 1: {
                throw new IllegalArgumentException("Use fromNumber() method instead");
            }
        }
        throw new IllegalArgumentException("Invalid revision kind: " + kind);
    }

    public static Number fromNumber(long revisionNumber) {
        if (revisionNumber < 0L) {
            throw new IllegalArgumentException("Negative revision numbers are not allowed: " + revisionNumber);
        }
        return new Number(revisionNumber);
    }

    public static Date fromDate(long revisionDate) {
        if (revisionDate == -1L) {
            throw new IllegalArgumentException("A date must be specified");
        }
        return new Date(revisionDate);
    }

    public static SVNRevision fromString(String revisionString) {
        if ("BASE".equals(revisionString = revisionString.toUpperCase())) {
            return BASE;
        }
        if ("WORKING".equals(revisionString)) {
            return WORKING;
        }
        if ("COMMITTED".equals(revisionString)) {
            return COMMITTED;
        }
        if ("HEAD".equals(revisionString)) {
            return HEAD;
        }
        if ("PREVIOUS".equals(revisionString)) {
            return PREVIOUS;
        }
        try {
            return SVNRevision.fromNumber(Long.parseLong(revisionString));
        }
        catch (NumberFormatException numberFormatException) {
            DateFormat dateTimeFormat = DateFormat.getDateTimeInstance((int)2, (int)2, (ULocale)ULocale.getDefault());
            try {
                return SVNRevision.fromDate(dateTimeFormat.parse(revisionString).getTime());
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("Invalid revision string: " + revisionString);
            }
        }
    }

    public int getKind() {
        return this.revKind;
    }

    public String toString() {
        switch (this.revKind) {
            case 5: {
                return "BASE";
            }
            case 3: {
                return "COMMITTED";
            }
            case 7: {
                return "HEAD";
            }
            case 4: {
                return "PREV";
            }
            case 6: {
                return "WORKING";
            }
        }
        return "UNSPECIFIED";
    }

    public int hashCode() {
        return this.revKind;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!this.getClass().equals(target.getClass())) {
            return false;
        }
        return ((SVNRevision)target).revKind == this.revKind;
    }

    protected SVNRevision(int kind) {
        this.revKind = kind;
    }

    public static class Date
    extends SVNRevision {
        protected long revDate;

        public long getDate() {
            return this.revDate;
        }

        public String toString() {
            DateFormat dateTimeFormat = DateFormat.getDateTimeInstance((int)2, (int)2, (ULocale)ULocale.getDefault());
            return dateTimeFormat.format(new java.util.Date(this.revDate));
        }

        public int hashCode() {
            int result = 31;
            result += this.revKind;
            result = 31 * result + (int)this.revDate;
            result = 31 * result + (int)(this.revDate >> 32);
            return result;
        }

        public boolean equals(Object target) {
            return super.equals(target) && ((Date)target).revDate == this.revDate;
        }

        protected Date(long date) {
            super(2);
            this.revDate = date;
        }
    }

    public static final class Kind {
        public static final int START = 0;
        public static final int NUMBER = 1;
        public static final int DATE = 2;
        public static final int COMMITTED = 3;
        public static final int PREVIOUS = 4;
        public static final int BASE = 5;
        public static final int WORKING = 6;
        public static final int HEAD = 7;
    }

    public static class Number
    extends SVNRevision {
        protected long revNumber;

        public long getNumber() {
            return this.revNumber;
        }

        public String toString() {
            return String.valueOf(this.revNumber);
        }

        public int hashCode() {
            int result = 31;
            result += this.revKind;
            result = 31 * result + (int)this.revNumber;
            result = 31 * result + (int)(this.revNumber >> 32);
            return result;
        }

        public boolean equals(Object target) {
            return super.equals(target) && ((Number)target).revNumber == this.revNumber;
        }

        protected Number(long number) {
            super(1);
            this.revNumber = number;
        }
    }
}

