/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNConnectorCancelException;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.ActivityCancelledException;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IConsoleStream;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractActionOperation
implements IActionOperation {
    private final MultiStatus status = new MultiStatus("org.eclipse.team.svn.core.svnnature", 0, "", null);
    protected String nameId;
    protected String name;
    protected boolean isExecuted = false;
    protected IConsoleStream consoleStream;
    protected Class<? extends NLS> messagesClass;

    public AbstractActionOperation(String operationName, Class<? extends NLS> messagesClass) {
        this.messagesClass = messagesClass;
        this.setOperationName(operationName);
        this.updateStatusMessage();
    }

    @Override
    public int getOperationWeight() {
        return 1;
    }

    @Override
    public IConsoleStream getConsoleStream() {
        return this.consoleStream;
    }

    @Override
    public void setConsoleStream(IConsoleStream stream) {
        this.consoleStream = stream;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return null;
    }

    @Override
    public int getExecutionState() {
        if (this.status.isOK()) {
            return this.isExecuted ? 0 : 2;
        }
        return 1;
    }

    @Override
    public final IActionOperation run(IProgressMonitor monitor) {
        try {
            try {
                this.updateStatusMessage();
                this.isExecuted = true;
                if (this.consoleStream != null) {
                    this.consoleStream.markStart(this.name);
                }
                this.runImpl(monitor);
                if (monitor.isCanceled()) {
                    boolean hasCanceledException = false;
                    IStatus[] children = this.status.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        Throwable exception = children[i].getException();
                        if (exception instanceof SVNConnectorCancelException || exception instanceof ActivityCancelledException) {
                            hasCanceledException = true;
                            break;
                        }
                        ++i;
                    }
                    if (!hasCanceledException) {
                        throw new ActivityCancelledException();
                    }
                }
            }
            catch (Throwable t) {
                this.reportStatus(4, null, t);
                if (this.consoleStream != null) {
                    this.consoleStream.markEnd();
                }
            }
        }
        finally {
            if (this.consoleStream != null) {
                this.consoleStream.markEnd();
            }
        }
        return this;
    }

    public void setOperationName(String name) {
        this.nameId = name;
        this.name = this.getNationalizedString(name);
    }

    @Override
    public String getOperationName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.nameId;
    }

    @Override
    public Class<? extends NLS> getMessagesClass() {
        return this.messagesClass;
    }

    protected abstract void runImpl(IProgressMonitor var1) throws Exception;

    protected void writeCancelledToConsole() {
        if (this.consoleStream != null) {
            this.consoleStream.markCancelled();
        }
    }

    protected void writeToConsole(int severity, String data) {
        if (this.consoleStream != null) {
            this.consoleStream.write(severity, data);
        }
    }

    protected void complexWriteToConsole(Runnable runnable) {
        if (this.consoleStream != null) {
            this.consoleStream.doComplexWrite(runnable);
        }
    }

    protected void protectStep(IUnprotectedOperation step, IProgressMonitor monitor, int subTaskCnt) {
        this.protectStep(step, monitor, 1 * subTaskCnt, 1);
    }

    protected void protectStep(IUnprotectedOperation step, IProgressMonitor monitor, int totalWeight, int currentWeight) {
        try {
            ProgressMonitorUtility.doSubTask(this, step, monitor, totalWeight, currentWeight);
        }
        catch (Throwable t) {
            this.reportStatus(4, null, t);
        }
    }

    protected void reportWarning(String message, Throwable t) {
        this.reportStatus(2, message, t);
    }

    protected void reportError(Throwable t) {
        this.reportStatus(4, null, t);
    }

    @Override
    public void reportStatus(int severity, String message, Throwable t) {
        String msg;
        String string = msg = message != null ? message : this.getShortErrorMessage(t);
        if (severity == 4) {
            if (t instanceof SVNConnectorCancelException || t instanceof ActivityCancelledException) {
                this.writeCancelledToConsole();
            } else {
                this.writeToConsole(3, String.valueOf(msg) + "\n");
            }
        } else if (severity == 2) {
            this.writeToConsole(2, String.valueOf(message) + "\n");
        }
        this.reportStatus((IStatus)new Status(severity, "org.eclipse.team.svn.core.svnnature", 0, msg, t));
    }

    protected String getShortErrorMessage(Throwable t) {
        String key = String.valueOf(this.nameId) + "_Error";
        String retVal = this.getNationalizedString(key);
        if (retVal.equals(key)) {
            return String.valueOf(this.status.getMessage()) + ": " + (t == null ? "<null>" : t.getMessage());
        }
        return retVal;
    }

    protected void reportStatus(IStatus st) {
        if (st.getSeverity() != 0) {
            this.status.merge(st);
        }
    }

    protected String getOperationResource(String key) {
        return this.getNationalizedString(String.valueOf(this.nameId) + "_" + key);
    }

    protected final String getNationalizedString(String key) {
        String retVal = BaseMessages.getErrorString(key, this.messagesClass);
        if (retVal.equals(key)) {
            return CoreExtensionsManager.instance().getOptionProvider().getResource(key);
        }
        return retVal;
    }

    private void updateStatusMessage() {
        String key = String.valueOf(this.nameId) + "_Id";
        String prefix = this.getNationalizedString(key);
        prefix = prefix.equals(key) ? "" : String.valueOf(prefix) + ": ";
        String errMessage = SVNMessages.format(SVNMessages.Operation_Error_LogHeader, new String[]{String.valueOf(prefix) + this.name});
        this.status.setMessage(errMessage);
    }

    private static class MultiStatus
    extends org.eclipse.core.runtime.MultiStatus {
        public MultiStatus(String pluginId, int code, IStatus[] newChildren, String message, Throwable exception) {
            super(pluginId, code, newChildren, message, exception);
        }

        public MultiStatus(String pluginId, int code, String message, Throwable exception) {
            super(pluginId, code, message, exception);
        }

        public void setMessage(String message) {
            super.setMessage(message);
        }

        public void merge(IStatus status) {
            super.merge(status);
            if (status.getSeverity() != 0) {
                this.setSeverity(this.getSeverity() | status.getSeverity());
            }
        }
    }
}

