/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file.refactor;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.operation.file.refactor.DeleteOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class MoveOperation
extends AbstractFileOperation {
    protected File localTo;
    protected boolean forceNonSVN;

    public MoveOperation(File[] files, File localTo, boolean forceNonSVN) {
        super("Operation_MoveFile", SVNMessages.class, files);
        this.localTo = localTo;
        this.forceNonSVN = forceNonSVN;
    }

    public MoveOperation(IFileProvider provider, File localTo, boolean forceNonSVN) {
        super("Operation_MoveFile", SVNMessages.class, provider);
        this.localTo = localTo;
        this.forceNonSVN = forceNonSVN;
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule parentRule = super.getSchedulingRule();
        return MultiRule.combine((ISchedulingRule)new AbstractFileOperation.LockingRule(this.localTo), (ISchedulingRule)parentRule);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        FileUtility.reorder(files, false);
        IRepositoryResource remoteTo = SVNFileStorage.instance().asRepositoryResource(this.localTo, true);
        IRepositoryLocation location = remoteTo == null ? null : remoteTo.getRepositoryLocation();
        final ISVNConnector proxy = location == null ? null : location.acquireSVNProxy();
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            final File current = files[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(current, true);
                    File checked = MoveOperation.this.getRenameTo(current);
                    if (remote == null) {
                        MoveOperation.this.nonSVNMove(checked, current, monitor);
                    } else if (proxy == null || MoveOperation.this.forceNonSVN) {
                        MoveOperation.this.nonSVNCopy(current, monitor);
                        ProgressMonitorUtility.doTaskExternal(new DeleteOperation(new File[]{current}), monitor);
                    } else {
                        proxy.move(new String[]{current.getAbsolutePath()}, checked.getAbsolutePath(), 4L, new SVNProgressMonitor(MoveOperation.this, monitor, null));
                    }
                }
            }, monitor, files.length);
            ++i;
        }
        if (location != null) {
            location.releaseSVNProxy(proxy);
        }
    }

    protected File getRenameTo(File what) {
        File checked = new File(String.valueOf(this.localTo.getAbsolutePath()) + "/" + what.getName());
        if (checked.exists()) {
            String message = this.getNationalizedString("Error_AlreadyExists");
            throw new UnreportableException(BaseMessages.format(message, new Object[]{checked.getAbsolutePath()}));
        }
        return checked;
    }

    protected void nonSVNMove(File renameTo, File what, IProgressMonitor monitor) throws Exception {
        if (!what.renameTo(renameTo)) {
            this.nonSVNCopy(what, monitor);
            FileUtility.deleteRecursive(what, monitor);
        }
    }

    protected void nonSVNCopy(File what, IProgressMonitor monitor) throws Exception {
        FileUtility.copyAll(this.localTo, what, 0, new FileFilter(){

            public boolean accept(File pathname) {
                return !pathname.getName().equals(SVNUtility.getSVNFolderName());
            }
        }, monitor);
    }
}

