/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.change;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.svn.core.operation.local.change.IActionOperationProcessor;
import org.eclipse.team.svn.core.operation.local.change.IResourceChangeVisitor;
import org.eclipse.team.svn.core.operation.local.change.ResourceChange;
import org.eclipse.team.svn.core.resource.ILocalFolder;
import org.eclipse.team.svn.core.resource.ILocalResource;

public class FolderChange
extends ResourceChange {
    protected ResourceChange[] children;

    public FolderChange(ResourceChange parent, ILocalFolder local, boolean needsTemporary) throws Exception {
        super(parent, local, needsTemporary);
        if (needsTemporary) {
            this.tmp.mkdir();
        }
        ILocalResource[] tmpChildren = local.getChildren();
        this.children = new ResourceChange[tmpChildren.length];
        try {
            int i = 0;
            while (i < tmpChildren.length) {
                this.children[i] = ResourceChange.wrapLocalResource(this, tmpChildren[i], needsTemporary);
                ++i;
            }
        }
        catch (Exception ex) {
            this.disposeChangeModel((IProgressMonitor)new NullProgressMonitor());
            throw ex;
        }
    }

    public ResourceChange[] getChildren() {
        return this.children;
    }

    protected void preTraverse(IResourceChangeVisitor visitor, int depth, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
        if (depth != 0) {
            int nextDepth = depth == 1 ? 0 : 2;
            int i = 0;
            while (i < this.children.length && !monitor.isCanceled()) {
                this.children[i].preTraverse(visitor, nextDepth, processor, monitor);
                ++i;
            }
        }
        visitor.preVisit(this, processor, monitor);
    }

    protected void postTraverse(IResourceChangeVisitor visitor, int depth, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
        visitor.postVisit(this, processor, monitor);
        if (depth != 0) {
            int nextDepth = depth == 1 ? 0 : 2;
            int i = 0;
            while (i < this.children.length && !monitor.isCanceled()) {
                this.children[i].postTraverse(visitor, nextDepth, processor, monitor);
                ++i;
            }
        }
    }
}

