/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.svnstorage;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRevisionLink;
import org.eclipse.team.svn.core.resource.ISVNStorage;
import org.eclipse.team.svn.core.resource.SSHSettings;
import org.eclipse.team.svn.core.resource.SSLSettings;
import org.eclipse.team.svn.core.svnstorage.SVNCachedProxyCredentialsManager;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.events.IRepositoriesStateChangedListener;
import org.eclipse.team.svn.core.svnstorage.events.IRevisionPropertyChangeListener;
import org.eclipse.team.svn.core.svnstorage.events.RepositoriesStateChangedEvent;
import org.eclipse.team.svn.core.svnstorage.events.RevisonPropertyChangeEvent;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractSVNStorage
implements ISVNStorage {
    private static final String SVN_SECURE_NAME_SEGMENT = "/SVN/";
    protected File stateInfoFile;
    protected String repositoriesPreferencesNode;
    protected IEclipsePreferences.IPreferenceChangeListener repoPrefChangeListener;
    protected SVNCachedProxyCredentialsManager proxyCredentialsManager;
    protected IRepositoryLocation[] repositories = new IRepositoryLocation[0];
    protected List<IRepositoriesStateChangedListener> repositoriesStateChangedListeners = new ArrayList<IRepositoriesStateChangedListener>();
    protected ArrayList<IRevisionPropertyChangeListener> revPropChangeListeners = new ArrayList();
    protected String migrateFromAuthDBPreferenceNode;
    protected boolean isMigratedFromAuthorizationDatabase;

    public void dispose() {
        IRepositoryLocation[] locations = this.repositories;
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                locations[i].dispose();
                ++i;
            }
        }
    }

    public void reconfigureLocations() {
        IRepositoryLocation[] locations = this.repositories;
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                locations[i].reconfigure();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepositoriesStateChangedListener(IRepositoriesStateChangedListener listener) {
        List<IRepositoriesStateChangedListener> list = this.repositoriesStateChangedListeners;
        synchronized (list) {
            this.repositoriesStateChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoriesStateChangedListener(IRepositoriesStateChangedListener listener) {
        List<IRepositoriesStateChangedListener> list = this.repositoriesStateChangedListeners;
        synchronized (list) {
            this.repositoriesStateChangedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRepositoriesStateChanged(RepositoriesStateChangedEvent event) {
        List<IRepositoriesStateChangedListener> list = this.repositoriesStateChangedListeners;
        synchronized (list) {
            for (IRepositoriesStateChangedListener listener : this.repositoriesStateChangedListeners) {
                listener.repositoriesStateChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRevisionPropertyChangeListener(IRevisionPropertyChangeListener listener) {
        ArrayList<IRevisionPropertyChangeListener> arrayList = this.revPropChangeListeners;
        synchronized (arrayList) {
            this.revPropChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRevisionPropertyChangeEvent(RevisonPropertyChangeEvent event) {
        ArrayList<IRevisionPropertyChangeListener> arrayList = this.revPropChangeListeners;
        synchronized (arrayList) {
            for (IRevisionPropertyChangeListener current : this.revPropChangeListeners) {
                current.revisionPropertyChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionPropertyChangeListener(IRevisionPropertyChangeListener listener) {
        ArrayList<IRevisionPropertyChangeListener> arrayList = this.revPropChangeListeners;
        synchronized (arrayList) {
            this.revPropChangeListeners.remove(listener);
        }
    }

    public static IEclipsePreferences getRepositoriesPreferences(String prefNode) {
        return (IEclipsePreferences)SVNTeamPlugin.instance().getSVNCorePreferences().node(prefNode);
    }

    public IRepositoryLocation[] getRepositoryLocations() {
        return this.repositories;
    }

    public IRepositoryLocation getRepositoryLocation(String id) {
        int i = 0;
        while (i < this.repositories.length) {
            if (this.repositories[i].getId().equals(id)) {
                return this.repositories[i];
            }
            ++i;
        }
        return null;
    }

    public IRepositoryLocation newRepositoryLocation() {
        return new SVNRepositoryLocation(new UniversalUniqueIdentifier().toString());
    }

    public void copyRepositoryLocation(IRepositoryLocation to, IRepositoryLocation from) {
        to.setStructureEnabled(from.isStructureEnabled());
        to.setBranchesLocation(from.getUserInputBranches());
        to.setTagsLocation(from.getUserInputTags());
        to.setTrunkLocation(from.getUserInputTrunk());
        to.setUrl(from.getUrlAsIs());
        to.setLabel(from.getLabel());
        to.setUsername(from.getUsername());
        to.setPassword(from.getPassword());
        to.setPasswordSaved(from.isPasswordSaved());
        SSHSettings sshOriginal = from.getSSHSettings();
        SSHSettings sshNew = to.getSSHSettings();
        sshNew.setPassPhrase(sshOriginal.getPassPhrase());
        sshNew.setPassPhraseSaved(sshOriginal.isPassPhraseSaved());
        sshNew.setPort(sshOriginal.getPort());
        sshNew.setPrivateKeyPath(sshOriginal.getPrivateKeyPath());
        sshNew.setUseKeyFile(sshOriginal.isUseKeyFile());
        SSLSettings sslOriginal = from.getSSLSettings();
        SSLSettings sslNew = to.getSSLSettings();
        sslNew.setAuthenticationEnabled(sslOriginal.isAuthenticationEnabled());
        sslNew.setCertificatePath(sslOriginal.getCertificatePath());
        sslNew.setPassPhrase(sslOriginal.getPassPhrase());
        sslNew.setPassPhraseSaved(sslOriginal.isPassPhraseSaved());
        if (from instanceof SVNRepositoryLocation && to instanceof SVNRepositoryLocation) {
            SVNRepositoryLocation tmpFrom = (SVNRepositoryLocation)from;
            SVNRepositoryLocation tmpTo = (SVNRepositoryLocation)to;
            tmpTo.repositoryRootUrl = tmpFrom.repositoryRootUrl;
            tmpTo.repositoryUUID = tmpFrom.repositoryUUID;
            tmpTo.getAdditionalRealms().clear();
            for (String realm : from.getRealms()) {
                IRepositoryLocation target = this.newRepositoryLocation();
                IRepositoryLocation source = from.getLocationForRealm(realm);
                this.copyRepositoryLocation(target, source);
                to.addRealm(realm, target);
            }
        }
    }

    public IRepositoryLocation newRepositoryLocation(String reference) {
        if (reference == null) {
            return this.newRepositoryLocation();
        }
        String[] parts = reference.split(";");
        if (parts.length == 0 || parts[0].length() == 0) {
            return this.newRepositoryLocation();
        }
        IRepositoryLocation location = this.getRepositoryLocation(parts[0]);
        if (location != null) {
            return location;
        }
        String id = parts[0].trim();
        location = new SVNRepositoryLocation(id.length() > 0 ? id : new UniversalUniqueIdentifier().toString());
        location.setTrunkLocation("");
        location.setTagsLocation("");
        location.setBranchesLocation("");
        location.setAuthorName("");
        location.fillLocationFromReference(parts);
        return location;
    }

    public String repositoryLocationAsReference(IRepositoryLocation location, IRepositoryLocation.LocationReferenceTypeEnum locationReferenceType) {
        return location.asReference(locationReferenceType);
    }

    public synchronized void addRepositoryLocation(IRepositoryLocation location) {
        ArrayList<IRepositoryLocation> tmp = new ArrayList<IRepositoryLocation>(Arrays.asList(this.repositories));
        if (!tmp.contains(location)) {
            tmp.add(location);
            this.repositories = tmp.toArray(new IRepositoryLocation[tmp.size()]);
        }
        this.fireRepositoriesStateChanged(new RepositoriesStateChangedEvent(location, 0));
    }

    public synchronized void removeRepositoryLocation(IRepositoryLocation location) {
        String[] realms;
        ArrayList<IRepositoryLocation> tmp = new ArrayList<IRepositoryLocation>(Arrays.asList(this.repositories));
        this.removeAuthInfoForLocation(location, "");
        String[] stringArray = realms = location.getRealms().toArray(new String[0]);
        int n = realms.length;
        int n2 = 0;
        while (n2 < n) {
            String realm = stringArray[n2];
            this.removeAuthInfoForLocation(location, realm);
            ++n2;
        }
        if (tmp.remove(location)) {
            this.repositories = tmp.toArray(new IRepositoryLocation[tmp.size()]);
        }
        this.fireRepositoriesStateChanged(new RepositoriesStateChangedEvent(location, 1));
    }

    public SVNCachedProxyCredentialsManager getProxyCredentialsManager() {
        return this.proxyCredentialsManager;
    }

    public synchronized void saveConfiguration() throws Exception {
        this.saveLocations();
        if (!this.isMigratedFromAuthorizationDatabase) {
            IEclipsePreferences migratePref = (IEclipsePreferences)SVNTeamPlugin.instance().getSVNCorePreferences().node(this.migrateFromAuthDBPreferenceNode);
            migratePref.putBoolean("isMigrated", true);
            try {
                migratePref.flush();
            }
            catch (BackingStoreException e) {
                LoggedOperation.reportError(SVNMessages.getErrorString("Error_SaveMigratePreference"), e);
            }
        }
    }

    public byte[] revisionLinkAsBytes(IRevisionLink link, boolean saveRevisionLinksComments) {
        String str = this.repositoryResourceAsString(link.getRepositoryResource());
        if (str != null && saveRevisionLinksComments) {
            str = String.valueOf(str) + ";" + new String(Base64.encode((byte[])link.getComment().getBytes()));
        }
        return str != null ? str.getBytes() : null;
    }

    public byte[] repositoryResourceAsBytes(IRepositoryResource resource) {
        String str = this.repositoryResourceAsString(resource);
        return str != null ? str.getBytes() : null;
    }

    protected String repositoryResourceAsString(IRepositoryResource resource) {
        if (resource == null) {
            return null;
        }
        String retVal = String.valueOf(new String(Base64.encode((byte[])String.valueOf(resource instanceof IRepositoryContainer).getBytes()))) + ";" + resource.getRepositoryLocation().getId() + ";" + new String(Base64.encode((byte[])resource.getUrl().getBytes())) + ";" + String.valueOf(resource.getSelectedRevision().getKind()) + ";" + this.convertRevisionToString(resource.getSelectedRevision()) + ";" + String.valueOf(4) + ";" + String.valueOf(resource.getPegRevision().getKind()) + ";" + this.convertRevisionToString(resource.getPegRevision());
        return retVal;
    }

    protected SVNRevision convertToRevision(int revisionKind, long revNum, boolean isPegRevision) {
        SVNRevision revision = revisionKind == 1 ? (revNum == -1L ? (isPegRevision ? null : SVNRevision.INVALID_REVISION) : SVNRevision.fromNumber(revNum)) : (revisionKind == 2 ? SVNRevision.fromDate(revNum) : SVNRevision.fromKind(revisionKind));
        return revision;
    }

    protected String convertRevisionToString(SVNRevision revision) {
        String strRevision = revision.getKind() == 1 ? String.valueOf(((SVNRevision.Number)revision).getNumber()) : (revision.getKind() == 2 ? String.valueOf(((SVNRevision.Date)revision).getDate()) : "0");
        return strRevision;
    }

    public IRepositoryResource repositoryResourceFromBytes(byte[] bytes) {
        return this.repositoryResourceFromBytes(bytes, null);
    }

    public IRevisionLink revisionLinkFromBytes(byte[] bytes, IRepositoryLocation location) {
        IRepositoryResource resource = this.repositoryResourceFromBytes(bytes, location);
        if (resource != null) {
            String[] data = new String(bytes).split(";");
            String comment = null;
            if (data.length > 8) {
                comment = new String(Base64.decode((byte[])data[8].getBytes()));
            }
            IRevisionLink link = SVNUtility.createRevisionLink(resource);
            link.setComment(comment);
            return link;
        }
        return null;
    }

    public IRepositoryResource repositoryResourceFromBytes(byte[] bytes, IRepositoryLocation location) {
        if (bytes == null) {
            return null;
        }
        String[] data = new String(bytes).split(";");
        boolean isFolder = false;
        boolean base64Label = false;
        if ("true".equals(data[0])) {
            isFolder = true;
        } else if (!"false".equals(data[0])) {
            isFolder = "true".equals(new String(Base64.decode((byte[])data[0].getBytes())));
            base64Label = true;
        }
        if (location == null) {
            location = this.getRepositoryLocation(data[1]);
        }
        if (location == null) {
            return null;
        }
        int revisionKind = Integer.parseInt(data[3]);
        long revNum = Long.parseLong(data[4]);
        SVNRevision selectedRevision = this.convertToRevision(revisionKind, revNum, false);
        SVNRevision pegRevision = null;
        if (data.length > 6) {
            int pegKind = Integer.parseInt(data[6]);
            long pegNum = Long.parseLong(data[7]);
            pegRevision = this.convertToRevision(pegKind, pegNum, true);
        }
        String urlPart = base64Label ? new String(Base64.decode((byte[])data[2].getBytes())) : data[2];
        try {
            SVNUtility.getSVNUrl(urlPart);
        }
        catch (MalformedURLException malformedURLException) {
            String prefix = AbstractSVNStorage.getRootPrefix(location, Integer.parseInt(data[5]));
            urlPart = String.valueOf(prefix) + urlPart;
        }
        location = this.wrapLocationIfRequired(location, urlPart, !isFolder);
        IRepositoryResource retVal = isFolder ? location.asRepositoryContainer(urlPart, false) : location.asRepositoryFile(urlPart, false);
        retVal.setSelectedRevision(selectedRevision);
        retVal.setPegRevision(pegRevision);
        return retVal;
    }

    protected abstract IRepositoryLocation wrapLocationIfRequired(IRepositoryLocation var1, String var2, boolean var3);

    protected static String getRootPrefix(IRepositoryLocation location, int rootKind) {
        switch (rootKind) {
            case 4: {
                return location.getRepositoryRootUrl();
            }
            case 0: {
                return location.getUrl();
            }
            case 1: {
                return location.isStructureEnabled() ? String.valueOf(location.getUrl()) + "/" + location.getTrunkLocation() : location.getUrl();
            }
            case 2: {
                return location.isStructureEnabled() ? String.valueOf(location.getUrl()) + "/" + location.getBranchesLocation() : location.getUrl();
            }
            case 3: {
                return location.isStructureEnabled() ? String.valueOf(location.getUrl()) + "/" + location.getTagsLocation() : location.getUrl();
            }
        }
        return null;
    }

    protected void initializeImpl(String repositoriesPreferencesNode, String migrateFromAuthDBPreferenceNode) throws Exception {
        IProxyService proxyService = SVNTeamPlugin.instance().getProxyService();
        this.proxyCredentialsManager = new SVNCachedProxyCredentialsManager(proxyService);
        proxyService.addProxyChangeListener(new IProxyChangeListener(){

            public void proxyInfoChanged(IProxyChangeEvent event) {
                IProxyData[] newDatas;
                IProxyData[] iProxyDataArray = newDatas = event.getChangedProxyData();
                int n = newDatas.length;
                int n2 = 0;
                while (n2 < n) {
                    IProxyData current = iProxyDataArray[n2];
                    if (current.isRequiresAuthentication()) {
                        AbstractSVNStorage.this.proxyCredentialsManager.setPassword(current.getPassword());
                        AbstractSVNStorage.this.proxyCredentialsManager.setUsername(current.getUserId());
                        break;
                    }
                    ++n2;
                }
                AbstractSVNStorage.this.dispose();
            }
        });
        this.migrateFromAuthDBPreferenceNode = migrateFromAuthDBPreferenceNode;
        IEclipsePreferences migratePref = (IEclipsePreferences)SVNTeamPlugin.instance().getSVNCorePreferences().node(this.migrateFromAuthDBPreferenceNode);
        this.isMigratedFromAuthorizationDatabase = migratePref.getBoolean("isMigrated", false);
        if (!this.isMigratedFromAuthorizationDatabase) {
            SVNTeamPlugin.instance().setLocationsDirty(true);
        }
        this.repositoriesPreferencesNode = repositoriesPreferencesNode;
        this.repoPrefChangeListener = new RepositoryPreferenceChangeListener();
        IEclipsePreferences repositoryPreferences = AbstractSVNStorage.getRepositoriesPreferences(this.repositoriesPreferencesNode);
        repositoryPreferences.addPreferenceChangeListener(this.repoPrefChangeListener);
        if (this.stateInfoFile.exists()) {
            try {
                try {
                    this.loadLocationsFromFile();
                    this.saveLocations();
                }
                catch (Exception ex) {
                    LoggedOperation.reportError(SVNMessages.getErrorString("Error_LoadLocationsFromFile"), ex);
                    this.stateInfoFile.delete();
                }
            }
            finally {
                this.stateInfoFile.delete();
            }
        } else {
            try {
                this.loadLocations();
            }
            catch (Exception ex) {
                LoggedOperation.reportError(SVNMessages.getErrorString("Error_LoadLocations"), ex);
            }
        }
    }

    protected void saveLocations() throws Exception {
        IEclipsePreferences repositoryPreferences = AbstractSVNStorage.getRepositoriesPreferences(this.repositoriesPreferencesNode);
        repositoryPreferences.removePreferenceChangeListener(this.repoPrefChangeListener);
        repositoryPreferences.clear();
        IRepositoryLocation[] iRepositoryLocationArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            String[] realms;
            IRepositoryLocation current = iRepositoryLocationArray[n2];
            repositoryPreferences.put(current.getId(), this.repositoryLocationAsReference(current, IRepositoryLocation.LocationReferenceTypeEnum.ALL));
            this.saveAuthInfo(current, "");
            String[] stringArray = realms = current.getRealms().toArray(new String[0]);
            int n3 = realms.length;
            int n4 = 0;
            while (n4 < n3) {
                String realm = stringArray[n4];
                this.saveAuthInfo(current, realm);
                ++n4;
            }
            ++n2;
        }
        repositoryPreferences.flush();
        SVNTeamPlugin.instance().savePluginPreferences();
        repositoryPreferences.addPreferenceChangeListener(this.repoPrefChangeListener);
    }

    protected ISecurePreferences getSVNNodeForSecurePreferences(IRepositoryLocation location, String realm) {
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        if (preferences == null) {
            return null;
        }
        String urlPart = String.valueOf(location.getUrlAsIs()) + ":" + location.getId();
        if (!"".equals(realm)) {
            urlPart = String.valueOf(urlPart) + ":" + realm;
        }
        String path = SVN_SECURE_NAME_SEGMENT + EncodingUtils.encodeSlashes((String)urlPart);
        try {
            return preferences.node(path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    protected void saveAuthInfo(IRepositoryLocation location, String realm) throws Exception {
        ISecurePreferences node = this.getSVNNodeForSecurePreferences(location, realm);
        if (node != null) {
            try {
                IRepositoryLocation tmp = realm.equals("") ? location : location.getLocationForRealm(realm);
                boolean toStorePass = tmp.isPasswordSaved();
                node.put("username", toStorePass ? tmp.getUsername() : "", false);
                node.put("password", toStorePass ? tmp.getPassword() : "", true);
                node.putBoolean("password_saved", toStorePass, false);
                SSHSettings sshSettings = tmp.getSSHSettings();
                boolean useKeyFile = sshSettings.isUseKeyFile();
                node.putBoolean("ssh_use_key", useKeyFile, false);
                boolean savePassphrase = sshSettings.isPassPhraseSaved();
                node.putBoolean("ssh_passphrase_saved", useKeyFile ? savePassphrase : false, false);
                node.put("ssh_key", useKeyFile ? sshSettings.getPrivateKeyPath() : "", false);
                node.put("ssh_passprase", useKeyFile && savePassphrase ? sshSettings.getPassPhrase() : "", true);
                node.putInt("ssh_port", sshSettings.getPort(), false);
                SSLSettings sslSettings = tmp.getSSLSettings();
                boolean clientAuthEnabled = sslSettings.isAuthenticationEnabled();
                savePassphrase = sslSettings.isPassPhraseSaved();
                node.putBoolean("ssl_enabled", clientAuthEnabled, false);
                node.put("ssl_certificate", clientAuthEnabled ? sslSettings.getCertificatePath() : "", false);
                node.putBoolean("ssl_passphrase_saved", clientAuthEnabled ? savePassphrase : false, false);
                node.put("ssl_passphrase", clientAuthEnabled && savePassphrase ? sslSettings.getPassPhrase() : "", true);
            }
            catch (StorageException e) {
                LoggedOperation.reportError(SVNMessages.getErrorString("Error_SaveAutherizationInfo"), e);
            }
        }
    }

    protected void loadAuthInfo(IRepositoryLocation location, String realm) throws Exception {
        if (this.isMigratedFromAuthorizationDatabase) {
            this.loadAuthInfoFromSecureStorage(location, realm);
        } else {
            this.loadAuthInfoFromAuthorizationDatabase(location, realm);
        }
    }

    protected void loadAuthInfoFromSecureStorage(IRepositoryLocation location, String realm) throws Exception {
        try {
            ISecurePreferences node = this.getSVNNodeForSecurePreferences(location, realm);
            if (node != null) {
                boolean toAddRealm = !realm.equals("");
                IRepositoryLocation tmp = toAddRealm ? this.newRepositoryLocation() : location;
                boolean isPasswordSaved = node.getBoolean("password_saved", false);
                tmp.setPasswordSaved(isPasswordSaved);
                tmp.setUsername(isPasswordSaved ? node.get("username", "") : "");
                tmp.setPassword(isPasswordSaved ? node.get("password", "") : "");
                SSHSettings sshSettings = tmp instanceof SVNRepositoryLocation ? ((SVNRepositoryLocation)tmp).getSSHSettings(false) : tmp.getSSHSettings();
                sshSettings.setUseKeyFile(node.getBoolean("ssh_use_key", false));
                sshSettings.setPrivateKeyPath(node.get("ssh_key", ""));
                sshSettings.setPassPhraseSaved(node.getBoolean("ssh_passphrase_saved", false));
                sshSettings.setPassPhrase(node.get("ssh_passprase", ""));
                int defaultPort = sshSettings.getPort();
                defaultPort = defaultPort != 0 ? defaultPort : 22;
                sshSettings.setPort(node.getInt("ssh_port", defaultPort));
                SSLSettings sslSettings = tmp instanceof SVNRepositoryLocation ? ((SVNRepositoryLocation)tmp).getSSLSettings(false) : tmp.getSSLSettings();
                sslSettings.setAuthenticationEnabled(node.getBoolean("ssl_enabled", false));
                sslSettings.setCertificatePath(node.get("ssl_certificate", ""));
                sslSettings.setPassPhraseSaved(node.getBoolean("ssl_passphrase_saved", false));
                sslSettings.setPassPhrase(node.get("ssl_passphrase", ""));
                if (toAddRealm) {
                    location.addRealm(realm, tmp);
                }
            }
        }
        catch (StorageException e) {
            LoggedOperation.reportError(SVNMessages.getErrorString("Error_LoadAuthorizationInfo"), e);
        }
    }

    protected void loadAuthInfoFromAuthorizationDatabase(IRepositoryLocation location, String realm) throws Exception {
        Map authInfo = Platform.getAuthorizationInfo((URL)new URL("http://eclipse.org/subversive/"), (String)location.getId(), (String)realm);
        if (authInfo != null) {
            boolean toAddRealm = !realm.equals("");
            IRepositoryLocation tmp = toAddRealm ? this.newRepositoryLocation() : location;
            tmp.setUsername((String)authInfo.get("username"));
            tmp.setPasswordSaved(((String)authInfo.get("password_saved")).equals("true"));
            tmp.setPassword((String)authInfo.get("password"));
            SSHSettings sshSettings = tmp instanceof SVNRepositoryLocation ? ((SVNRepositoryLocation)tmp).getSSHSettings(false) : tmp.getSSHSettings();
            sshSettings.setUseKeyFile(((String)authInfo.get("ssh_use_key")).equals("true"));
            sshSettings.setPrivateKeyPath((String)authInfo.get("ssh_key"));
            sshSettings.setPassPhraseSaved(((String)authInfo.get("ssh_passphrase_saved")).equals("true"));
            sshSettings.setPassPhrase((String)authInfo.get("ssh_passprase"));
            SSLSettings sslSettings = tmp instanceof SVNRepositoryLocation ? ((SVNRepositoryLocation)tmp).getSSLSettings(false) : tmp.getSSLSettings();
            sslSettings.setAuthenticationEnabled(((String)authInfo.get("ssl_enabled")).equals("true"));
            sslSettings.setCertificatePath((String)authInfo.get("ssl_certificate"));
            sslSettings.setPassPhraseSaved(((String)authInfo.get("ssl_passphrase_saved")).equals("true"));
            sslSettings.setPassPhrase((String)authInfo.get("ssl_passphrase"));
            if (toAddRealm) {
                location.addRealm(realm, tmp);
            }
        }
    }

    public void removeAuthInfoForLocation(IRepositoryLocation location, String realm) {
        ISecurePreferences node = this.getSVNNodeForSecurePreferences(location, realm);
        if (node == null) {
            return;
        }
        try {
            node.clear();
            node.flush();
        }
        catch (IllegalStateException e) {
            LoggedOperation.reportError(SVNMessages.getErrorString("Error_RemoveAuthorizationInfo"), e);
        }
        catch (IOException e) {
            LoggedOperation.reportError(SVNMessages.getErrorString("Error_RemoveAuthorizationInfo"), e);
        }
    }

    protected void loadLocations() throws Exception {
        IEclipsePreferences repositoryPreferences = AbstractSVNStorage.getRepositoriesPreferences(this.repositoriesPreferencesNode);
        String[] keys = repositoryPreferences.keys();
        ArrayList<IRepositoryLocation> readLocations = new ArrayList<IRepositoryLocation>();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String current = stringArray[n2];
            IRepositoryLocation location = this.newRepositoryLocation(repositoryPreferences.get(current, null));
            readLocations.add(location);
            ++n2;
        }
        this.repositories = readLocations.toArray(new IRepositoryLocation[readLocations.size()]);
    }

    protected void setStateInfoFile(IPath stateInfoLocation, String fileName) {
        this.stateInfoFile = stateInfoLocation.append(fileName).toFile();
    }

    protected void loadLocationsFromFile() throws Exception {
        ArrayList<IRepositoryLocation> tmp = new ArrayList<IRepositoryLocation>(Arrays.asList(this.repositories));
        ObjectInputStream stream = null;
        try {
            try {
                stream = new ObjectInputStream(new FileInputStream(this.stateInfoFile));
                while (true) {
                    SVNRepositoryLocation obj;
                    if (tmp.contains(obj = (SVNRepositoryLocation)stream.readObject())) {
                        continue;
                    }
                    tmp.add(obj);
                }
            }
            catch (EOFException eOFException) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        this.repositories = tmp.toArray(new IRepositoryLocation[tmp.size()]);
    }

    protected class RepositoryPreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        protected RepositoryPreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            HashSet<IRepositoryLocation> readLocations = new HashSet<IRepositoryLocation>(Arrays.asList(AbstractSVNStorage.this.repositories));
            IRepositoryLocation location = AbstractSVNStorage.this.newRepositoryLocation((String)event.getNewValue());
            readLocations.add(location);
            AbstractSVNStorage.this.repositories = readLocations.toArray(new IRepositoryLocation[readLocations.size()]);
            try {
                ((IEclipsePreferences)event.getSource()).flush();
            }
            catch (BackingStoreException e) {
                LoggedOperation.reportError("preferenceChange", e);
            }
            AbstractSVNStorage.this.fireRepositoriesStateChanged(new RepositoriesStateChangedEvent(location, 0));
        }
    }
}

