/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.action;

import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IPasteFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IPasteContext;
import org.eclipse.graphiti.features.context.impl.PasteContext;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.action.AbstractPreDefinedAction;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class PasteAction
extends AbstractPreDefinedAction {
    private static final String TEXT;
    private static final String TOOL_TIP;
    public static final String ACTION_ID;

    static {
        TOOL_TIP = TEXT = Messages.PasteAction_0_xfld;
        ACTION_ID = ActionFactory.PASTE.getId();
    }

    public PasteAction(IWorkbenchPart part, IConfigurationProvider configurationProvider) {
        super(part, configurationProvider);
        this.setId(ACTION_ID);
        this.setText(TEXT);
        this.setToolTipText(TOOL_TIP);
    }

    @Override
    public boolean isAvailable() {
        PictogramElement[] pes = this.getSelectedPictogramElements();
        PasteContext context = new PasteContext(pes);
        IPasteFeature feature = this.getFeatureProvider().getPasteFeature((IPasteContext)context);
        return feature != null;
    }

    protected boolean calculateEnabled() {
        PictogramElement[] pes = this.getSelectedPictogramElements();
        if (pes.length == 0) {
            return false;
        }
        PasteContext context = new PasteContext(pes);
        IFeatureProvider featureProvider = this.getFeatureProvider();
        if (featureProvider == null) {
            return false;
        }
        IPasteFeature feature = featureProvider.getPasteFeature((IPasteContext)context);
        return feature != null && feature.canPaste((IPasteContext)context);
    }

    public void run() {
        PictogramElement[] pes = this.getSelectedPictogramElements();
        PasteContext context = new PasteContext(pes);
        IFeatureProvider featureProvider = this.getFeatureProvider();
        IPasteFeature feature = featureProvider.getPasteFeature((IPasteContext)context);
        if (feature != null) {
            GenericFeatureCommandWithContext command = new GenericFeatureCommandWithContext((IFeature)feature, (IContext)context);
            this.executeOnCommandStack((ICommand)command);
        }
    }
}

