/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ScrollPaneSolver;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorInternal;
import org.eclipse.graphiti.ui.internal.parts.DiagramEditPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GFFigureCanvas
extends Canvas
implements IAdaptable {
    public static int NEVER = 0;
    public static int AUTOMATIC = 1;
    public static int ALWAYS = 2;
    private int vBarVisibility = AUTOMATIC;
    private int hBarVisibility = AUTOMATIC;
    private Viewport viewport;
    private Font font;
    private int hBarOffset;
    private int vBarOffset;
    private final Pixel bottomRightCorner = new Pixel();
    private final Pixel topLeftCorner = new Pixel();
    private boolean doScroll = true;
    private final GFUpdateListener gfUpdateListener = new GFUpdateListener();
    private DiagramEditorInternal diagramEditor = null;
    private boolean init = true;
    private final PropertyChangeListener horizontalChangeListener = new PropertyChangeListener(){
        double OldZoomlevel = 1.0;

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Rectangle diagramBounds = GFFigureCanvas.this.getDiagramBoundsFromCornerPixels();
            Rectangle clientArea = new Rectangle(GFFigureCanvas.this.getClientArea());
            int diff = diagramBounds.width - clientArea.width;
            double zoomLevel = GFFigureCanvas.this.getZoomLevel();
            if (zoomLevel != this.OldZoomlevel || diff <= 0) {
                GFFigureCanvas.this.bottomRightCorner.remove();
                Rectangle minimalDiagram = GFFigureCanvas.this.getDiagramBoundsFromEditPartChildren();
                int newX = minimalDiagram.right();
                if ((double)newX * zoomLevel <= (double)clientArea.right()) {
                    newX = (int)((double)clientArea.right() / zoomLevel);
                }
                GFFigureCanvas.this.bottomRightCorner.replace(newX, ((GFFigureCanvas)GFFigureCanvas.this).bottomRightCorner.getBounds().y);
                this.OldZoomlevel = zoomLevel;
            }
            RangeModel model = GFFigureCanvas.this.getViewport().getHorizontalRangeModel();
            GFFigureCanvas.this.hBarOffset = Math.max(0, -model.getMinimum());
            GFFigureCanvas.this.getHorizontalBar().setValues(model.getValue() + GFFigureCanvas.this.hBarOffset, model.getMinimum() + GFFigureCanvas.this.hBarOffset, model.getMaximum() + GFFigureCanvas.this.hBarOffset, model.getExtent(), Math.max(1, model.getExtent() / 20), Math.max(1, model.getExtent() * 3 / 4));
        }
    };
    private final PropertyChangeListener verticalChangeListener = new PropertyChangeListener(){
        double OldZoomlevel = 1.0;

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Rectangle diagramBounds = GFFigureCanvas.this.getDiagramBoundsFromCornerPixels();
            Rectangle clientArea = new Rectangle(GFFigureCanvas.this.getClientArea());
            int diff = diagramBounds.height - clientArea.height;
            double zoomLevel = GFFigureCanvas.this.getZoomLevel();
            if (zoomLevel != this.OldZoomlevel || diff <= 0) {
                GFFigureCanvas.this.bottomRightCorner.remove();
                Rectangle minimalDiagram = GFFigureCanvas.this.getDiagramBoundsFromEditPartChildren();
                int newY = minimalDiagram.bottom();
                if ((double)newY * zoomLevel <= (double)clientArea.bottom()) {
                    newY = (int)((double)clientArea.bottom() / zoomLevel);
                }
                GFFigureCanvas.this.bottomRightCorner.replace(((GFFigureCanvas)GFFigureCanvas.this).bottomRightCorner.getBounds().x, newY);
                this.OldZoomlevel = zoomLevel;
            }
            RangeModel model = GFFigureCanvas.this.getViewport().getVerticalRangeModel();
            GFFigureCanvas.this.vBarOffset = Math.max(0, -model.getMinimum());
            GFFigureCanvas.this.getVerticalBar().setValues(model.getValue() + GFFigureCanvas.this.vBarOffset, model.getMinimum() + GFFigureCanvas.this.vBarOffset, model.getMaximum() + GFFigureCanvas.this.vBarOffset, model.getExtent(), Math.max(1, model.getExtent() / 20), Math.max(1, model.getExtent() * 3 / 4));
        }
    };
    private final LightweightSystem lws;

    public GFFigureCanvas(Composite parent, DiagramEditorInternal diagramEditor) {
        this(parent, 0x20000000, new LightweightSystem(), diagramEditor);
    }

    public GFFigureCanvas(Composite parent, int style, DiagramEditorInternal diagramEditor) {
        this(parent, style, new LightweightSystem(), diagramEditor);
    }

    public GFFigureCanvas(Composite parent, LightweightSystem lws, DiagramEditorInternal diagramEditor) {
        this(parent, 0x20000000, lws, diagramEditor);
    }

    public GFFigureCanvas(Composite parent, int style, LightweightSystem lws, DiagramEditorInternal diagramEditor) {
        super(parent, GFFigureCanvas.checkStyle(style | 0x100000 | 0x40000 | 0x200 | 0x100));
        this.getHorizontalBar().setVisible(false);
        this.getVerticalBar().setVisible(false);
        this.lws = lws;
        this.diagramEditor = diagramEditor;
        lws.setControl((Canvas)this);
        this.hook();
    }

    private static int checkStyle(int style) {
        int validStyles = 638845696;
        if ((style & ~validStyles) != 0) {
            throw new IllegalArgumentException("Invalid style being set on FigureCanvas");
        }
        return style;
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        Dimension size = this.getLightweightSystem().getRootFigure().getPreferredSize(wHint, hHint);
        size.union(new Dimension(wHint, hHint));
        return new org.eclipse.swt.graphics.Point(size.width, size.height);
    }

    public IFigure getContents() {
        return this.getViewport().getContents();
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = super.getFont();
        }
        return this.font;
    }

    public int getHorizontalScrollBarVisibility() {
        return this.hBarVisibility;
    }

    public LightweightSystem getLightweightSystem() {
        return this.lws;
    }

    public int getVerticalScrollBarVisibility() {
        return this.vBarVisibility;
    }

    public Viewport getViewport() {
        if (this.viewport == null) {
            this.setViewport(new Viewport(true));
        }
        return this.viewport;
    }

    private void hook() {
        this.getLightweightSystem().getUpdateManager().addUpdateListener((UpdateListener)this.gfUpdateListener);
        this.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GFFigureCanvas.this.scrollToX(event, GFFigureCanvas.this.getHorizontalBar().getSelection() - GFFigureCanvas.this.hBarOffset);
            }
        });
        this.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GFFigureCanvas.this.scrollToY(event, GFFigureCanvas.this.getVerticalBar().getSelection() - GFFigureCanvas.this.vBarOffset);
            }
        });
    }

    private void hookViewport() {
        this.getViewport().getHorizontalRangeModel().addPropertyChangeListener(this.horizontalChangeListener);
        this.getViewport().getVerticalRangeModel().addPropertyChangeListener(this.verticalChangeListener);
    }

    private void unhookViewport() {
        this.getViewport().getHorizontalRangeModel().removePropertyChangeListener(this.horizontalChangeListener);
        this.getViewport().getVerticalRangeModel().removePropertyChangeListener(this.verticalChangeListener);
    }

    private void layoutViewport() {
        if (this.init) {
            this.setCornerPixels();
            this.init = false;
        }
        ScrollPaneSolver.Result result = ScrollPaneSolver.solve((Rectangle)new Rectangle(this.getBounds()).setLocation(0, 0), (Viewport)this.getViewport(), (int)this.getHorizontalScrollBarVisibility(), (int)this.getVerticalScrollBarVisibility(), (int)this.computeTrim((int)0, (int)0, (int)0, (int)0).width, (int)this.computeTrim((int)0, (int)0, (int)0, (int)0).height);
        if (this.getHorizontalBar().getVisible() != result.showH) {
            this.getHorizontalBar().setVisible(result.showH);
        }
        if (this.getVerticalBar().getVisible() != result.showV) {
            this.getVerticalBar().setVisible(result.showV);
        }
        Rectangle r = new Rectangle(this.getClientArea());
        r.setLocation(0, 0);
        this.getLightweightSystem().getRootFigure().setBounds(r);
    }

    private Rectangle getDiagramBounds() {
        Rectangle clientArea = new Rectangle(this.getClientArea());
        Rectangle bounds = this.getDiagramBoundsFromDiagramEditPart().getCopy();
        bounds.union(0, 0, clientArea.width, clientArea.height);
        return bounds;
    }

    public void scrollToX(SelectionEvent event, int hOffset) {
        org.eclipse.swt.graphics.Rectangle bounds;
        Rectangle diagramBounds;
        if (event == null) {
            return;
        }
        hOffset = this.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), hOffset);
        int hOffsetOld = this.getViewport().getViewLocation().x;
        int dx = -hOffset + hOffsetOld;
        double zoomLevel = this.getZoomLevel();
        if (dx != 0) {
            if (event.detail == 0x1000001 || event.detail == 0x1000002) {
                this.regainHorizontalSpace();
            }
        } else if (event.detail == 0x1000001) {
            dx = 0;
            diagramBounds = this.getDiagramBounds();
            hOffset = diagramBounds.x + dx;
            this.topLeftCorner.replace(hOffset, this.topLeftCorner.getBounds().y);
            this.getViewport().getHorizontalRangeModel().setAll((int)((double)hOffset * zoomLevel), (int)((double)(diagramBounds.width - Math.abs(dx)) * zoomLevel), this.bottomRightCorner.getBounds().x);
            this.doScroll = false;
        } else if (event.detail == 0x1000002) {
            dx = this.getHorizontalBar().getIncrement();
            diagramBounds = this.getDiagramBounds();
            hOffset = diagramBounds.right() + dx;
            this.bottomRightCorner.replace(hOffset, this.bottomRightCorner.getBounds().y);
            this.getViewport().getHorizontalRangeModel().setAll((int)((double)hOffset * zoomLevel), (int)((double)(diagramBounds.width - Math.abs(dx)) * zoomLevel), this.bottomRightCorner.getBounds().x);
            this.doScroll = false;
        } else {
            return;
        }
        Rectangle clientArea = this.getViewport().getBounds().getCropped(this.getViewport().getInsets());
        Rectangle blit = clientArea.getResized(-Math.abs(dx), 0);
        Rectangle expose = clientArea.getCopy();
        Point dest = clientArea.getTopLeft();
        expose.width = Math.abs(dx);
        if (dx < 0) {
            blit.translate(-dx, 0);
            expose.x = dest.x + blit.width;
        } else {
            dest.x += dx;
        }
        Control[] children = this.getChildren();
        boolean[] manualMove = new boolean[children.length];
        int i = 0;
        while (i < children.length) {
            bounds = children[i].getBounds();
            manualMove[i] = blit.width <= 0 || bounds.x > blit.x + blit.width || bounds.y > blit.y + blit.height || bounds.x + bounds.width < blit.x || bounds.y + bounds.height < blit.y;
            ++i;
        }
        if (this.doScroll) {
            this.scroll(dest.x, dest.y, blit.x, blit.y, blit.width, blit.height, true);
        }
        this.doScroll = true;
        i = 0;
        while (i < children.length) {
            bounds = children[i].getBounds();
            if (manualMove[i]) {
                children[i].setBounds(bounds.x + dx, bounds.y, bounds.width, bounds.height);
            }
            ++i;
        }
        this.getViewport().setIgnoreScroll(true);
        this.getViewport().setHorizontalLocation(hOffset);
        this.getViewport().setIgnoreScroll(false);
        this.redraw(expose.x, expose.y, expose.width, expose.height, true);
    }

    public void scrollToY(SelectionEvent event, int vOffset) {
        org.eclipse.swt.graphics.Rectangle bounds;
        Rectangle diagramBounds;
        if (event == null) {
            return;
        }
        vOffset = this.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), vOffset);
        int vOffsetOld = this.getViewport().getViewLocation().y;
        int dy = -vOffset + vOffsetOld;
        double zoomLevel = this.getZoomLevel();
        if (dy != 0) {
            if (event.detail == 0x1000001 || event.detail == 0x1000002) {
                this.regainVerticalSpace();
            }
        } else if (event.detail == 0x1000001) {
            dy = 0;
            diagramBounds = this.getDiagramBounds();
            vOffset = diagramBounds.y + dy;
            this.topLeftCorner.replace(this.topLeftCorner.getBounds().x, vOffset);
            this.getViewport().getVerticalRangeModel().setAll((int)((double)vOffset * zoomLevel), (int)((double)(diagramBounds.height - Math.abs(dy)) * zoomLevel), this.bottomRightCorner.getBounds().y);
            this.doScroll = false;
        } else if (event.detail == 0x1000002) {
            dy = this.getVerticalBar().getIncrement();
            diagramBounds = this.getDiagramBounds();
            vOffset = diagramBounds.bottom() + dy;
            this.bottomRightCorner.replace(this.bottomRightCorner.getBounds().x, vOffset);
            this.getViewport().getVerticalRangeModel().setAll((int)((double)vOffset * zoomLevel), (int)((double)(diagramBounds.height - Math.abs(dy)) * zoomLevel), this.bottomRightCorner.getBounds().y);
            this.doScroll = false;
        } else {
            return;
        }
        Rectangle clientArea = this.getViewport().getBounds().getCropped(this.getViewport().getInsets());
        Rectangle blit = clientArea.getResized(0, -Math.abs(dy));
        Rectangle expose = clientArea.getCopy();
        Point dest = clientArea.getTopLeft();
        expose.height = Math.abs(dy);
        if (dy < 0) {
            blit.translate(0, -dy);
            expose.y = dest.y + blit.height;
        } else {
            dest.y += dy;
        }
        Control[] children = this.getChildren();
        boolean[] manualMove = new boolean[children.length];
        int i = 0;
        while (i < children.length) {
            bounds = children[i].getBounds();
            manualMove[i] = blit.height <= 0 || bounds.x > blit.x + blit.width || bounds.y > blit.y + blit.height || bounds.x + bounds.width < blit.x || bounds.y + bounds.height < blit.y;
            ++i;
        }
        if (this.doScroll) {
            this.scroll(dest.x, dest.y, blit.x, blit.y, blit.width, blit.height, true);
        }
        this.doScroll = true;
        i = 0;
        while (i < children.length) {
            bounds = children[i].getBounds();
            if (manualMove[i]) {
                children[i].setBounds(bounds.x, bounds.y + dy, bounds.width, bounds.height);
            }
            ++i;
        }
        this.getViewport().setIgnoreScroll(true);
        this.getViewport().setVerticalLocation(vOffset);
        this.getViewport().setIgnoreScroll(false);
        this.redraw(expose.x, expose.y, expose.width, expose.height, true);
    }

    public void regainSpace() {
        this.bottomRightCorner.remove();
        this.topLeftCorner.remove();
        this.setCornerPixels();
    }

    public void regainHorizontalSpace() {
        int topLeftY = this.topLeftCorner.getBounds().y;
        int bottomRightY = this.bottomRightCorner.getBounds().y;
        this.bottomRightCorner.remove();
        this.topLeftCorner.remove();
        Rectangle minimalDiagram = this.getDiagramBoundsFromEditPartChildren();
        Rectangle clientArea = new Rectangle(this.getClientArea());
        double zoomLevel = this.getZoomLevel();
        int newBottomRightX = minimalDiagram.right();
        int newTopLeftX = minimalDiagram.x;
        if ((double)newBottomRightX * zoomLevel <= (double)clientArea.right()) {
            newBottomRightX = (int)((double)clientArea.right() / zoomLevel);
            newTopLeftX = clientArea.x;
        }
        this.bottomRightCorner.set(newBottomRightX, bottomRightY);
        this.topLeftCorner.set(newTopLeftX, topLeftY);
    }

    public void regainVerticalSpace() {
        int topLeftX = this.topLeftCorner.getBounds().x;
        int bottomRightX = this.bottomRightCorner.getBounds().x;
        this.bottomRightCorner.remove();
        this.topLeftCorner.remove();
        Rectangle minimalDiagram = this.getDiagramBoundsFromEditPartChildren();
        Rectangle clientArea = new Rectangle(this.getClientArea());
        double zoomLevel = this.getZoomLevel();
        int newBottomRightY = minimalDiagram.bottom();
        int newTopLeftY = minimalDiagram.y;
        if ((double)newBottomRightY * zoomLevel <= (double)clientArea.bottom()) {
            newBottomRightY = (int)((double)clientArea.bottom() / zoomLevel);
            newTopLeftY = clientArea.y;
        }
        this.bottomRightCorner.set(bottomRightX, newBottomRightY);
        this.topLeftCorner.set(topLeftX, newTopLeftY);
    }

    private double getZoomLevel() {
        return this.diagramEditor.getZoomLevel();
    }

    private Rectangle getDiagramBoundsFromDiagramEditPart() {
        EditPart ep = this.diagramEditor.getContentEditPart();
        if (ep instanceof DiagramEditPart && ((DiagramEditPart)ep).getFigure().getChildren().size() > 0) {
            return ((DiagramEditPart)ep).getFigure().getBounds();
        }
        return new Rectangle(this.getClientArea());
    }

    public Rectangle getDiagramBoundsFromEditPartChildren() {
        EditPart ep = this.diagramEditor.getContentEditPart();
        if (!(ep instanceof DiagramEditPart) || ((DiagramEditPart)ep).getFigure().getChildren().size() == 0) {
            return new Rectangle();
        }
        DiagramEditPart diagramEditPart = (DiagramEditPart)ep;
        List children = diagramEditPart.getFigure().getChildren();
        if (children.size() == 0) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (IFigure child : children) {
            int y2;
            int x2;
            int y1;
            int x1 = child.getBounds().x;
            if (x1 < minX) {
                minX = x1;
            }
            if ((y1 = child.getBounds().y) < minY) {
                minY = y1;
            }
            if ((x2 = x1 + child.getBounds().width) > maxX) {
                maxX = x2;
            }
            if ((y2 = y1 + child.getBounds().height) <= maxY) continue;
            maxY = y2;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    private Rectangle getDiagramBoundsFromCornerPixels() {
        Rectangle rectangle = this.topLeftCorner.getBounds().getCopy();
        return rectangle.union(this.bottomRightCorner.getBounds());
    }

    public void scrollSmoothTo(int x, int y) {
        x = this.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), x);
        y = this.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), y);
        int oldX = this.getViewport().getViewLocation().x;
        int oldY = this.getViewport().getViewLocation().y;
        int dx = x - oldX;
        int dy = y - oldY;
        if (dx == 0 && dy == 0) {
            return;
        }
        Dimension viewingArea = this.getViewport().getClientArea().getSize();
        int minFrames = 3;
        int maxFrames = 6;
        if (dx == 0 || dy == 0) {
            minFrames = 6;
            maxFrames = 13;
        }
        int frames = (Math.abs(dx) + Math.abs(dy)) / 15;
        frames = Math.max(frames, minFrames);
        frames = Math.min(frames, maxFrames);
        int stepX = Math.min(dx / frames, viewingArea.width / 3);
        int stepY = Math.min(dy / frames, viewingArea.height / 3);
        int i = 1;
        while (i < frames) {
            this.scrollTo(oldX + i * stepX, oldY + i * stepY);
            this.getViewport().getUpdateManager().performUpdate();
            ++i;
        }
        this.scrollTo(x, y);
    }

    public void scrollTo(int x, int y) {
        x = this.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), x);
        y = this.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), y);
        if (x == this.getViewport().getViewLocation().x) {
            this.scrollToY(null, y);
        } else if (y == this.getViewport().getViewLocation().y) {
            this.scrollToX(null, x);
        } else {
            this.getViewport().setViewLocation(x, y);
        }
    }

    public void setBorder(Border border) {
        this.getLightweightSystem().getRootFigure().setBorder(border);
    }

    public void setContents(IFigure figure) {
        this.getViewport().setContents(figure);
    }

    public void setFont(Font font) {
        this.font = font;
        super.setFont(font);
    }

    public void setHorizontalScrollBarVisibility(int v) {
        this.hBarVisibility = v;
    }

    public void setScrollBarVisibility(int both) {
        this.setHorizontalScrollBarVisibility(both);
        this.setVerticalScrollBarVisibility(both);
    }

    public void setVerticalScrollBarVisibility(int v) {
        this.vBarVisibility = v;
    }

    public void setViewport(Viewport vp) {
        if (this.viewport != null) {
            this.unhookViewport();
        }
        this.viewport = vp;
        this.lws.setContents((IFigure)this.viewport);
        this.hookViewport();
    }

    private int verifyScrollBarOffset(RangeModel model, int value) {
        value = Math.max(model.getMinimum(), value);
        return Math.min(model.getMaximum() - model.getExtent(), value);
    }

    public void removeCornerPixels() {
        if (this.bottomRightCorner != null) {
            this.bottomRightCorner.remove();
        }
        if (this.topLeftCorner != null) {
            this.topLeftCorner.remove();
        }
    }

    public void setCornerPixels() {
        Rectangle minimalDiagram = this.getDiagramBoundsFromEditPartChildren();
        Rectangle clientArea = new Rectangle(this.getClientArea());
        minimalDiagram.union(clientArea);
        this.bottomRightCorner.set(minimalDiagram.right(), minimalDiagram.bottom());
        this.topLeftCorner.set(minimalDiagram.x, minimalDiagram.y);
    }

    public Object getAdapter(Class adapter) {
        if (LightweightSystem.class == adapter) {
            return this.getLightweightSystem();
        }
        return null;
    }

    class GFUpdateListener
    implements UpdateListener {
        GFUpdateListener() {
        }

        public void notifyPainting(Rectangle damage, Map dirtyRegions) {
        }

        public void notifyValidating() {
            if (!GFFigureCanvas.this.isDisposed()) {
                GFFigureCanvas.this.layoutViewport();
            }
        }
    }

    class Pixel
    extends Figure {
        private static final int SIZE = 5;

        Pixel() {
        }

        protected void set(int newX, int newY) {
            this.setBounds(new Rectangle(newX, newY, 5, 5));
            this.setOpaque(false);
            EditPart ep = GFFigureCanvas.this.diagramEditor.getContentEditPart();
            ((DiagramEditPart)ep).getFigure().add((IFigure)this);
        }

        protected void replace(int newX, int newY) {
            this.remove();
            this.set(newX, newY);
        }

        protected void remove() {
            EditPart ep = GFFigureCanvas.this.diagramEditor.getContentEditPart();
            IFigure diagram = ((DiagramEditPart)ep).getFigure();
            diagram.getChildren().remove((Object)this);
        }

        protected int getSizeInPixel() {
            return 5;
        }
    }
}

