/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.net4j.internal.tcp.SelectorUtil;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.tcp.ITCPActiveSelectorListener;
import org.eclipse.net4j.tcp.ITCPPassiveSelectorListener;
import org.eclipse.net4j.tcp.ITCPSelector;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class TCPSelector
extends Lifecycle
implements ITCPSelector,
Runnable {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, TCPSelector.class);
    private Selector selector;
    private transient Queue<Runnable> clientOperations = new ConcurrentLinkedQueue<Runnable>();
    private transient Queue<Runnable> serverOperations = new ConcurrentLinkedQueue<Runnable>();
    private transient Thread thread;
    private transient boolean running;

    public Selector getSocketSelector() {
        return this.selector;
    }

    public void orderRegistration(final ServerSocketChannel channel, final ITCPPassiveSelectorListener listener) {
        this.assertValidListener(listener);
        this.order(false, new Runnable(){

            public void run() {
                TCPSelector.this.executeRegistration(channel, listener);
            }

            public String toString() {
                return "REGISTER " + channel;
            }
        });
    }

    public void orderRegistration(final SocketChannel channel, final boolean client, final ITCPActiveSelectorListener listener) {
        this.assertValidListener(listener);
        this.order(client, new Runnable(){

            public void run() {
                TCPSelector.this.executeRegistration(channel, listener, client);
            }

            public String toString() {
                return "REGISTER " + channel;
            }
        });
    }

    public void orderConnectInterest(final SelectionKey selectionKey, boolean client, final boolean on) {
        this.order(client, new Runnable(){

            public void run() {
                SelectorUtil.setConnectInterest(selectionKey, on);
            }

            public String toString() {
                return "INTEREST CONNECT " + selectionKey.channel() + " = " + on;
            }
        });
    }

    public void orderReadInterest(final SelectionKey selectionKey, boolean client, final boolean on) {
        this.order(client, new Runnable(){

            public void run() {
                SelectorUtil.setReadInterest(selectionKey, on);
            }

            public String toString() {
                return "INTEREST READ " + selectionKey.channel() + " = " + on;
            }
        });
    }

    public void orderWriteInterest(final SelectionKey selectionKey, boolean client, final boolean on) {
        this.order(client, new Runnable(){

            public void run() {
                SelectorUtil.setWriteInterest(selectionKey, on);
            }

            public String toString() {
                return "INTEREST WRITE " + selectionKey.channel() + " = " + on;
            }
        });
    }

    public void run() {
        while (this.running && !Thread.interrupted()) {
            try {
                this.processOperations(false);
                this.processOperations(true);
                if (this.selector == null || this.selector.select() <= 0) continue;
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SelectionKey selKey = it.next();
                    it.remove();
                    try {
                        this.handleSelection(selKey);
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (Exception ex) {
                        OM.LOG.info(ex.getMessage());
                        selKey.cancel();
                    }
                }
            }
            catch (NullPointerException ex) {
                break;
            }
            catch (ClosedSelectorException ex) {
                break;
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                break;
            }
        }
        this.deactivate();
    }

    public String toString() {
        return "TCPSelector";
    }

    protected void handleSelection(SelectionKey selKey) throws IOException {
        SelectableChannel channel = selKey.channel();
        if (channel instanceof ServerSocketChannel) {
            ServerSocketChannel ssChannel = (ServerSocketChannel)selKey.channel();
            if (ssChannel.isOpen()) {
                ITCPPassiveSelectorListener listener = (ITCPPassiveSelectorListener)selKey.attachment();
                if (selKey.isAcceptable()) {
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Accepting " + ssChannel);
                    }
                    listener.handleAccept(this, ssChannel);
                }
            }
        } else if (channel instanceof SocketChannel) {
            SocketChannel sChannel = (SocketChannel)channel;
            ITCPActiveSelectorListener listener = (ITCPActiveSelectorListener)selKey.attachment();
            if (selKey.isConnectable()) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Connecting " + sChannel);
                }
                listener.handleConnect(this, sChannel);
            }
            if (selKey.isReadable()) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Reading " + sChannel);
                }
                listener.handleRead(this, sChannel);
            }
            if (selKey.isWritable()) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Writing " + sChannel);
                }
                listener.handleWrite(this, sChannel);
            }
        }
    }

    protected Selector openSelector() throws IOException {
        return Selector.open();
    }

    protected void closeSelector() throws IOException {
        this.selector.close();
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.running = true;
        this.selector = this.openSelector();
        this.thread = new Thread((Runnable)this, "TCPSelector");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void doDeactivate() throws Exception {
        Exception exception;
        block13: {
            block11: {
                this.running = false;
                this.selector.wakeup();
                exception = null;
                try {
                    try {
                        this.thread.join(200L);
                    }
                    catch (RuntimeException ex) {
                        exception = ex;
                        this.thread = null;
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    this.thread = null;
                    throw throwable;
                }
                this.thread = null;
            }
            try {
                try {
                    this.closeSelector();
                }
                catch (Exception ex) {
                    if (exception == null) {
                        exception = ex;
                    }
                    this.selector = null;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.selector = null;
                throw throwable;
            }
            this.selector = null;
        }
        super.doDeactivate();
        if (exception != null) {
            throw exception;
        }
    }

    private void assertValidListener(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener == null");
        }
    }

    private void order(boolean client, Runnable operation) {
        if (TRACER.isEnabled()) {
            TRACER.format("Ordering {0} operation {1}", new Object[]{client ? "client" : "server", operation});
        }
        if (client) {
            this.clientOperations.add(operation);
        } else {
            this.serverOperations.add(operation);
        }
        if (this.selector != null) {
            this.selector.wakeup();
        }
    }

    private void processOperations(boolean client) {
        Runnable operation;
        Queue<Runnable> operations = client ? this.clientOperations : this.serverOperations;
        while ((operation = operations.poll()) != null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Executing {0} operation {1}", new Object[]{client ? "client" : "server", operation});
            }
            operation.run();
        }
    }

    private void executeRegistration(ServerSocketChannel channel, ITCPPassiveSelectorListener listener) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Registering " + channel);
        }
        try {
            listener.handleRegistration(this, channel);
        }
        catch (Exception ex) {
            OM.LOG.debug((Throwable)ex);
        }
    }

    private void executeRegistration(SocketChannel channel, ITCPActiveSelectorListener listener, boolean client) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Registering " + channel);
        }
        try {
            listener.handleRegistration(this, channel);
        }
        catch (Exception ex) {
            OM.LOG.debug((Throwable)ex);
        }
    }
}

