/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.creator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualTreeBidiMap;
import org.apache.commons.io.IOUtils;
import org.apache.maven.archetype.ArchetypeCreationRequest;
import org.apache.maven.archetype.ArchetypeCreationResult;
import org.apache.maven.archetype.common.ArchetypeFilesResolver;
import org.apache.maven.archetype.common.PomManager;
import org.apache.maven.archetype.common.util.FileCharsetDetector;
import org.apache.maven.archetype.common.util.ListScanner;
import org.apache.maven.archetype.common.util.PathUtils;
import org.apache.maven.archetype.creator.ArchetypeCreator;
import org.apache.maven.archetype.creator.olddescriptor.OldArchetypeDescriptor;
import org.apache.maven.archetype.creator.olddescriptor.OldArchetypeDescriptorXpp3Writer;
import org.apache.maven.archetype.exception.TemplateCreationException;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.FileSet;
import org.apache.maven.archetype.metadata.ModuleDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.maven.archetype.metadata.io.xpp3.ArchetypeDescriptorXpp3Writer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class FilesetArchetypeCreator
extends AbstractLogEnabled
implements ArchetypeCreator {
    private ArchetypeFilesResolver archetypeFilesResolver;
    private PomManager pomManager;
    private MavenProjectBuilder projectBuilder;
    private int id = 0;
    private BidiMap registeredProjects = new DualTreeBidiMap();
    private static final String MAVEN_PROPERTIES = "META-INF/maven/org.apache.maven.archetype/archetype-common/pom.properties";

    public void createArchetype(ArchetypeCreationRequest request, ArchetypeCreationResult result) {
        MavenProject project = request.getProject();
        List languages = request.getLanguages();
        List filtereds = request.getFiltereds();
        String defaultEncoding = request.getDefaultEncoding();
        boolean preserveCData = request.isPreserveCData();
        boolean keepParent = request.isKeepParent();
        boolean partialArchetype = request.isPartialArchetype();
        ArtifactRepository localRepository = request.getLocalRepository();
        Properties properties = new Properties();
        Properties configurationProperties = new Properties();
        if (request.getProperties() != null) {
            properties.putAll((Map<?, ?>)request.getProperties());
            configurationProperties.putAll((Map<?, ?>)request.getProperties());
        }
        if (!properties.containsKey("groupId")) {
            properties.setProperty("groupId", project.getGroupId());
        }
        configurationProperties.setProperty("groupId", properties.getProperty("groupId"));
        if (!properties.containsKey("artifactId")) {
            properties.setProperty("artifactId", project.getArtifactId());
        }
        configurationProperties.setProperty("artifactId", properties.getProperty("artifactId"));
        if (!properties.containsKey("version")) {
            properties.setProperty("version", project.getVersion());
        }
        configurationProperties.setProperty("version", properties.getProperty("version"));
        if (request.getPackageName() != null) {
            properties.setProperty("package", request.getPackageName());
        } else if (!properties.containsKey("package")) {
            properties.setProperty("package", project.getGroupId());
        }
        configurationProperties.setProperty("package", properties.getProperty("package"));
        File basedir = project.getBasedir();
        File generatedSourcesDirectory = FileUtils.resolveFile((File)basedir, (String)this.getGeneratedSourcesDirectory());
        generatedSourcesDirectory.mkdirs();
        this.getLogger().debug("Creating archetype in " + generatedSourcesDirectory);
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(configurationProperties.getProperty("archetype.groupId", project.getGroupId()));
        model.setArtifactId(configurationProperties.getProperty("archetype.artifactId", project.getArtifactId()));
        model.setVersion(configurationProperties.getProperty("archetype.version", project.getVersion()));
        model.setPackaging("maven-archetype");
        model.setName(configurationProperties.getProperty("archetype.artifactId", project.getArtifactId()));
        Build build = new Build();
        model.setBuild(build);
        if (project.getParent() != null) {
            Artifact pa = project.getParentArtifact();
            try {
                MavenProject p = this.projectBuilder.buildFromRepository(pa, project.getRemoteArtifactRepositories(), localRepository);
                if (p.getDistributionManagement() != null) {
                    model.setDistributionManagement(p.getDistributionManagement());
                }
                if (p.getBuildExtensions() != null) {
                    Iterator i = p.getBuildExtensions().iterator();
                    while (i.hasNext()) {
                        Extension be = (Extension)i.next();
                        model.getBuild().addExtension(be);
                    }
                }
            }
            catch (ProjectBuildingException e) {
                result.setCause(new TemplateCreationException("Error reading parent POM of project: " + pa.getGroupId() + ":" + pa.getArtifactId() + ":" + pa.getVersion()));
                return;
            }
        }
        Extension extension = new Extension();
        extension.setGroupId("org.apache.maven.archetype");
        extension.setArtifactId("archetype-packaging");
        extension.setVersion(this.getArchetypeVersion());
        model.getBuild().addExtension(extension);
        Plugin plugin = new Plugin();
        plugin.setGroupId("org.apache.maven.plugins");
        plugin.setArtifactId("maven-archetype-plugin");
        plugin.setVersion(this.getArchetypeVersion());
        plugin.setExtensions(true);
        model.getBuild().addPlugin(plugin);
        this.getLogger().debug("Creating archetype's pom");
        File archetypePomFile = FileUtils.resolveFile((File)basedir, (String)this.getArchetypePom());
        archetypePomFile.getParentFile().mkdirs();
        try {
            this.pomManager.writePom(model, archetypePomFile, archetypePomFile);
        }
        catch (IOException e) {
            result.setCause(e);
        }
        File archetypeResourcesDirectory = FileUtils.resolveFile((File)generatedSourcesDirectory, (String)this.getTemplateOutputDirectory());
        archetypeResourcesDirectory.mkdirs();
        File archetypeFilesDirectory = FileUtils.resolveFile((File)archetypeResourcesDirectory, (String)"archetype-resources");
        archetypeFilesDirectory.mkdirs();
        this.getLogger().debug("Archetype's files output directory " + archetypeFilesDirectory);
        File archetypeDescriptorFile = FileUtils.resolveFile((File)archetypeResourcesDirectory, (String)"META-INF/maven/archetype-metadata.xml");
        archetypeDescriptorFile.getParentFile().mkdirs();
        ArchetypeDescriptor archetypeDescriptor = new ArchetypeDescriptor();
        archetypeDescriptor.setName(project.getArtifactId());
        this.getLogger().debug("Starting archetype's descriptor " + project.getArtifactId());
        archetypeDescriptor.setPartial(partialArchetype);
        this.addRequiredProperties(archetypeDescriptor, properties);
        Properties reverseProperties = this.getRequiredProperties(archetypeDescriptor, properties);
        reverseProperties.remove("groupId");
        Properties pomReversedProperties = this.getRequiredProperties(archetypeDescriptor, properties);
        pomReversedProperties.remove("package");
        String packageName = configurationProperties.getProperty("package");
        try {
            Model pom = this.pomManager.readPom(FileUtils.resolveFile((File)basedir, (String)"pom.xml"));
            this.registerProject(pom);
            List fileNames = this.resolveFileNames(pom, basedir);
            this.getLogger().debug("Scanned for files " + fileNames.size());
            Iterator names = fileNames.iterator();
            while (names.hasNext()) {
                this.getLogger().debug("- " + names.next().toString());
            }
            List filesets = this.resolveFileSets(packageName, fileNames, languages, filtereds, defaultEncoding);
            this.getLogger().debug("Resolved filesets for " + archetypeDescriptor.getName());
            archetypeDescriptor.setFileSets(filesets);
            this.createArchetypeFiles(reverseProperties, filesets, packageName, basedir, archetypeFilesDirectory, defaultEncoding);
            this.getLogger().debug("Created files for " + archetypeDescriptor.getName());
            this.setParentArtifactId(reverseProperties, configurationProperties.getProperty("artifactId"));
            Iterator modules = pom.getModules().iterator();
            while (modules.hasNext()) {
                String moduleId = (String)modules.next();
                String rootArtifactId = configurationProperties.getProperty("artifactId");
                String moduleIdDirectory = moduleId;
                if (moduleId.indexOf(rootArtifactId) >= 0) {
                    moduleIdDirectory = StringUtils.replace((String)moduleId, (String)rootArtifactId, (String)"__rootArtifactId__");
                }
                this.getLogger().debug("Creating module " + moduleId);
                ModuleDescriptor moduleDescriptor = this.createModule(reverseProperties, rootArtifactId, moduleId, packageName, FileUtils.resolveFile((File)basedir, (String)moduleId), FileUtils.resolveFile((File)archetypeFilesDirectory, (String)moduleIdDirectory), languages, filtereds, defaultEncoding, preserveCData, keepParent);
                archetypeDescriptor.addModule(moduleDescriptor);
                this.getLogger().debug("Added module " + moduleDescriptor.getName() + " in " + archetypeDescriptor.getName());
            }
            this.restoreParentArtifactId(reverseProperties, null);
            this.restoreArtifactId(reverseProperties, configurationProperties.getProperty("artifactId"));
            this.createPoms(pom, configurationProperties.getProperty("artifactId"), configurationProperties.getProperty("artifactId"), archetypeFilesDirectory, basedir, pomReversedProperties, preserveCData, keepParent);
            this.getLogger().debug("Created Archetype " + archetypeDescriptor.getName() + " pom");
            ArchetypeDescriptorXpp3Writer writer = new ArchetypeDescriptorXpp3Writer();
            writer.write(new FileWriter(archetypeDescriptorFile), archetypeDescriptor);
            this.getLogger().debug("Archetype " + archetypeDescriptor.getName() + " descriptor written");
            OldArchetypeDescriptor oldDescriptor = this.convertToOldDescriptor(archetypeDescriptor.getName(), packageName, basedir);
            File oldDescriptorFile = FileUtils.resolveFile((File)archetypeResourcesDirectory, (String)"META-INF/maven/archetype.xml");
            archetypeDescriptorFile.getParentFile().mkdirs();
            this.writeOldDescriptor(oldDescriptor, oldDescriptorFile);
            this.getLogger().debug("Archetype " + archetypeDescriptor.getName() + " old descriptor written");
        }
        catch (Exception e) {
            result.setCause(e);
        }
    }

    private void addRequiredProperties(ArchetypeDescriptor archetypeDescriptor, Properties properties) {
        Properties requiredProperties = new Properties();
        requiredProperties.putAll((Map<?, ?>)properties);
        requiredProperties.remove("archetype.groupId");
        requiredProperties.remove("archetype.artifactId");
        requiredProperties.remove("archetype.version");
        requiredProperties.remove("groupId");
        requiredProperties.remove("artifactId");
        requiredProperties.remove("version");
        requiredProperties.remove("package");
        Iterator<Object> propertiesIterator = requiredProperties.keySet().iterator();
        while (propertiesIterator.hasNext()) {
            String propertyKey = (String)propertiesIterator.next();
            RequiredProperty requiredProperty = new RequiredProperty();
            requiredProperty.setKey(propertyKey);
            requiredProperty.setDefaultValue(requiredProperties.getProperty(propertyKey));
            archetypeDescriptor.addRequiredProperty(requiredProperty);
            this.getLogger().debug("Adding requiredProperty " + propertyKey + "=" + requiredProperties.getProperty(propertyKey) + " to archetype's descriptor");
        }
    }

    private void createModulePoms(Properties pomReversedProperties, String rootArtifactId, String packageName, File basedir, File archetypeFilesDirectory, boolean preserveCData, boolean keepParent) throws FileNotFoundException, IOException, XmlPullParserException {
        Model pom = this.pomManager.readPom(FileUtils.resolveFile((File)basedir, (String)"pom.xml"));
        String parentArtifactId = pomReversedProperties.getProperty("parentArtifactId");
        String artifactId = pom.getArtifactId();
        this.setParentArtifactId(pomReversedProperties, pomReversedProperties.getProperty("artifactId"));
        this.setArtifactId(pomReversedProperties, pom.getArtifactId());
        Iterator modules = pom.getModules().iterator();
        while (modules.hasNext()) {
            String subModuleId;
            String subModuleIdDirectory = subModuleId = (String)modules.next();
            if (subModuleId.indexOf(rootArtifactId) >= 0) {
                subModuleIdDirectory = StringUtils.replace((String)subModuleId, (String)rootArtifactId, (String)"__rootArtifactId__");
            }
            this.createModulePoms(pomReversedProperties, rootArtifactId, packageName, FileUtils.resolveFile((File)basedir, (String)subModuleId), FileUtils.resolveFile((File)archetypeFilesDirectory, (String)subModuleIdDirectory), preserveCData, keepParent);
        }
        this.createModulePom(pom, rootArtifactId, archetypeFilesDirectory, pomReversedProperties, FileUtils.resolveFile((File)basedir, (String)"pom.xml"), preserveCData, keepParent);
        this.restoreParentArtifactId(pomReversedProperties, parentArtifactId);
        this.restoreArtifactId(pomReversedProperties, artifactId);
    }

    private void createPoms(Model pom, String rootArtifactId, String artifactId, File archetypeFilesDirectory, File basedir, Properties pomReversedProperties, boolean preserveCData, boolean keepParent) throws IOException, FileNotFoundException, XmlPullParserException {
        this.setArtifactId(pomReversedProperties, pom.getArtifactId());
        Iterator modules = pom.getModules().iterator();
        while (modules.hasNext()) {
            String moduleId;
            String moduleIdDirectory = moduleId = (String)modules.next();
            if (moduleId.indexOf(rootArtifactId) >= 0) {
                moduleIdDirectory = StringUtils.replace((String)moduleId, (String)rootArtifactId, (String)"__rootArtifactId__");
            }
            this.createModulePoms(pomReversedProperties, rootArtifactId, moduleId, FileUtils.resolveFile((File)basedir, (String)moduleId), FileUtils.resolveFile((File)archetypeFilesDirectory, (String)moduleIdDirectory), preserveCData, keepParent);
        }
        this.restoreParentArtifactId(pomReversedProperties, null);
        this.restoreArtifactId(pomReversedProperties, artifactId);
        this.createArchetypePom(pom, archetypeFilesDirectory, pomReversedProperties, FileUtils.resolveFile((File)basedir, (String)"pom.xml"), preserveCData, keepParent);
    }

    private String getArchetypePom() {
        return this.getGeneratedSourcesDirectory() + File.separator + "pom.xml";
    }

    private String getPackageInPathFormat(String aPackage) {
        return StringUtils.replace((String)aPackage, (String)".", (String)"/");
    }

    private void registerProject(Model pom) {
        this.registeredProjects.put((Object)new Integer(this.id++), (Object)pom.getId());
    }

    private void rewriteReferences(Model pom, String rootArtifactId, String groupId) {
        Plugin plugin;
        Iterator plugins;
        Dependency dependency;
        Iterator dependencies;
        if (pom.getDependencies() != null && !pom.getDependencies().isEmpty()) {
            dependencies = pom.getDependencies().iterator();
            while (dependencies.hasNext()) {
                dependency = (Dependency)dependencies.next();
                if (dependency.getArtifactId() == null || dependency.getArtifactId().indexOf(rootArtifactId) < 0) continue;
                if (dependency.getGroupId() != null) {
                    dependency.setGroupId(StringUtils.replace((String)dependency.getGroupId(), (String)groupId, (String)"${groupId}"));
                }
                dependency.setArtifactId(StringUtils.replace((String)dependency.getArtifactId(), (String)rootArtifactId, (String)"${rootArtifactId}"));
                if (dependency.getVersion() == null) continue;
                dependency.setVersion("${version}");
            }
        }
        if (pom.getDependencyManagement() != null && pom.getDependencyManagement().getDependencies() != null && !pom.getDependencyManagement().getDependencies().isEmpty()) {
            dependencies = pom.getDependencyManagement().getDependencies().iterator();
            while (dependencies.hasNext()) {
                dependency = (Dependency)dependencies.next();
                if (dependency.getArtifactId() == null || dependency.getArtifactId().indexOf(rootArtifactId) < 0) continue;
                if (dependency.getGroupId() != null) {
                    dependency.setGroupId(StringUtils.replace((String)dependency.getGroupId(), (String)groupId, (String)"${groupId}"));
                }
                dependency.setArtifactId(StringUtils.replace((String)dependency.getArtifactId(), (String)rootArtifactId, (String)"${rootArtifactId}"));
                if (dependency.getVersion() == null) continue;
                dependency.setVersion("${version}");
            }
        }
        if (pom.getBuild() != null && pom.getBuild().getPlugins() != null && !pom.getBuild().getPlugins().isEmpty()) {
            plugins = pom.getBuild().getPlugins().iterator();
            while (plugins.hasNext()) {
                plugin = (Plugin)plugins.next();
                if (plugin.getArtifactId() == null || plugin.getArtifactId().indexOf(rootArtifactId) < 0) continue;
                if (plugin.getGroupId() != null) {
                    plugin.setGroupId(StringUtils.replace((String)plugin.getGroupId(), (String)groupId, (String)"${groupId}"));
                }
                plugin.setArtifactId(StringUtils.replace((String)plugin.getArtifactId(), (String)rootArtifactId, (String)"${rootArtifactId}"));
                if (plugin.getVersion() == null) continue;
                plugin.setVersion("${version}");
            }
        }
        if (pom.getBuild() != null && pom.getBuild().getPluginManagement() != null && pom.getBuild().getPluginManagement().getPlugins() != null && !pom.getBuild().getPluginManagement().getPlugins().isEmpty()) {
            plugins = pom.getBuild().getPluginManagement().getPlugins().iterator();
            while (plugins.hasNext()) {
                plugin = (Plugin)plugins.next();
                if (plugin.getArtifactId() == null || plugin.getArtifactId().indexOf(rootArtifactId) < 0) continue;
                if (plugin.getGroupId() != null) {
                    plugin.setGroupId(StringUtils.replace((String)plugin.getGroupId(), (String)groupId, (String)"${groupId}"));
                }
                plugin.setArtifactId(StringUtils.replace((String)plugin.getArtifactId(), (String)rootArtifactId, (String)"${rootArtifactId}"));
                if (plugin.getVersion() == null) continue;
                plugin.setVersion("${version}");
            }
        }
        if (pom.getProfiles() != null) {
            Iterator profiles = pom.getProfiles().iterator();
            while (profiles.hasNext()) {
                Plugin plugin2;
                Iterator plugins2;
                Dependency dependency2;
                Iterator dependencies2;
                Profile profile = (Profile)profiles.next();
                if (profile.getDependencies() != null && !profile.getDependencies().isEmpty()) {
                    dependencies2 = profile.getDependencies().iterator();
                    while (dependencies2.hasNext()) {
                        dependency2 = (Dependency)dependencies2.next();
                        if (dependency2.getArtifactId() == null || dependency2.getArtifactId().indexOf(rootArtifactId) < 0) continue;
                        if (dependency2.getGroupId() != null) {
                            dependency2.setGroupId(StringUtils.replace((String)dependency2.getGroupId(), (String)groupId, (String)"${groupId}"));
                        }
                        dependency2.setArtifactId(StringUtils.replace((String)dependency2.getArtifactId(), (String)rootArtifactId, (String)"${rootArtifactId}"));
                        if (dependency2.getVersion() == null) continue;
                        dependency2.setVersion("${version}");
                    }
                }
                if (profile.getDependencyManagement() != null && profile.getDependencyManagement().getDependencies() != null && !profile.getDependencyManagement().getDependencies().isEmpty()) {
                    dependencies2 = profile.getDependencyManagement().getDependencies().iterator();
                    while (dependencies2.hasNext()) {
                        dependency2 = (Dependency)dependencies2.next();
                        if (dependency2.getArtifactId() == null || dependency2.getArtifactId().indexOf(rootArtifactId) < 0) continue;
                        if (dependency2.getGroupId() != null) {
                            dependency2.setGroupId(StringUtils.replace((String)dependency2.getGroupId(), (String)groupId, (String)"${groupId}"));
                        }
                        dependency2.setArtifactId(StringUtils.replace((String)dependency2.getArtifactId(), (String)rootArtifactId, (String)"${rootArtifactId}"));
                        if (dependency2.getVersion() == null) continue;
                        dependency2.setVersion("${version}");
                    }
                }
                if (profile.getBuild() != null && profile.getBuild().getPlugins() != null && !profile.getBuild().getPlugins().isEmpty()) {
                    plugins2 = profile.getBuild().getPlugins().iterator();
                    while (plugins2.hasNext()) {
                        plugin2 = (Plugin)plugins2.next();
                        if (plugin2.getArtifactId() == null || plugin2.getArtifactId().indexOf(rootArtifactId) < 0) continue;
                        if (plugin2.getGroupId() != null) {
                            plugin2.setGroupId(StringUtils.replace((String)plugin2.getGroupId(), (String)groupId, (String)"${groupId}"));
                        }
                        plugin2.setArtifactId(StringUtils.replace((String)plugin2.getArtifactId(), (String)rootArtifactId, (String)"${rootArtifactId}"));
                        if (plugin2.getVersion() == null) continue;
                        plugin2.setVersion("${version}");
                    }
                }
                if (profile.getBuild() == null || profile.getBuild().getPluginManagement() == null || profile.getBuild().getPluginManagement().getPlugins() == null || profile.getBuild().getPluginManagement().getPlugins().isEmpty()) continue;
                plugins2 = profile.getBuild().getPluginManagement().getPlugins().iterator();
                while (plugins2.hasNext()) {
                    plugin2 = (Plugin)plugins2.next();
                    if (plugin2.getArtifactId() == null || plugin2.getArtifactId().indexOf(rootArtifactId) < 0) continue;
                    if (plugin2.getGroupId() != null) {
                        plugin2.setGroupId(StringUtils.replace((String)plugin2.getGroupId(), (String)groupId, (String)"${groupId}"));
                    }
                    plugin2.setArtifactId(StringUtils.replace((String)plugin2.getArtifactId(), (String)rootArtifactId, (String)"${rootArtifactId}"));
                    if (plugin2.getVersion() == null) continue;
                    plugin2.setVersion("${version}");
                }
            }
        }
    }

    private void setArtifactId(Properties properties, String artifactId) {
        properties.setProperty("artifactId", artifactId);
    }

    private List concatenateToList(List toConcatenate, String with) {
        ArrayList<String> result = new ArrayList<String>(toConcatenate.size());
        Iterator iterator = toConcatenate.iterator();
        while (iterator.hasNext()) {
            String concatenate = (String)iterator.next();
            result.add(with.length() > 0 ? with + "/" + concatenate : concatenate);
        }
        return result;
    }

    private OldArchetypeDescriptor convertToOldDescriptor(String id, String packageName, File basedir) throws IOException {
        this.getLogger().debug("Resolving OldArchetypeDescriptor files in " + basedir);
        String excludes = "pom.xml,archetype.properties*,**/target/**";
        Iterator<String> defaultExcludes = Arrays.asList(ListScanner.DEFAULTEXCLUDES).iterator();
        while (defaultExcludes.hasNext()) {
            excludes = excludes + "," + defaultExcludes.next() + "/**";
        }
        List fileNames = FileUtils.getFileNames((File)basedir, (String)"**", (String)excludes, (boolean)false);
        this.getLogger().debug("Resolved " + fileNames.size() + " files");
        String packageAsDirectory = StringUtils.replace((String)packageName, (char)'.', (char)'/') + "/";
        List sources = this.archetypeFilesResolver.findSourcesMainFiles(fileNames, "java/**");
        fileNames.removeAll(sources);
        sources = this.removePackage(sources, packageAsDirectory);
        List testSources = this.archetypeFilesResolver.findSourcesTestFiles(fileNames, "java/**");
        fileNames.removeAll(testSources);
        testSources = this.removePackage(testSources, packageAsDirectory);
        List resources = this.archetypeFilesResolver.findResourcesMainFiles(fileNames, "java/**");
        fileNames.removeAll(resources);
        List testResources = this.archetypeFilesResolver.findResourcesTestFiles(fileNames, "java/**");
        fileNames.removeAll(testResources);
        List siteResources = this.archetypeFilesResolver.findSiteFiles(fileNames, null);
        fileNames.removeAll(siteResources);
        resources.addAll(fileNames);
        OldArchetypeDescriptor descriptor = new OldArchetypeDescriptor();
        descriptor.setId(id);
        descriptor.setSources(sources);
        descriptor.setTestSources(testSources);
        descriptor.setResources(resources);
        descriptor.setTestResources(testResources);
        descriptor.setSiteResources(siteResources);
        return descriptor;
    }

    private void copyFiles(File basedir, File archetypeFilesDirectory, String directory, List fileSetResources, boolean packaged, String packageName) throws IOException {
        String packageAsDirectory = StringUtils.replace((String)packageName, (String)".", (String)File.separator);
        this.getLogger().debug("Package as Directory: Package:" + packageName + "->" + packageAsDirectory);
        Iterator iterator = fileSetResources.iterator();
        while (iterator.hasNext()) {
            String inputFileName = (String)iterator.next();
            String outputFileName = packaged ? StringUtils.replace((String)inputFileName, (String)(packageAsDirectory + File.separator), (String)"") : inputFileName;
            this.getLogger().debug("InputFileName:" + inputFileName);
            this.getLogger().debug("OutputFileName:" + outputFileName);
            File outputFile = new File(archetypeFilesDirectory, outputFileName);
            File inputFile = new File(basedir, inputFileName);
            outputFile.getParentFile().mkdirs();
            FileUtils.copyFile((File)inputFile, (File)outputFile);
        }
    }

    private void copyPom(File basedir, File replicaFilesDirectory) throws IOException {
        FileUtils.copyFileToDirectory((File)new File(basedir, "pom.xml"), (File)replicaFilesDirectory);
    }

    private void createArchetypeFiles(Properties reverseProperties, List fileSets, String packageName, File basedir, File archetypeFilesDirectory, String defaultEncoding) throws IOException {
        this.getLogger().debug("Creating Archetype/Module files from " + basedir + " to " + archetypeFilesDirectory);
        Iterator iterator = fileSets.iterator();
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(basedir);
            scanner.setIncludes(this.concatenateToList(fileSet.getIncludes(), fileSet.getDirectory()).toArray(new String[fileSet.getIncludes().size()]));
            scanner.setExcludes(fileSet.getExcludes().toArray(new String[fileSet.getExcludes().size()]));
            scanner.addDefaultExcludes();
            this.getLogger().debug("Using fileset " + fileSet);
            scanner.scan();
            List<String> fileSetResources = Arrays.asList(scanner.getIncludedFiles());
            this.getLogger().debug("Scanned " + fileSetResources.size() + " resources");
            if (fileSet.isFiltered()) {
                this.processFileSet(basedir, archetypeFilesDirectory, fileSet.getDirectory(), fileSetResources, fileSet.isPackaged(), packageName, reverseProperties, defaultEncoding);
                this.getLogger().debug("Processed " + fileSet.getDirectory() + " files");
                continue;
            }
            this.copyFiles(basedir, archetypeFilesDirectory, fileSet.getDirectory(), fileSetResources, fileSet.isPackaged(), packageName);
            this.getLogger().debug("Copied " + fileSet.getDirectory() + " files");
        }
    }

    private void createArchetypePom(Model pom, File archetypeFilesDirectory, Properties pomReversedProperties, File initialPomFile, boolean preserveCData, boolean keepParent) throws IOException {
        File outputFile = FileUtils.resolveFile((File)archetypeFilesDirectory, (String)"pom.xml");
        if (preserveCData) {
            this.getLogger().debug("Preserving CDATA parts of pom");
            File inputFile = FileUtils.resolveFile((File)archetypeFilesDirectory, (String)"pom.xml.tmp");
            FileUtils.copyFile((File)initialPomFile, (File)inputFile);
            String initialcontent = FileUtils.fileRead((File)inputFile);
            String content = this.getReversedContent(initialcontent, pomReversedProperties);
            outputFile.getParentFile().mkdirs();
            FileUtils.fileWrite((String)outputFile.getAbsolutePath(), (String)content);
            inputFile.delete();
        } else {
            if (!keepParent) {
                pom.setParent(null);
            }
            pom.setModules(null);
            pom.setGroupId("${groupId}");
            pom.setArtifactId("${artifactId}");
            if (pom.getVersion() != null) {
                pom.setVersion("${version}");
            }
            this.rewriteReferences(pom, pomReversedProperties.getProperty("artifactId"), pomReversedProperties.getProperty("groupId"));
            this.pomManager.writePom(pom, outputFile, initialPomFile);
        }
        String initialcontent = FileUtils.fileRead((File)initialPomFile);
        Iterator<Object> properties = pomReversedProperties.keySet().iterator();
        while (properties.hasNext()) {
            String property = (String)properties.next();
            if (initialcontent.indexOf("${" + property + "}") <= 0) continue;
            this.getLogger().warn("Archetype uses ${" + property + "} for internal processing, but file " + initialPomFile + " contains this property already");
        }
    }

    private FileSet createFileSet(List excludes, boolean packaged, boolean filtered, String group, List includes, String defaultEncoding) {
        FileSet fileSet = new FileSet();
        fileSet.setDirectory(group);
        fileSet.setPackaged(packaged);
        fileSet.setFiltered(filtered);
        fileSet.setIncludes(includes);
        fileSet.setExcludes(excludes);
        fileSet.setEncoding(defaultEncoding);
        this.getLogger().debug("Created Fileset " + fileSet);
        return fileSet;
    }

    private List createFileSets(List files, int level, boolean packaged, String packageName, boolean filtered, String defaultEncoding) {
        ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
        if (!files.isEmpty()) {
            this.getLogger().debug("Creating filesets" + (packaged ? " packaged (" + packageName + ")" : "") + (filtered ? " filtered" : "") + " at level " + level);
            if (level == 0) {
                ArrayList<String> includes = new ArrayList<String>();
                ArrayList excludes = new ArrayList();
                Iterator filesIterator = files.iterator();
                while (filesIterator.hasNext()) {
                    String file = (String)filesIterator.next();
                    includes.add(file);
                }
                if (!includes.isEmpty()) {
                    fileSets.add(this.createFileSet(excludes, packaged, filtered, "", includes, defaultEncoding));
                }
            } else {
                Map groups = this.getGroupsMap(files, level);
                Iterator groupIterator = groups.keySet().iterator();
                while (groupIterator.hasNext()) {
                    String group = (String)groupIterator.next();
                    this.getLogger().debug("Creating filesets for group " + group);
                    if (!packaged) {
                        fileSets.add(this.getUnpackagedFileSet(filtered, group, (List)groups.get(group), defaultEncoding));
                        continue;
                    }
                    fileSets.addAll(this.getPackagedFileSets(filtered, group, (List)groups.get(group), packageName, defaultEncoding));
                }
            }
            this.getLogger().debug("Resolved fileSets " + fileSets);
        }
        return fileSets;
    }

    private ModuleDescriptor createModule(Properties reverseProperties, String rootArtifactId, String moduleId, String packageName, File basedir, File archetypeFilesDirectory, List languages, List filtereds, String defaultEncoding, boolean preserveCData, boolean keepParent) throws IOException, XmlPullParserException {
        ModuleDescriptor archetypeDescriptor = new ModuleDescriptor();
        this.getLogger().debug("Starting module's descriptor " + moduleId);
        archetypeFilesDirectory.mkdirs();
        this.getLogger().debug("Module's files output directory " + archetypeFilesDirectory);
        Model pom = this.pomManager.readPom(FileUtils.resolveFile((File)basedir, (String)"pom.xml"));
        String replacementId = pom.getArtifactId();
        String moduleDirectory = pom.getArtifactId();
        if (replacementId.indexOf(rootArtifactId) >= 0) {
            replacementId = StringUtils.replace((String)replacementId, (String)rootArtifactId, (String)"${rootArtifactId}");
            moduleDirectory = StringUtils.replace((String)moduleId, (String)rootArtifactId, (String)"__rootArtifactId__");
        }
        if (moduleId.indexOf(rootArtifactId) >= 0) {
            moduleDirectory = StringUtils.replace((String)moduleId, (String)rootArtifactId, (String)"__rootArtifactId__");
        }
        archetypeDescriptor.setName(replacementId);
        archetypeDescriptor.setId(replacementId);
        archetypeDescriptor.setDir(moduleDirectory);
        this.registerProject(pom);
        this.setArtifactId(reverseProperties, pom.getArtifactId());
        List fileNames = this.resolveFileNames(pom, basedir);
        List filesets = this.resolveFileSets(packageName, fileNames, languages, filtereds, defaultEncoding);
        this.getLogger().debug("Resolved filesets for module " + archetypeDescriptor.getName());
        archetypeDescriptor.setFileSets(filesets);
        this.createArchetypeFiles(reverseProperties, filesets, packageName, basedir, archetypeFilesDirectory, defaultEncoding);
        this.getLogger().debug("Created files for module " + archetypeDescriptor.getName());
        String parentArtifactId = reverseProperties.getProperty("parentArtifactId");
        this.setParentArtifactId(reverseProperties, pom.getArtifactId());
        Iterator modules = pom.getModules().iterator();
        while (modules.hasNext()) {
            String subModuleId;
            String subModuleIdDirectory = subModuleId = (String)modules.next();
            if (subModuleId.indexOf(rootArtifactId) >= 0) {
                subModuleIdDirectory = StringUtils.replace((String)subModuleId, (String)rootArtifactId, (String)"__rootArtifactId__");
            }
            this.getLogger().debug("Creating module " + subModuleId);
            ModuleDescriptor moduleDescriptor = this.createModule(reverseProperties, rootArtifactId, subModuleId, packageName, FileUtils.resolveFile((File)basedir, (String)subModuleId), FileUtils.resolveFile((File)archetypeFilesDirectory, (String)subModuleIdDirectory), languages, filtereds, defaultEncoding, preserveCData, keepParent);
            archetypeDescriptor.addModule(moduleDescriptor);
            this.getLogger().debug("Added module " + moduleDescriptor.getName() + " in " + archetypeDescriptor.getName());
        }
        this.restoreParentArtifactId(reverseProperties, parentArtifactId);
        this.restoreArtifactId(reverseProperties, pom.getArtifactId());
        this.getLogger().debug("Created Module " + archetypeDescriptor.getName() + " pom");
        return archetypeDescriptor;
    }

    private void createModulePom(Model pom, String rootArtifactId, File archetypeFilesDirectory, Properties pomReversedProperties, File initialPomFile, boolean preserveCData, boolean keepParent) throws IOException {
        File outputFile = FileUtils.resolveFile((File)archetypeFilesDirectory, (String)"pom.xml");
        if (preserveCData) {
            this.getLogger().debug("Preserving CDATA parts of pom");
            File inputFile = FileUtils.resolveFile((File)archetypeFilesDirectory, (String)"pom.xml.tmp");
            FileUtils.copyFile((File)initialPomFile, (File)inputFile);
            String initialcontent = FileUtils.fileRead((File)inputFile);
            String content = this.getReversedContent(initialcontent, pomReversedProperties);
            outputFile.getParentFile().mkdirs();
            FileUtils.fileWrite((String)outputFile.getAbsolutePath(), (String)content);
            inputFile.delete();
        } else {
            if (pom.getParent() != null) {
                pom.getParent().setGroupId(StringUtils.replace((String)pom.getParent().getGroupId(), (String)pomReversedProperties.getProperty("groupId"), (String)"${groupId}"));
                if (pom.getParent().getArtifactId() != null && pom.getParent().getArtifactId().indexOf(rootArtifactId) >= 0) {
                    pom.getParent().setArtifactId(StringUtils.replace((String)pom.getParent().getArtifactId(), (String)rootArtifactId, (String)"${rootArtifactId}"));
                }
                if (pom.getParent().getVersion() != null) {
                    pom.getParent().setVersion("${version}");
                }
            }
            pom.setModules(null);
            if (pom.getGroupId() != null) {
                pom.setGroupId(StringUtils.replace((String)pom.getGroupId(), (String)pomReversedProperties.getProperty("groupId"), (String)"${groupId}"));
            }
            pom.setArtifactId("${artifactId}");
            if (pom.getVersion() != null) {
                pom.setVersion("${version}");
            }
            this.rewriteReferences(pom, rootArtifactId, pomReversedProperties.getProperty("groupId"));
            this.pomManager.writePom(pom, outputFile, initialPomFile);
        }
        String initialcontent = FileUtils.fileRead((File)initialPomFile);
        Iterator<Object> properties = pomReversedProperties.keySet().iterator();
        while (properties.hasNext()) {
            String property = (String)properties.next();
            if (initialcontent.indexOf("${" + property + "}") <= 0) continue;
            this.getLogger().warn("OldArchetype uses ${" + property + "} for internal processing, but file " + initialPomFile + " contains this property already");
        }
    }

    private void createReplicaFiles(List filesets, File basedir, File replicaFilesDirectory) throws IOException {
        this.getLogger().debug("Creating OldArchetype/Module replica files from " + basedir + " to " + replicaFilesDirectory);
        this.copyPom(basedir, replicaFilesDirectory);
        Iterator iterator = filesets.iterator();
        while (iterator.hasNext()) {
            FileSet fileset = (FileSet)iterator.next();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(basedir);
            scanner.setIncludes(this.concatenateToList(fileset.getIncludes(), fileset.getDirectory()).toArray(new String[fileset.getIncludes().size()]));
            scanner.setExcludes(fileset.getExcludes().toArray(new String[fileset.getExcludes().size()]));
            scanner.addDefaultExcludes();
            this.getLogger().debug("Using fileset " + fileset);
            scanner.scan();
            List<String> fileSetResources = Arrays.asList(scanner.getIncludedFiles());
            this.copyFiles(basedir, replicaFilesDirectory, fileset.getDirectory(), fileSetResources, false, null);
            this.getLogger().debug("Copied " + fileset.getDirectory() + " files");
        }
    }

    private Set getExtensions(List files) {
        HashSet<String> extensions = new HashSet<String>();
        Iterator filesIterator = files.iterator();
        while (filesIterator.hasNext()) {
            String file = (String)filesIterator.next();
            extensions.add(FileUtils.extension((String)file));
        }
        return extensions;
    }

    private String getGeneratedSourcesDirectory() {
        return "target" + File.separator + "generated-sources" + File.separator + "archetype";
    }

    private Map getGroupsMap(List files, int level) {
        HashMap groups = new HashMap();
        Iterator fileIterator = files.iterator();
        while (fileIterator.hasNext()) {
            String file = (String)fileIterator.next();
            String directory = PathUtils.getDirectory(file, level);
            if (!groups.containsKey(directory = StringUtils.replace((String)directory, (String)File.separator, (String)"/"))) {
                groups.put(directory, new ArrayList());
            }
            List group = (List)groups.get(directory);
            String innerPath = file.substring(directory.length() + 1);
            innerPath = StringUtils.replace((String)innerPath, (String)File.separator, (String)"/");
            group.add(innerPath);
        }
        this.getLogger().debug("Sorted " + groups.size() + " groups in " + files.size() + " files");
        this.getLogger().debug("Sorted Files:" + files);
        return groups;
    }

    private FileSet getPackagedFileSet(boolean filtered, Set packagedExtensions, String group, Set unpackagedExtensions, List unpackagedFiles, String defaultEncoding) {
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList excludes = new ArrayList();
        Iterator extensionsIterator = packagedExtensions.iterator();
        while (extensionsIterator.hasNext()) {
            String extension = (String)extensionsIterator.next();
            includes.add("**/*." + extension);
            if (!unpackagedExtensions.contains(extension)) continue;
            excludes.addAll(this.archetypeFilesResolver.getFilesWithExtension(unpackagedFiles, extension));
        }
        FileSet fileset = this.createFileSet(excludes, true, filtered, group, includes, defaultEncoding);
        return fileset;
    }

    private List getPackagedFileSets(boolean filtered, String group, List groupFiles, String packageName, String defaultEncoding) {
        String packageAsDir = StringUtils.replace((String)packageName, (String)".", (String)"/");
        ArrayList<FileSet> packagedFileSets = new ArrayList<FileSet>();
        List packagedFiles = this.archetypeFilesResolver.getPackagedFiles(groupFiles, packageAsDir);
        this.getLogger().debug("Found packaged Files:" + packagedFiles);
        List unpackagedFiles = this.archetypeFilesResolver.getUnpackagedFiles(groupFiles, packageAsDir);
        this.getLogger().debug("Found unpackaged Files:" + unpackagedFiles);
        Set packagedExtensions = this.getExtensions(packagedFiles);
        this.getLogger().debug("Found packaged extensions " + packagedExtensions);
        Set unpackagedExtensions = this.getExtensions(unpackagedFiles);
        if (!packagedExtensions.isEmpty()) {
            packagedFileSets.add(this.getPackagedFileSet(filtered, packagedExtensions, group, unpackagedExtensions, unpackagedFiles, defaultEncoding));
        }
        if (!unpackagedExtensions.isEmpty()) {
            this.getLogger().debug("Found unpackaged extensions " + unpackagedExtensions);
            packagedFileSets.add(this.getUnpackagedFileSet(filtered, unpackagedExtensions, unpackagedFiles, group, packagedExtensions, defaultEncoding));
        }
        return packagedFileSets;
    }

    private void setParentArtifactId(Properties properties, String parentArtifactId) {
        properties.setProperty("parentArtifactId", parentArtifactId);
    }

    private void processFileSet(File basedir, File archetypeFilesDirectory, String directory, List fileSetResources, boolean packaged, String packageName, Properties reverseProperties, String defaultEncoding) throws IOException {
        String packageAsDirectory = StringUtils.replace((String)packageName, (String)".", (String)File.separator);
        this.getLogger().debug("Package as Directory: Package:" + packageName + "->" + packageAsDirectory);
        Iterator iterator = fileSetResources.iterator();
        while (iterator.hasNext()) {
            String inputFileName = (String)iterator.next();
            String outputFileName = packaged ? StringUtils.replace((String)inputFileName, (String)(packageAsDirectory + File.separator), (String)"") : inputFileName;
            this.getLogger().debug("InputFileName:" + inputFileName);
            this.getLogger().debug("OutputFileName:" + outputFileName);
            File outputFile = new File(archetypeFilesDirectory, outputFileName);
            File inputFile = new File(basedir, inputFileName);
            FileCharsetDetector detector = new FileCharsetDetector(inputFile);
            String fileEncoding = detector.isFound() ? detector.getCharset() : defaultEncoding;
            String initialcontent = IOUtils.toString((InputStream)new FileInputStream(inputFile), (String)fileEncoding);
            Iterator<Object> properties = reverseProperties.keySet().iterator();
            while (properties.hasNext()) {
                String property = (String)properties.next();
                if (initialcontent.indexOf("${" + property + "}") <= 0) continue;
                this.getLogger().warn("Archetype uses ${" + property + "} for internal processing, but file " + inputFile + " contains this property already");
            }
            String content = this.getReversedContent(initialcontent, reverseProperties);
            outputFile.getParentFile().mkdirs();
            IOUtils.write((String)content, (OutputStream)new FileOutputStream(outputFile), (String)fileEncoding);
        }
    }

    private List removePackage(List sources, String packageAsDirectory) {
        if (sources == null) {
            return null;
        }
        ArrayList<String> unpackagedSources = new ArrayList<String>(sources.size());
        Iterator sourcesIterator = sources.iterator();
        while (sourcesIterator.hasNext()) {
            String source = (String)sourcesIterator.next();
            String unpackagedSource = StringUtils.replace((String)source, (String)packageAsDirectory, (String)"");
            unpackagedSources.add(unpackagedSource);
        }
        return unpackagedSources;
    }

    private Properties getRequiredProperties(ArchetypeDescriptor archetypeDescriptor, Properties properties) {
        Properties reversedProperties = new Properties();
        reversedProperties.putAll((Map<?, ?>)properties);
        reversedProperties.remove("archetype.groupId");
        reversedProperties.remove("archetype.artifactId");
        reversedProperties.remove("archetype.version");
        reversedProperties.setProperty("packageInPathFormat", this.getPackageInPathFormat(properties.getProperty("package")));
        return reversedProperties;
    }

    private List resolveFileNames(Model pom, File basedir) throws IOException {
        this.getLogger().debug("Resolving files for " + pom.getId() + " in " + basedir);
        Iterator modules = pom.getModules().iterator();
        String excludes = "pom.xml*,archetype.properties*,target/**,";
        while (modules.hasNext()) {
            excludes = excludes + "," + (String)modules.next() + "/**";
        }
        Iterator<String> defaultExcludes = Arrays.asList(ListScanner.DEFAULTEXCLUDES).iterator();
        while (defaultExcludes.hasNext()) {
            excludes = excludes + "," + defaultExcludes.next() + "/**";
        }
        excludes = PathUtils.convertPathForOS(excludes);
        List fileNames = FileUtils.getFileNames((File)basedir, (String)"**,.*,**/.*", (String)excludes, (boolean)false);
        this.getLogger().debug("Resolved " + fileNames.size() + " files");
        this.getLogger().debug("Resolved Files:" + fileNames);
        return fileNames;
    }

    private List resolveFileSets(String packageName, List fileNames, List languages, List filtereds, String defaultEncoding) {
        List rootResourcesfiles;
        List secondLevelResourcesfiles;
        List secondLevelSourcesfiles;
        List thirdLevelSourcesfiles;
        List siteFiles;
        List resourcesTestFiles;
        List sourcesTestFiles;
        List resourcesMainFiles;
        ArrayList resolvedFileSets = new ArrayList();
        this.getLogger().debug("Resolving filesets with package=" + packageName + ", languages=" + languages + " and extentions=" + filtereds);
        ArrayList files = new ArrayList(fileNames);
        String languageIncludes = "";
        Iterator languagesIterator = languages.iterator();
        while (languagesIterator.hasNext()) {
            String language = (String)languagesIterator.next();
            languageIncludes = languageIncludes + (languageIncludes.length() == 0 ? "" : ",") + language + "/**";
        }
        this.getLogger().debug("Using languages includes " + languageIncludes);
        String filteredIncludes = "";
        Iterator filteredsIterator = filtereds.iterator();
        while (filteredsIterator.hasNext()) {
            String filtered = (String)filteredsIterator.next();
            filteredIncludes = filteredIncludes + (filteredIncludes.length() == 0 ? "" : ",") + "**/" + (filtered.startsWith(".") ? "" : "*.") + filtered;
        }
        this.getLogger().debug("Using filtered includes " + filteredIncludes);
        List sourcesMainFiles = this.archetypeFilesResolver.findSourcesMainFiles(files, languageIncludes);
        if (!sourcesMainFiles.isEmpty()) {
            files.removeAll(sourcesMainFiles);
            List filteredFiles = this.archetypeFilesResolver.getFilteredFiles(sourcesMainFiles, filteredIncludes);
            sourcesMainFiles.removeAll(filteredFiles);
            List unfilteredFiles = sourcesMainFiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 3, true, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 3, true, packageName, false, defaultEncoding));
            }
        }
        if (!(resourcesMainFiles = this.archetypeFilesResolver.findResourcesMainFiles(files, languageIncludes)).isEmpty()) {
            files.removeAll(resourcesMainFiles);
            List filteredFiles = this.archetypeFilesResolver.getFilteredFiles(resourcesMainFiles, filteredIncludes);
            resourcesMainFiles.removeAll(filteredFiles);
            List unfilteredFiles = resourcesMainFiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 3, false, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 3, false, packageName, false, defaultEncoding));
            }
        }
        if (!(sourcesTestFiles = this.archetypeFilesResolver.findSourcesTestFiles(files, languageIncludes)).isEmpty()) {
            files.removeAll(sourcesTestFiles);
            List filteredFiles = this.archetypeFilesResolver.getFilteredFiles(sourcesTestFiles, filteredIncludes);
            sourcesTestFiles.removeAll(filteredFiles);
            List unfilteredFiles = sourcesTestFiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 3, true, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 3, true, packageName, false, defaultEncoding));
            }
        }
        if (!(resourcesTestFiles = this.archetypeFilesResolver.findResourcesTestFiles(files, languageIncludes)).isEmpty()) {
            files.removeAll(resourcesTestFiles);
            List filteredFiles = this.archetypeFilesResolver.getFilteredFiles(resourcesTestFiles, filteredIncludes);
            resourcesTestFiles.removeAll(filteredFiles);
            List unfilteredFiles = resourcesTestFiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 3, false, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 3, false, packageName, false, defaultEncoding));
            }
        }
        if (!(siteFiles = this.archetypeFilesResolver.findSiteFiles(files, languageIncludes)).isEmpty()) {
            files.removeAll(siteFiles);
            List filteredFiles = this.archetypeFilesResolver.getFilteredFiles(siteFiles, filteredIncludes);
            siteFiles.removeAll(filteredFiles);
            List unfilteredFiles = siteFiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 2, false, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 2, false, packageName, false, defaultEncoding));
            }
        }
        if (!(thirdLevelSourcesfiles = this.archetypeFilesResolver.findOtherSources(3, files, languageIncludes)).isEmpty()) {
            List thirdLevelResourcesfiles;
            files.removeAll(thirdLevelSourcesfiles);
            List filteredFiles = this.archetypeFilesResolver.getFilteredFiles(thirdLevelSourcesfiles, filteredIncludes);
            thirdLevelSourcesfiles.removeAll(filteredFiles);
            List unfilteredFiles = thirdLevelSourcesfiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 3, true, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 3, true, packageName, false, defaultEncoding));
            }
            if (!(thirdLevelResourcesfiles = this.archetypeFilesResolver.findOtherResources(3, files, thirdLevelSourcesfiles, languageIncludes)).isEmpty()) {
                files.removeAll(thirdLevelResourcesfiles);
                filteredFiles = this.archetypeFilesResolver.getFilteredFiles(thirdLevelResourcesfiles, filteredIncludes);
                thirdLevelResourcesfiles.removeAll(filteredFiles);
                unfilteredFiles = thirdLevelResourcesfiles;
                if (!filteredFiles.isEmpty()) {
                    resolvedFileSets.addAll(this.createFileSets(filteredFiles, 3, false, packageName, true, defaultEncoding));
                }
                if (!unfilteredFiles.isEmpty()) {
                    resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 3, false, packageName, false, defaultEncoding));
                }
            }
        }
        if (!(secondLevelSourcesfiles = this.archetypeFilesResolver.findOtherSources(2, files, languageIncludes)).isEmpty()) {
            files.removeAll(secondLevelSourcesfiles);
            List filteredFiles = this.archetypeFilesResolver.getFilteredFiles(secondLevelSourcesfiles, filteredIncludes);
            secondLevelSourcesfiles.removeAll(filteredFiles);
            List unfilteredFiles = secondLevelSourcesfiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 2, true, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 2, true, packageName, false, defaultEncoding));
            }
        }
        if (!(secondLevelResourcesfiles = this.archetypeFilesResolver.findOtherResources(2, files, languageIncludes)).isEmpty()) {
            files.removeAll(secondLevelResourcesfiles);
            List filteredFiles = this.archetypeFilesResolver.getFilteredFiles(secondLevelResourcesfiles, filteredIncludes);
            secondLevelResourcesfiles.removeAll(filteredFiles);
            List unfilteredFiles = secondLevelResourcesfiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 2, false, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 2, false, packageName, false, defaultEncoding));
            }
        }
        if (!(rootResourcesfiles = this.archetypeFilesResolver.findOtherResources(0, files, languageIncludes)).isEmpty()) {
            files.removeAll(rootResourcesfiles);
            List filteredFiles = this.archetypeFilesResolver.getFilteredFiles(rootResourcesfiles, filteredIncludes);
            rootResourcesfiles.removeAll(filteredFiles);
            List unfilteredFiles = rootResourcesfiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 0, false, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 0, false, packageName, false, defaultEncoding));
            }
        }
        if (!files.isEmpty()) {
            this.getLogger().info("Ignored files: " + files);
        }
        return resolvedFileSets;
    }

    private void restoreArtifactId(Properties properties, String artifactId) {
        if (StringUtils.isEmpty((String)artifactId)) {
            properties.remove("artifactId");
        } else {
            properties.setProperty("artifactId", artifactId);
        }
    }

    private void restoreParentArtifactId(Properties properties, String parentArtifactId) {
        if (StringUtils.isEmpty((String)parentArtifactId)) {
            properties.remove("parentArtifactId");
        } else {
            properties.setProperty("parentArtifactId", parentArtifactId);
        }
    }

    private String getReversedContent(String content, Properties properties) {
        String result = StringUtils.replace((String)StringUtils.replace((String)content, (String)"$", (String)"${symbol_dollar}"), (String)"\\", (String)"${symbol_escape}");
        Iterator<Object> propertyIterator = properties.keySet().iterator();
        while (propertyIterator.hasNext()) {
            String propertyKey = (String)propertyIterator.next();
            result = StringUtils.replace((String)result, (String)properties.getProperty(propertyKey), (String)("${" + propertyKey + "}"));
        }
        return "#set( $symbol_pound = '#' )\n#set( $symbol_dollar = '$' )\n#set( $symbol_escape = '\\' )\n" + StringUtils.replace((String)result, (String)"#", (String)"${symbol_pound}");
    }

    private String getTemplateOutputDirectory() {
        return "src" + File.separator + "main" + File.separator + "resources";
    }

    private FileSet getUnpackagedFileSet(boolean filtered, String group, List groupFiles, String defaultEncoding) {
        Set extensions = this.getExtensions(groupFiles);
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList excludes = new ArrayList();
        Iterator extensionsIterator = extensions.iterator();
        while (extensionsIterator.hasNext()) {
            String extension = (String)extensionsIterator.next();
            includes.add("**/*." + extension);
        }
        return this.createFileSet(excludes, false, filtered, group, includes, defaultEncoding);
    }

    private FileSet getUnpackagedFileSet(boolean filtered, Set unpackagedExtensions, List unpackagedFiles, String group, Set packagedExtensions, String defaultEncoding) {
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList excludes = new ArrayList();
        Iterator extensionsIterator = unpackagedExtensions.iterator();
        while (extensionsIterator.hasNext()) {
            String extension = (String)extensionsIterator.next();
            if (packagedExtensions.contains(extension)) {
                includes.addAll(this.archetypeFilesResolver.getFilesWithExtension(unpackagedFiles, extension));
                continue;
            }
            includes.add("**/*." + extension);
        }
        return this.createFileSet(excludes, false, filtered, group, includes, defaultEncoding);
    }

    private void writeOldDescriptor(OldArchetypeDescriptor oldDescriptor, File oldDescriptorFile) throws IOException {
        OldArchetypeDescriptorXpp3Writer writer = new OldArchetypeDescriptorXpp3Writer();
        writer.write(new FileWriter(oldDescriptorFile), oldDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getArchetypeVersion() {
        String string;
        InputStream is = null;
        String version = "version";
        try {
            Properties properties = new Properties();
            is = this.getClass().getClassLoader().getResourceAsStream(MAVEN_PROPERTIES);
            if (is != null) {
                properties.load(is);
                String property = properties.getProperty("version");
                if (property != null) {
                    String string2 = property;
                    IOUtil.close((InputStream)is);
                    return string2;
                }
            }
            string = version;
            IOUtil.close((InputStream)is);
        }
        catch (IOException e) {
            string = version;
            return string;
        }
        finally {
            IOUtil.close(is);
        }
        return string;
    }
}

