/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor;

import com.fusesource.rider.commons.tree.HasOwner;
import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.editor.Activator;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.AbstractNodeFacade;
import com.fusesource.rider.model.Endpoint;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.RouteSupport;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.ui.internal.parts.ContainerShapeEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AbstractNodes {
    public static AbstractNode getSelectedNode(ISelection selection) {
        AbstractNode answer = null;
        if (selection instanceof IStructuredSelection) {
            Object input = ((IStructuredSelection)selection).getFirstElement();
            answer = AbstractNodes.toAbstractNode(input);
        }
        return answer;
    }

    public static AbstractNode toAbstractNode(Object input) {
        ContainerShapeEditPart editPart;
        AbstractNode answer = null;
        if (input instanceof AbstractNode) {
            return (AbstractNode)input;
        }
        if (input instanceof AbstractNodeFacade) {
            AbstractNodeFacade facade = (AbstractNodeFacade)input;
            answer = facade.getAbstractNode();
        } else if (input instanceof ContainerShapeEditPart) {
            editPart = (ContainerShapeEditPart)input;
            PictogramElement element = editPart.getPictogramElement();
            if (element != null) {
                PictogramLink link = element.getLink();
                if (link != null) {
                    EList businessObjects = link.getBusinessObjects();
                    if (businessObjects != null && businessObjects.size() > 0) {
                        answer = AbstractNodes.toAbstractNode(businessObjects.get(0));
                    }
                } else {
                    answer = Activator.getDiagramEditor() != null ? Activator.getDiagramEditor().getSelectedRoute() : null;
                }
            }
        } else if (input instanceof AbstractEditPart) {
            editPart = (AbstractEditPart)input;
            Object model = editPart.getModel();
            answer = AbstractNodes.toAbstractNode(model);
        } else if (input instanceof ContainerShape) {
            ContainerShape shape = (ContainerShape)input;
            EObject container = shape.eContainer();
            answer = AbstractNodes.toAbstractNode(container);
        }
        if (input != null && answer == null) {
            answer = (AbstractNode)Platform.getAdapterManager().getAdapter(input, AbstractNode.class);
        }
        if (answer == null && input instanceof HasOwner) {
            HasOwner ho = (HasOwner)input;
            answer = AbstractNodes.toAbstractNode(ho.getOwner());
        }
        return answer;
    }

    public static RouteSupport getRoute(AbstractNode node) {
        if (node instanceof RouteSupport) {
            return (RouteSupport)node;
        }
        if (node instanceof RouteContainer) {
            return null;
        }
        if (node != null) {
            return AbstractNodes.getRoute((AbstractNode)node.getParent());
        }
        return null;
    }

    public static Set<Endpoint> getAllEndpoints(AbstractNode node) {
        RouteSupport route;
        if (node != null && (route = AbstractNodes.getRoute(node)) != null) {
            Set endpoints = route.getEndpoints();
            RouteContainer parent = route.getParent();
            if (parent != null) {
                String[] endpointUris;
                Set set = parent.getEndpoints();
                String[] stringArray = endpointUris = parent.getEndpointUris();
                int n = endpointUris.length;
                int n2 = 0;
                while (n2 < n) {
                    String uri = stringArray[n2];
                    if (!AbstractNodes.containsUri(set, uri)) {
                        Endpoint endpoint = new Endpoint();
                        endpoint.setUri(uri);
                        endpoints.add(endpoint);
                    }
                    ++n2;
                }
                endpoints.addAll(set);
            }
            return endpoints;
        }
        return Collections.EMPTY_SET;
    }

    private static boolean containsUri(Set<Endpoint> set, final String uri) {
        return Iterables.any(set, (Predicate)new Predicate<Endpoint>(){

            public boolean apply(Endpoint endpoint) {
                return Objects.equal((Object)uri, (Object)endpoint.getUri());
            }
        });
    }

    public static SortedMap<String, String> getAllBeans(AbstractNode node) {
        Map map;
        RouteSupport route;
        TreeMap<String, String> answer = new TreeMap<String, String>();
        if (node != null && (route = AbstractNodes.getRoute(node)) != null && (map = route.getBeans()) != null) {
            answer.putAll(map);
        }
        return answer;
    }
}

