/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.commands;

import com.fusesource.rider.editor.EditorMessages;
import com.fusesource.rider.editor.editor.RiderDesignEditor;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.RouteSupport;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeleteRouteCommand
extends RecordingCommand {
    private final RiderDesignEditor designEditor;
    private final RouteSupport selectedRoute;

    public DeleteRouteCommand(RiderDesignEditor designEditor, TransactionalEditingDomain editingDomain, RouteSupport selectedRoute) {
        super(editingDomain);
        this.designEditor = designEditor;
        this.selectedRoute = selectedRoute;
    }

    protected void doExecute() {
        boolean deleteIt;
        if (this.selectedRoute != null && (deleteIt = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)EditorMessages.deleteRouteCommandLabel, (String)EditorMessages.deleteRouteCommandDescription))) {
            RouteContainer model = this.designEditor.getModel();
            model.removeChild((AbstractNode)this.selectedRoute);
            RouteSupport newRoute = null;
            if (model.getChildren().size() < 1) {
                this.designEditor.addNewRoute();
                this.designEditor.getEditor().recreateDesignPage();
            }
            newRoute = (RouteSupport)model.getChildren().get(0);
            this.designEditor.clearSelectedRouteCache();
            this.designEditor.setSelectedRoute(newRoute);
            this.designEditor.refreshContent();
        }
    }
}

