/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.commands;

import com.fusesource.rider.editor.commands.AddNewRouteCommand;
import com.fusesource.rider.editor.commands.AddNodeCommand;
import com.fusesource.rider.editor.commands.ChangeGridColorCommand;
import com.fusesource.rider.editor.commands.DeleteNodeCommand;
import com.fusesource.rider.editor.commands.DeleteRouteCommand;
import com.fusesource.rider.editor.commands.LayoutCommand;
import com.fusesource.rider.editor.commands.UpdateCommand;
import com.fusesource.rider.editor.editor.RiderDesignEditor;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteSupport;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.ui.editor.DiagramEditorFactory;

public class DiagramOperations {
    public static LayoutCommand layoutDiagram(RiderDesignEditor designEditor) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        LayoutCommand operation = new LayoutCommand(designEditor, editingDomain);
        DiagramOperations.execute(editingDomain, operation, false);
        return operation;
    }

    public static UpdateCommand updateSelectedNode(RiderDesignEditor designEditor) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        UpdateCommand operation = new UpdateCommand(designEditor, editingDomain, designEditor.getSelectedNode());
        DiagramOperations.execute(editingDomain, operation, true);
        return operation;
    }

    public static UpdateCommand updateDiagram(RiderDesignEditor designEditor) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        UpdateCommand operation = new UpdateCommand(designEditor, editingDomain, (AbstractNode)designEditor.getSelectedRoute());
        DiagramOperations.execute(editingDomain, operation, true);
        return operation;
    }

    public static AddNodeCommand addNode(RiderDesignEditor designEditor, Class<? extends AbstractNode> aClass, AbstractNode selectedNode) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        AddNodeCommand operation = new AddNodeCommand(designEditor, editingDomain, aClass, selectedNode);
        DiagramOperations.execute(editingDomain, operation, true);
        return operation;
    }

    public static AddNewRouteCommand addNewRoute(RiderDesignEditor designEditor) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        AddNewRouteCommand operation = new AddNewRouteCommand(designEditor, editingDomain);
        DiagramOperations.execute(editingDomain, operation, true);
        return operation;
    }

    public static DeleteRouteCommand deleteRoute(RiderDesignEditor designEditor, RouteSupport selectedRoute) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        DeleteRouteCommand operation = new DeleteRouteCommand(designEditor, editingDomain, selectedRoute);
        DiagramOperations.execute(editingDomain, operation, true);
        return operation;
    }

    public static DeleteNodeCommand deleteNode(RiderDesignEditor designEditor, AbstractNode selectedNode) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        DeleteNodeCommand operation = new DeleteNodeCommand(designEditor, editingDomain, selectedNode);
        DiagramOperations.execute(editingDomain, operation, true);
        return operation;
    }

    public static void execute(TransactionalEditingDomain editingDomain, RecordingCommand operation, boolean modelChanged) {
        editingDomain.getCommandStack().execute((Command)operation);
        if (!modelChanged) {
            editingDomain.getCommandStack().flush();
        }
    }

    protected static synchronized TransactionalEditingDomain createEditingDomain(RiderDesignEditor designEditor) {
        IDiagramEditor diagramEditor;
        TransactionalEditingDomain editingDomain = designEditor.getEditingDomain();
        Diagram diagram = designEditor.getDiagram();
        if (editingDomain == null && (diagramEditor = designEditor.getDiagramTypeProvider().getDiagramEditor()) != null) {
            editingDomain = diagramEditor.getEditingDomain();
        }
        if (editingDomain == null) {
            ResourceSet resourceSet = null;
            Resource eResource = diagram.eResource();
            if (eResource != null) {
                resourceSet = eResource.getResourceSet();
            }
            if (resourceSet == null) {
                resourceSet = new ResourceSetImpl();
            }
            if ((editingDomain = TransactionUtil.getEditingDomain((ResourceSet)resourceSet)) == null) {
                editingDomain = DiagramEditorFactory.createResourceSetAndEditingDomain();
            }
        }
        if (designEditor.getEditingDomain() == null) {
            designEditor.setEditingDomain(editingDomain);
        }
        return editingDomain;
    }

    public static ChangeGridColorCommand updateGridColor(RiderDesignEditor designEditor) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        ChangeGridColorCommand operation = new ChangeGridColorCommand(designEditor, editingDomain);
        DiagramOperations.execute(editingDomain, operation, false);
        return operation;
    }
}

