/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.editor;

import com.fusesource.rider.editor.features.create.CreateFlowFeature;
import com.fusesource.rider.editor.utils.DiagramUtils;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteSupport;
import java.util.List;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CamelModelLoader {
    private Diagram diagram;
    private IFeatureProvider featureProvider;

    public CamelModelLoader(Diagram diagram, IFeatureProvider featureProvider) {
        this.diagram = diagram;
        this.featureProvider = featureProvider;
    }

    public void loadModel(RouteSupport route) {
        if (route == null) {
            return;
        }
        List children = route.getRootNodes();
        int x = 40;
        int y = 40;
        for (AbstractNode node : children) {
            y = this.addProcessor((AbstractNode)route, node, x, y);
        }
    }

    private int addProcessor(AbstractNode route, AbstractNode node, int x, int y) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)node);
        addContext.setTargetContainer((ContainerShape)this.diagram);
        addContext.setX(x);
        addContext.setY(y);
        y += 100;
        IAddFeature addFeature = this.featureProvider.getAddFeature((IAddContext)addContext);
        if (addFeature.canAdd((IAddContext)addContext)) {
            PictogramElement destState = addFeature.add((IAddContext)addContext);
            if (!(route instanceof RouteSupport)) {
                route.removeConnection(node);
                CreateFlowFeature createFeature = new CreateFlowFeature(this.featureProvider);
                CreateConnectionContext connectContext = new CreateConnectionContext();
                PictogramElement srcState = this.featureProvider.getPictogramElementForBusinessObject((Object)route);
                if (srcState == destState) {
                    System.out.println("Should not be the same element for different nodes: " + route + " and " + node);
                }
                connectContext.setSourcePictogramElement(srcState);
                connectContext.setTargetPictogramElement(destState);
                Anchor srcAnchor = DiagramUtils.getAnchor(srcState);
                Anchor destAnchor = DiagramUtils.getAnchor(destState);
                if (srcAnchor != null && destAnchor != null) {
                    connectContext.setSourceAnchor(srcAnchor);
                    connectContext.setTargetAnchor(destAnchor);
                    if (createFeature.canCreate((ICreateConnectionContext)connectContext)) {
                        createFeature.execute((IContext)connectContext);
                    }
                }
            }
            List children = node.getOutputs();
            for (AbstractNode child : children) {
                y = this.addProcessor(node, child, x, y);
            }
        } else {
            System.out.println("Cannot add node: " + node);
        }
        return y;
    }
}

